/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.launcher.daemon.DaemonExecHandleBuilder;
import org.gradle.launcher.daemon.bootstrap.DaemonOutputConsumer;
import org.gradle.launcher.daemon.bootstrap.GradleDaemon;
import org.gradle.launcher.daemon.client.DaemonGreeter;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.JvmVersionValidator;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.toolchain.DaemonJavaToolchainQueryService;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JvmOptions;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.IncubationLogger;

public class DefaultDaemonStarter
implements DaemonStarter {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonStarter.class);
    private final DaemonDir daemonDir;
    private final DaemonParameters daemonParameters;
    private final DaemonGreeter daemonGreeter;
    private final JvmVersionValidator versionValidator;
    private final DaemonJavaToolchainQueryService daemonJavaToolchainQueryService;

    public DefaultDaemonStarter(DaemonDir daemonDir, DaemonParameters daemonParameters, DaemonGreeter daemonGreeter, JvmVersionValidator versionValidator, DaemonJavaToolchainQueryService daemonJavaToolchainQueryService) {
        this.daemonDir = daemonDir;
        this.daemonParameters = daemonParameters;
        this.daemonGreeter = daemonGreeter;
        this.versionValidator = versionValidator;
        this.daemonJavaToolchainQueryService = daemonJavaToolchainQueryService;
    }

    @Override
    public DaemonStartupInfo startDaemon(boolean singleUse) {
        List<Object> searchClassPath;
        ClassPath classpath;
        JavaInfo resolvedJvm;
        String daemonUid = UUID.randomUUID().toString();
        if (this.daemonParameters.getRequestedJvmCriteria() != null) {
            IncubationLogger.incubatingFeatureUsed((String)"Daemon JVM discovery");
            DaemonJvmCriteria criteria = this.daemonParameters.getRequestedJvmCriteria();
            JvmInstallationMetadata jvmInstallationMetadata = this.daemonJavaToolchainQueryService.findMatchingToolchain(criteria);
            resolvedJvm = Jvm.forHome(jvmInstallationMetadata.getJavaHome().toFile());
        } else {
            resolvedJvm = this.daemonParameters.getRequestedJvmBasedOnJavaHome() != null && this.daemonParameters.getRequestedJvmBasedOnJavaHome() != Jvm.current() ? Jvm.forHome(this.daemonParameters.getRequestedJvmBasedOnJavaHome().getJavaHome()) : Jvm.current();
        }
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        DefaultModuleRegistry registry = new DefaultModuleRegistry(gradleInstallation);
        if (gradleInstallation == null) {
            classpath = registry.getModule("gradle-launcher").getAllRequiredModulesClasspath();
            searchClassPath = registry.getAdditionalClassPath().getAsFiles();
        } else {
            classpath = registry.getModule("gradle-launcher").getImplementationClasspath();
            searchClassPath = Collections.emptyList();
        }
        if (classpath.isEmpty()) {
            throw new IllegalStateException("Unable to construct a bootstrap classpath when starting the daemon");
        }
        this.versionValidator.validate(resolvedJvm);
        ArrayList<String> daemonArgs = new ArrayList<String>();
        daemonArgs.addAll(this.getPriorityArgs(this.daemonParameters.getPriority()));
        daemonArgs.add(resolvedJvm.getJavaExecutable().getAbsolutePath());
        List<String> daemonOpts = this.daemonParameters.getEffectiveJvmArgs();
        daemonArgs.addAll(daemonOpts);
        daemonArgs.add("-cp");
        daemonArgs.add(CollectionUtils.join(File.pathSeparator, classpath.getAsFiles()));
        if (Boolean.getBoolean("org.gradle.daemon.debug")) {
            daemonArgs.add(JvmOptions.getDebugArgument((boolean)true, (boolean)true, (String)"5005"));
        }
        ClassPath agentClasspath = registry.getModule("gradle-instrumentation-agent").getImplementationClasspath();
        if (this.daemonParameters.shouldApplyInstrumentationAgent()) {
            if (agentClasspath.isEmpty()) {
                throw new IllegalStateException("Cannot find the agent JAR");
            }
            for (File agentJar : agentClasspath.getAsFiles()) {
                daemonArgs.add("-javaagent:" + agentJar);
            }
        }
        LOGGER.debug("Using daemon args: {}", daemonArgs);
        daemonArgs.add(GradleDaemon.class.getName());
        daemonArgs.add(GradleVersion.current().getVersion());
        StreamByteBuffer buffer = new StreamByteBuffer();
        KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new EncodedStream.EncodedOutput(buffer.getOutputStream()));
        try {
            encoder.writeString((CharSequence)this.daemonParameters.getGradleUserHomeDir().getAbsolutePath());
            encoder.writeString((CharSequence)this.daemonDir.getBaseDir().getAbsolutePath());
            encoder.writeSmallInt(this.daemonParameters.getIdleTimeout());
            encoder.writeSmallInt(this.daemonParameters.getPeriodicCheckInterval());
            encoder.writeBoolean(singleUse);
            encoder.writeSmallInt(this.daemonParameters.getNativeServicesMode().ordinal());
            encoder.writeString((CharSequence)daemonUid);
            encoder.writeSmallInt(this.daemonParameters.getPriority().ordinal());
            encoder.writeSmallInt(daemonOpts.size());
            for (String string : daemonOpts) {
                encoder.writeString((CharSequence)string);
            }
            encoder.writeSmallInt(searchClassPath.size());
            for (File file : searchClassPath) {
                encoder.writeString((CharSequence)file.getAbsolutePath());
            }
            encoder.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        InputStream stdInput = buffer.getInputStream();
        return this.startProcess(daemonArgs, this.daemonDir.getVersionedDir(), this.daemonParameters.getGradleUserHomeDir().getAbsoluteFile(), stdInput);
    }

    private List<String> getPriorityArgs(DaemonParameters.Priority priority) {
        if (priority == DaemonParameters.Priority.NORMAL) {
            return Collections.emptyList();
        }
        OperatingSystem os = OperatingSystem.current();
        if (os.isUnix()) {
            return Arrays.asList("nice", "-n", "10");
        }
        if (os.isWindows()) {
            return Arrays.asList("cmd", "/C", "start", "\"Gradle build daemon\"", "/B", "/belownormal", "/WAIT");
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaemonStartupInfo startProcess(List<String> args, File workingDir, File gradleUserHome, InputStream stdInput) {
        LOGGER.debug("Starting daemon process: workingDir = {}, daemonArgs: {}", (Object)workingDir, args);
        Timer clock = Time.startTimer();
        try {
            GFileUtils.mkdirs(workingDir);
            DaemonOutputConsumer outputConsumer = new DaemonOutputConsumer();
            DefaultExecActionFactory execActionFactory = DefaultExecActionFactory.root((File)gradleUserHome);
            try {
                ExecHandle handle = new DaemonExecHandleBuilder().build(args, workingDir, outputConsumer, stdInput, execActionFactory.newExec());
                handle.start();
                LOGGER.debug("Gradle daemon process is starting. Waiting for the daemon to detach...");
                handle.waitForFinish();
                LOGGER.debug("Gradle daemon process is now detached.");
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable(execActionFactory).stop();
                throw throwable;
            }
            CompositeStoppable.stoppable(execActionFactory).stop();
            DaemonStartupInfo daemonStartupInfo = this.daemonGreeter.parseDaemonOutput(outputConsumer.getProcessOutput(), args);
            return daemonStartupInfo;
        }
        catch (GradleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GradleException("Could not start Gradle daemon.", e);
        }
        finally {
            LOGGER.info("An attempt to start the daemon took {}.", (Object)clock.getElapsed());
        }
    }
}

