/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.serialization;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.configurationcache.ClassLoaderScopeSpec;
import org.gradle.configurationcache.serialization.ClassEncoder;
import org.gradle.configurationcache.serialization.ClassLoaderRole;
import org.gradle.configurationcache.serialization.CombinatorsKt;
import org.gradle.configurationcache.serialization.ScopeLookup;
import org.gradle.configurationcache.serialization.WriteContext;
import org.gradle.configurationcache.serialization.WriteIdentities;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.internal.hash.HashCode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t*\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0016\u0010\r\u001a\u00020\t*\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gradle/configurationcache/serialization/DefaultClassEncoder;", "Lorg/gradle/configurationcache/serialization/ClassEncoder;", "scopeLookup", "Lorg/gradle/configurationcache/serialization/ScopeLookup;", "(Lorg/gradle/configurationcache/serialization/ScopeLookup;)V", "classes", "Lorg/gradle/configurationcache/serialization/WriteIdentities;", "scopes", "encodeClass", "", "Lorg/gradle/configurationcache/serialization/WriteContext;", "type", "Ljava/lang/Class;", "writeHashCode", "hashCode", "Lorg/gradle/internal/hash/HashCode;", "writeScope", "scope", "Lorg/gradle/configurationcache/ClassLoaderScopeSpec;", "configuration-cache"})
public final class DefaultClassEncoder
implements ClassEncoder {
    @NotNull
    private final ScopeLookup scopeLookup;
    @NotNull
    private final WriteIdentities classes;
    @NotNull
    private final WriteIdentities scopes;

    public DefaultClassEncoder(@NotNull ScopeLookup scopeLookup) {
        Intrinsics.checkNotNullParameter((Object)scopeLookup, (String)"scopeLookup");
        this.scopeLookup = scopeLookup;
        this.classes = new WriteIdentities();
        this.scopes = new WriteIdentities();
    }

    @Override
    public void encodeClass(@NotNull WriteContext $this$encodeClass, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeClass, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Integer id = this.classes.getId(type);
        if (id != null) {
            $this$encodeClass.writeSmallInt(id);
        } else {
            Pair<ClassLoaderScopeSpec, ClassLoaderRole> scope = this.scopeLookup.scopeFor(type.getClassLoader());
            int newId = this.classes.putInstance(type);
            $this$encodeClass.writeSmallInt(newId);
            $this$encodeClass.writeString(type.getName());
            if (scope == null) {
                $this$encodeClass.writeBoolean(false);
            } else {
                $this$encodeClass.writeBoolean(true);
                this.writeScope($this$encodeClass, (ClassLoaderScopeSpec)scope.getFirst());
                $this$encodeClass.writeBoolean(((ClassLoaderRole)scope.getSecond()).unbox-impl());
            }
        }
    }

    private final void writeScope(WriteContext $this$writeScope, ClassLoaderScopeSpec scope) {
        Integer id = this.scopes.getId(scope);
        if (id != null) {
            $this$writeScope.writeSmallInt(id);
        } else {
            int newId = this.scopes.putInstance(scope);
            $this$writeScope.writeSmallInt(newId);
            if (scope.getParent() == null) {
                $this$writeScope.writeBoolean(false);
            } else {
                $this$writeScope.writeBoolean(true);
                this.writeScope($this$writeScope, scope.getParent());
            }
            $this$writeScope.writeString(scope.getName());
            if (scope.getOrigin() instanceof ClassLoaderScopeOrigin.Script) {
                $this$writeScope.writeBoolean(true);
                $this$writeScope.writeString(((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getFileName());
                $this$writeScope.writeString(((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getLongDisplayName().getDisplayName());
                $this$writeScope.writeString(((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getShortDisplayName().getDisplayName());
            } else {
                $this$writeScope.writeBoolean(false);
            }
            CombinatorsKt.writeClassPath($this$writeScope, scope.getLocalClassPath());
            this.writeHashCode($this$writeScope, scope.getLocalImplementationHash());
            CombinatorsKt.writeClassPath($this$writeScope, scope.getExportClassPath());
        }
    }

    private final void writeHashCode(WriteContext $this$writeHashCode, HashCode hashCode) {
        if (hashCode == null) {
            $this$writeHashCode.writeBoolean(false);
        } else {
            $this$writeHashCode.writeBoolean(true);
            $this$writeHashCode.writeBinary(hashCode.toByteArray());
        }
    }
}

