/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.ProfileReportRenderer;

@ServiceScope(value={Scope.BuildTree.class})
public class ReportGeneratingProfileListener {
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private final StyledTextOutputFactory textOutputFactory;
    private final BuildStateRegistry buildStateRegistry;

    public ReportGeneratingProfileListener(StyledTextOutputFactory textOutputFactory, BuildStateRegistry buildStateRegistry) {
        this.textOutputFactory = textOutputFactory;
        this.buildStateRegistry = buildStateRegistry;
    }

    public void buildFinished(BuildProfile buildProfile) {
        ProfileReportRenderer renderer = new ProfileReportRenderer();
        File file = new File(this.getBuildDir(), "reports/profile/profile-" + FILE_DATE_FORMAT.format(new Date(buildProfile.getBuildStarted())) + ".html");
        renderer.writeTo(buildProfile, file);
        this.renderReportUrl(file);
    }

    private File getBuildDir() {
        return (File)((ProjectLayout)this.buildStateRegistry.getRootBuild().getProjects().getRootProject().getMutableModel().getServices().get(ProjectLayout.class)).getBuildDirectory().getAsFile().get();
    }

    private void renderReportUrl(File reportFile) {
        StyledTextOutput textOutput = this.textOutputFactory.create(ReportGeneratingProfileListener.class, LogLevel.LIFECYCLE);
        textOutput.println();
        String reportUrl = new ConsoleRenderer().asClickableFileUrl(reportFile);
        textOutput.formatln("See the profiling report at: %s", new Object[]{reportUrl});
        textOutput.text((Object)"A fine-grained performance profile is available: use the ");
        textOutput.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
        textOutput.text((Object)" option.");
        textOutput.println();
    }
}

