/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import org.gradle.internal.Either;
import org.gradle.internal.logging.events.PromptOutputEvent;

public class SelectOptionPromptEvent
extends PromptOutputEvent {
    private final int optionCount;
    private final int defaultOption;

    public SelectOptionPromptEvent(long timestamp, String prompt, int optionCount, int defaultOption) {
        super(timestamp, prompt, true);
        this.optionCount = optionCount;
        this.defaultOption = defaultOption;
    }

    public int getOptionCount() {
        return this.optionCount;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public Either<Integer, String> convert(String text) {
        int value;
        if (text.isEmpty()) {
            return Either.left((Object)this.defaultOption);
        }
        String trimmed = text.trim();
        if (trimmed.matches("\\d+") && (value = Integer.parseInt(trimmed)) > 0 && value <= this.optionCount) {
            return Either.left((Object)value);
        }
        return Either.right((Object)("Please enter a value between 1 and " + this.optionCount + ": "));
    }
}

