/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import org.gradle.internal.Either;
import org.gradle.internal.logging.events.PromptOutputEvent;

public class IntQuestionPromptEvent
extends PromptOutputEvent {
    private final int minValue;
    private final int defaultValue;

    public IntQuestionPromptEvent(long timestamp, String prompt, int minValue, int defaultValue) {
        super(timestamp, prompt, true);
        this.minValue = minValue;
        this.defaultValue = defaultValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public Either<Integer, String> convert(String text) {
        if (text.isEmpty()) {
            return Either.left((Object)this.defaultValue);
        }
        String trimmed = text.trim();
        try {
            int result = Integer.parseInt(trimmed);
            if (result >= this.minValue) {
                return Either.left((Object)result);
            }
            return Either.right((Object)("Please enter an integer value >= " + this.minValue + " (default: " + this.defaultValue + "): "));
        }
        catch (NumberFormatException e) {
            return Either.right((Object)("Please enter an integer value (min: " + this.minValue + ", default: " + this.defaultValue + "): "));
        }
    }
}

