/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.ImmutableTransformWorkspaceServices;
import org.gradle.api.internal.artifacts.transform.MutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.MutableTransformWorkspaceServices;
import org.gradle.api.internal.artifacts.transform.NonNormalizedIdentityImmutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.NormalizedIdentityImmutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.artifacts.transform.TransformInvocationFactory;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultTransformInvocationFactory
implements TransformInvocationFactory {
    private final ExecutionEngine executionEngine;
    private final FileSystemAccess fileSystemAccess;
    private final TransformExecutionListener transformExecutionListener;
    private final ImmutableTransformWorkspaceServices immutableWorkspaceServices;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationProgressEventEmitter progressEventEmitter;

    public DefaultTransformInvocationFactory(ExecutionEngine executionEngine, FileSystemAccess fileSystemAccess, TransformExecutionListener transformExecutionListener, ImmutableTransformWorkspaceServices immutableWorkspaceServices, FileCollectionFactory fileCollectionFactory, ProjectStateRegistry projectStateRegistry, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter progressEventEmitter) {
        this.executionEngine = executionEngine;
        this.fileSystemAccess = fileSystemAccess;
        this.transformExecutionListener = transformExecutionListener;
        this.immutableWorkspaceServices = immutableWorkspaceServices;
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectStateRegistry = projectStateRegistry;
        this.buildOperationRunner = buildOperationRunner;
        this.progressEventEmitter = progressEventEmitter;
    }

    @Override
    public Deferrable<Try<ImmutableList<File>>> createInvocation(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, InputFingerprinter inputFingerprinter) {
        ExecutionEngine effectiveEngine;
        AbstractTransformExecution execution;
        Cache<UnitOfWork.Identity, ExecutionEngine.IdentityCacheResult<TransformExecutionResult.TransformWorkspaceResult>> identityCache;
        ProjectInternal producerProject = this.determineProducerProject(subject);
        if (producerProject == null) {
            identityCache = this.immutableWorkspaceServices.getIdentityCache();
            execution = new NonNormalizedIdentityImmutableTransformExecution(transform, inputArtifact, dependencies, subject, this.transformExecutionListener, this.buildOperationRunner, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, this.fileSystemAccess, this.immutableWorkspaceServices.getWorkspaceProvider());
            effectiveEngine = this.executionEngine;
        } else {
            effectiveEngine = (ExecutionEngine)producerProject.getServices().get(ExecutionEngine.class);
            if (!transform.requiresInputChanges()) {
                identityCache = this.immutableWorkspaceServices.getIdentityCache();
                execution = new NormalizedIdentityImmutableTransformExecution(transform, inputArtifact, dependencies, subject, this.transformExecutionListener, this.buildOperationRunner, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, this.immutableWorkspaceServices.getWorkspaceProvider());
            } else {
                MutableTransformWorkspaceServices workspaceServices = (MutableTransformWorkspaceServices)producerProject.getServices().get(MutableTransformWorkspaceServices.class);
                identityCache = workspaceServices.getIdentityCache();
                execution = new MutableTransformExecution(transform, inputArtifact, dependencies, subject, producerProject, this.transformExecutionListener, this.buildOperationRunner, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, workspaceServices.getWorkspaceProvider());
            }
        }
        return effectiveEngine.createRequest((UnitOfWork)execution).executeDeferred(identityCache).map(result -> result.map(successfulResult -> successfulResult.resolveForInputArtifact(inputArtifact)).mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure)));
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformStepSubject subject) {
        ComponentIdentifier componentIdentifier = subject.getInitialComponentIdentifier();
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            return this.projectStateRegistry.stateFor((ProjectComponentIdentifier)componentIdentifier).getMutableModel();
        }
        return null;
    }
}

