/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.userinput;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.userinput.AbstractUserInputHandler;
import org.gradle.api.internal.tasks.userinput.Choice;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.TextUtil;

public class DefaultUserInputHandler
extends AbstractUserInputHandler {
    private static final List<String> YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no"});
    private static final List<String> LENIENT_YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no", "y", "n"});
    private final OutputEventListener outputEventBroadcaster;
    private final Clock clock;
    private final UserInputReader userInputReader;
    private final AtomicBoolean hasAsked = new AtomicBoolean();
    private final AtomicBoolean interrupted = new AtomicBoolean();

    public DefaultUserInputHandler(OutputEventListener outputEventBroadcaster, Clock clock, UserInputReader userInputReader) {
        this.outputEventBroadcaster = outputEventBroadcaster;
        this.clock = clock;
        this.userInputReader = userInputReader;
    }

    @Override
    protected AbstractUserInputHandler.UserInteraction newInteraction() {
        return new InteractiveUserQuestions();
    }

    @Override
    public boolean interrupted() {
        return this.interrupted.get();
    }

    private void sendPrompt(String prompt) {
        this.outputEventBroadcaster.onOutput((OutputEvent)new PromptOutputEvent(this.clock.getCurrentTime(), prompt));
    }

    private String sanitizeInput(String input) {
        return CharMatcher.javaIsoControl().removeFrom((CharSequence)StringUtils.trim((String)input));
    }

    private static class InteractiveChoiceBuilder<T>
    implements Choice<T> {
        private final InteractiveUserQuestions owner;
        private final Collection<T> options;
        private final String question;
        private T defaultOption;
        private Function<T, String> renderer = Object::toString;

        public InteractiveChoiceBuilder(InteractiveUserQuestions owner, Collection<T> options, String question) {
            this.owner = owner;
            this.options = options;
            this.question = question;
            this.defaultOption = options.iterator().next();
        }

        @Override
        public Choice<T> renderUsing(Function<T, String> renderer) {
            this.renderer = renderer;
            return this;
        }

        @Override
        public Choice<T> defaultOption(T defaultOption) {
            this.defaultOption = defaultOption;
            return this;
        }

        @Override
        public Choice<T> whenNotConnected(T defaultOption) {
            return this;
        }

        @Override
        public T ask() {
            return (T)this.owner.selectOption(this.question, this.options, this.defaultOption, this.renderer);
        }
    }

    private class InteractiveUserQuestions
    implements AbstractUserInputHandler.UserInteraction {
        private boolean hasPrompted;

        private InteractiveUserQuestions() {
        }

        @Override
        public Boolean askYesNoQuestion(String question) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" [");
            builder.append(StringUtils.join((Collection)YES_NO_CHOICES, (String)", "));
            builder.append("] ");
            return (Boolean)this.prompt(builder.toString(), value -> {
                if (YES_NO_CHOICES.contains(value)) {
                    return BooleanUtils.toBoolean((String)value);
                }
                DefaultUserInputHandler.this.sendPrompt("Please enter 'yes' or 'no': ");
                return null;
            });
        }

        @Override
        public boolean askBooleanQuestion(String question, boolean defaultValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" (default: ");
            String defaultString = defaultValue ? "yes" : "no";
            builder.append(defaultString);
            builder.append(") [");
            builder.append(StringUtils.join((Collection)YES_NO_CHOICES, (String)", "));
            builder.append("] ");
            return this.prompt(builder.toString(), defaultValue, value -> {
                if (LENIENT_YES_NO_CHOICES.contains(value.toLowerCase(Locale.US))) {
                    return BooleanUtils.toBoolean((String)value);
                }
                DefaultUserInputHandler.this.sendPrompt("Please enter 'yes' or 'no' (default: '" + defaultString + "'): ");
                return null;
            });
        }

        @Override
        public <T> T selectOption(String question, Collection<T> options, T defaultOption) {
            return this.choice(question, options).defaultOption(defaultOption).ask();
        }

        @Override
        public <T> Choice<T> choice(String question, Collection<T> options) {
            if (options.isEmpty()) {
                throw new IllegalArgumentException("No options provided.");
            }
            return new InteractiveChoiceBuilder<T>(this, options, question);
        }

        @Override
        public int askIntQuestion(String question, int minValue, int defaultValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" (min: ");
            builder.append(minValue);
            builder.append(", default: ");
            builder.append(defaultValue);
            builder.append("): ");
            return this.prompt(builder.toString(), defaultValue, sanitizedValue -> {
                try {
                    int result = Integer.parseInt(sanitizedValue);
                    if (result >= minValue) {
                        return result;
                    }
                    DefaultUserInputHandler.this.sendPrompt("Please enter an integer value >= " + minValue + " (default: " + defaultValue + "): ");
                    return null;
                }
                catch (NumberFormatException e) {
                    DefaultUserInputHandler.this.sendPrompt("Please enter an integer value (min: " + minValue + ", default: " + defaultValue + "): ");
                    return null;
                }
            });
        }

        @Override
        public String askQuestion(String question, String defaultValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(" (default: ");
            builder.append(defaultValue);
            builder.append("): ");
            return this.prompt(builder.toString(), defaultValue, sanitizedValue -> sanitizedValue);
        }

        private <T> T prompt(String prompt, T defaultValue, Transformer<T, String> parser) {
            T result = this.prompt(prompt, sanitizedInput -> {
                if (sanitizedInput.isEmpty()) {
                    return defaultValue;
                }
                return parser.transform(sanitizedInput);
            });
            if (result == null) {
                return defaultValue;
            }
            return result;
        }

        @Nullable
        private <T> T prompt(String prompt, Transformer<T, String> parser) {
            if (DefaultUserInputHandler.this.interrupted.get()) {
                return null;
            }
            if (!this.hasPrompted) {
                DefaultUserInputHandler.this.outputEventBroadcaster.onOutput((OutputEvent)new UserInputRequestEvent());
                this.hasPrompted = true;
            }
            try {
                if (DefaultUserInputHandler.this.hasAsked.compareAndSet(false, true)) {
                    DefaultUserInputHandler.this.sendPrompt(TextUtil.getPlatformLineSeparator());
                }
                DefaultUserInputHandler.this.sendPrompt(prompt);
                while (true) {
                    String input;
                    if ((input = DefaultUserInputHandler.this.userInputReader.readInput()) == null) {
                        DefaultUserInputHandler.this.interrupted.set(true);
                        T t = null;
                        return t;
                    }
                    String sanitizedInput = DefaultUserInputHandler.this.sanitizeInput(input);
                    Object result = parser.transform((Object)sanitizedInput);
                    if (result == null) continue;
                    Object object = result;
                    return (T)object;
                }
            }
            finally {
                DefaultUserInputHandler.this.sendPrompt(TextUtil.getPlatformLineSeparator());
            }
        }

        private <T> T selectOption(String question, Collection<T> options, T defaultOption, Function<T, String> renderer) {
            if (!options.contains(defaultOption)) {
                throw new IllegalArgumentException("Default value is not one of the provided options.");
            }
            if (options.size() == 1) {
                return defaultOption;
            }
            ArrayList values = new ArrayList(options);
            StringBuilder builder = new StringBuilder();
            builder.append(question);
            builder.append(":");
            builder.append(TextUtil.getPlatformLineSeparator());
            for (int i = 0; i < options.size(); ++i) {
                Object option = values.get(i);
                builder.append("  ");
                builder.append(i + 1);
                builder.append(": ");
                builder.append(renderer.apply(option));
                builder.append(TextUtil.getPlatformLineSeparator());
            }
            builder.append("Enter selection (default: ");
            builder.append(renderer.apply(defaultOption));
            builder.append(") [1..");
            builder.append(options.size());
            builder.append("] ");
            return this.prompt(builder.toString(), defaultOption, sanitizedInput -> {
                int value;
                if (sanitizedInput.matches("\\d+") && (value = Integer.parseInt(sanitizedInput)) > 0 && value <= values.size()) {
                    return values.get(value - 1);
                }
                DefaultUserInputHandler.this.sendPrompt("Please enter a value between 1 and " + options.size() + ": ");
                return null;
            });
        }

        @Override
        public void finish() {
            if (this.hasPrompted) {
                DefaultUserInputHandler.this.outputEventBroadcaster.onOutput((OutputEvent)new UserInputResumeEvent());
            }
        }
    }
}

