/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.AmbiguousArtifactTransformException;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactTransformFailure;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AmbiguousArtifactTransformFailureDescriber
extends AbstractResolutionFailureDescriber<AmbiguousArtifactTransformException, AmbiguousArtifactTransformFailure> {
    private static final String AMBIGUOUS_TRANSFORMATION_PREFIX = "Transformation failures are explained in more detail at ";
    private static final String AMBIGUOUS_TRANSFORMATION_SECTION = "sub:transform-ambiguity";

    @Override
    public AmbiguousArtifactTransformException describeFailure(AmbiguousArtifactTransformFailure failure) {
        String msg = this.buildAmbiguousTransformMsg(failure);
        AmbiguousArtifactTransformException result = new AmbiguousArtifactTransformException(msg);
        this.suggestSpecificDocumentation(result, AMBIGUOUS_TRANSFORMATION_PREFIX, AMBIGUOUS_TRANSFORMATION_SECTION);
        this.suggestReviewAlgorithm(result);
        return result;
    }

    private String buildAmbiguousTransformMsg(AmbiguousArtifactTransformFailure failure) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Found multiple transforms that can produce a variant of " + failure.getRequestedName() + " with requested attributes");
        this.formatSortedAttributes(formatter, (AttributeContainer)failure.getRequestedAttributes());
        formatter.node("Found the following transforms");
        Comparator<TransformedVariant> variantComparator = Comparator.comparing(x -> x.getTransformChain().getDisplayName()).thenComparing(x -> x.getAttributes().toString());
        Map variantToTransforms = failure.getTransformedVariants().stream().collect(Collectors.groupingBy(TransformedVariant::getRoot, () -> new TreeMap(Comparator.comparing(variant -> variant.asDescribable().getDisplayName())), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(variantComparator).collect(Collectors.toList()))));
        formatter.startChildren();
        for (Map.Entry entry : variantToTransforms.entrySet()) {
            formatter.node("From '" + ((ResolvedVariant)entry.getKey()).asDescribable().getDisplayName() + "'");
            formatter.startChildren();
            formatter.node("With source attributes");
            this.formatSortedAttributes(formatter, (AttributeContainer)((ResolvedVariant)entry.getKey()).getAttributes());
            formatter.node("Candidate transform(s)");
            formatter.startChildren();
            for (TransformedVariant variant : (List)entry.getValue()) {
                formatter.node("Transform '" + variant.getTransformChain().getDisplayName() + "' producing attributes:");
                this.formatSortedAttributes(formatter, (AttributeContainer)variant.getAttributes());
            }
            formatter.endChildren();
            formatter.endChildren();
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private void formatSortedAttributes(TreeFormatter formatter, AttributeContainer attributes) {
        formatter.startChildren();
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
        formatter.endChildren();
    }
}

