/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;

public class DefaultProblemReporter
implements InternalProblemReporter {
    private final ProblemEmitter emitter;
    private final List<ProblemTransformer> transformers;
    private final String namespace;

    public DefaultProblemReporter(ProblemEmitter emitter, List<ProblemTransformer> transformers, String namespace) {
        this.emitter = emitter;
        this.transformers = transformers;
        this.namespace = namespace;
    }

    @Override
    public void reporting(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        spec.execute((Object)problemBuilder);
        this.report(problemBuilder.build());
    }

    @Override
    public RuntimeException throwing(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        spec.execute((Object)problemBuilder);
        Problem problem = problemBuilder.build();
        RuntimeException exception = problem.getException();
        if (exception == null) {
            throw new IllegalStateException("Exception must be non-null");
        }
        throw this.throwError(exception, problem);
    }

    public RuntimeException throwError(RuntimeException exception, Problem problem) {
        this.report(problem);
        throw exception;
    }

    @Override
    public RuntimeException rethrowing(RuntimeException e, Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        spec.execute((Object)problemBuilder);
        problemBuilder.withException(e);
        throw this.throwError(e, problemBuilder.build());
    }

    @Override
    public Problem create(Action<InternalProblemSpec> action) {
        DefaultProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        action.execute((Object)defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    public DefaultProblemBuilder createProblemBuilder() {
        return new DefaultProblemBuilder(this.namespace);
    }

    private Problem transformProblem(Problem problem) {
        for (ProblemTransformer transformer : this.transformers) {
            problem = transformer.transform((InternalProblem)problem);
        }
        return problem;
    }

    @Override
    public void report(Problem problem) {
        OperationIdentifier id = CurrentBuildOperationRef.instance().getId();
        if (id != null) {
            this.report(problem, id);
        }
    }

    @Override
    public void report(Problem problem, OperationIdentifier id) {
        this.emitter.emit(this.transformProblem(problem), id);
    }
}

