/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.plugin.management.PluginRequest;
import org.gradle.plugin.management.internal.PluginCoordinates;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

@NonNullApi
public class AlreadyOnClasspathIgnoringPluginResolver
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginDescriptorLocator pluginDescriptorLocator;

    public AlreadyOnClasspathIgnoringPluginResolver(PluginResolver delegate, PluginDescriptorLocator pluginDescriptorLocator) {
        this.delegate = delegate;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) {
        PluginCoordinates primaryCoordinates = PluginCoordinates.from((PluginRequest)pluginRequest);
        PluginCoordinates alternativeCoordinates = pluginRequest.getAlternativeCoordinates().orElse(null);
        if (this.isNotPresentOnClasspath(primaryCoordinates) && this.isNotPresentOnClasspath(alternativeCoordinates)) {
            this.delegate.resolve(pluginRequest, result);
        } else {
            result.alreadyApplied();
        }
    }

    private boolean isNotPresentOnClasspath(@Nullable PluginCoordinates pluginCoordinates) {
        return pluginCoordinates == null || this.pluginDescriptorLocator.findPluginDescriptor(pluginCoordinates.getId().toString()) == null;
    }
}

