/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private Object myCurrent = Do.INIT;
    private Object myNext = Do.INIT;
    private Op myFirstOp;
    private Op myLastOp = this.myFirstOp = new NextOp();
    private static final Function.Mono CURSOR_NEXT = new Function.Mono<JBIterator<?>>(){

        @Override
        public JBIterator<?> fun(JBIterator<?> iterator2) {
            return (JBIterator)((JBIterator)iterator2).addOp(false, iterator2.new CursorOp());
        }
    };

    @NotNull
    public static <E> JBIterator<E> from(@NotNull Iterator<? extends E> it) {
        if (it == null) {
            JBIterator.$$$reportNull$$$0(2);
        }
        return it instanceof JBIterator ? (JBIterator<? extends E>)it : JBIterator.wrap(it);
    }

    @NotNull
    static <E> JBIterator<E> wrap(final @NotNull Iterator<? extends E> it) {
        if (it == null) {
            JBIterator.$$$reportNull$$$0(3);
        }
        return new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = Do.STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = Do.SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != Do.STOP;
    }

    @Override
    public final E next() {
        this.advance();
        return this.current();
    }

    public final boolean advance() {
        this.myCurrent = Do.INIT;
        this.peekNext();
        if (this.myNext == Do.STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = Do.INIT;
        if (this.myFirstOp instanceof CursorOp) {
            ((CursorOp)this.myFirstOp).advance(this.myCurrent);
        }
        this.currentChanged();
        return true;
    }

    public final E current() {
        if (this.myCurrent == Do.INIT) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != Do.INIT) {
            return;
        }
        Object o = Do.INIT;
        Op op = this.myFirstOp;
        while (op != null) {
            o = op.apply(op.impl == null ? this.nextImpl() : o);
            if (this.myNext == Do.STOP) {
                return;
            }
            if (this.myNext == Do.SKIP) {
                this.myNext = Do.INIT;
                o = this.myNext;
                if (op.impl == null) {
                    Op op2 = this.myFirstOp;
                    while (op2.impl instanceof CountDown) {
                        ++((CountDown)op2.impl).cur;
                        op2 = op2.nextOp;
                    }
                }
                op = null;
            }
            op = op == null ? this.myFirstOp : op.nextOp;
        }
        this.myNext = o;
    }

    @NotNull
    public final <T> JBIterator<T> map(@NotNull Function<? super E, ? extends T> function2) {
        if (function2 == null) {
            JBIterator.$$$reportNull$$$0(4);
        }
        return (JBIterator)this.addOp(true, new MapOp<E, T>(function2));
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(5);
        }
        return (JBIterator)this.addOp(true, new FilterOp<E>(condition));
    }

    @NotNull
    public final <T> JBIterator<T> filterMap(@NotNull Function<? super E, ? extends T> function2) {
        if (function2 == null) {
            JBIterator.$$$reportNull$$$0(6);
        }
        return (JBIterator)this.addOp(true, new FilterMapOp<E, T>(function2));
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        return (JBIterator)this.addOp(!(this.myLastOp instanceof NextOp), new WhileOp(new CountDown(count)));
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(7);
        }
        return (JBIterator)this.addOp(true, new WhileOp<E>(condition));
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        return this.skipWhile(new CountDown(count));
    }

    @NotNull
    public final JBIterator<E> skipWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(8);
        }
        return (JBIterator)this.addOp(true, new SkipOp<E>(condition));
    }

    @NotNull
    private <T> T addOp(boolean last, @NotNull Op op) {
        if (op == null) {
            JBIterator.$$$reportNull$$$0(9);
        }
        if (op.impl == null) {
            this.myFirstOp = this.myLastOp = op;
        } else if (last) {
            this.myLastOp = this.myLastOp.nextOp = op;
        } else {
            op.nextOp = this.myFirstOp;
            this.myFirstOp = op;
        }
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(10);
        }
        return (T)jBIterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        List<Op> ops = this.operationsImpl().toList();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.size() < 2 ? "" : "; ops=" + ops) + "}";
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.myFirstOp, op -> op.nextOp);
        if (jBIterable == null) {
            JBIterator.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    static String toShortString(@NotNull Object o) {
        String name2;
        int idx;
        if (o == null) {
            JBIterator.$$$reportNull$$$0(14);
        }
        if ((idx = (name2 = o.getClass().getName()).lastIndexOf(36)) > 0 && idx < name2.length() && StringUtil.isJavaIdentifierStart(name2.charAt(idx + 1))) {
            String string2 = name2.substring(idx + 1);
            if (string2 == null) {
                JBIterator.$$$reportNull$$$0(15);
            }
            return string2;
        }
        String string3 = name2.substring(name2.lastIndexOf(46) + 1);
        if (string3 == null) {
            JBIterator.$$$reportNull$$$0(16);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cursor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addOp";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "operationsImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toShortString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cursor";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "takeWhile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipWhile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addOp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toShortString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class CursorOp
    extends Op<Void> {
        boolean advanced;

        CursorOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            JBIterator it = (JBIterator)o;
            boolean bl = this.advanced = this.nextOp != null;
            return (this.advanced ? it.advance() : it.hasNext()) ? it : JBIterator.this.stop();
        }

        void advance(Object o) {
            if (this.advanced || !(o instanceof JBIterator)) {
                return;
            }
            ((JBIterator)o).advance();
            this.advanced = true;
        }
    }

    private static class NextOp
    extends Op<Void> {
        NextOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            return o;
        }
    }

    private class SkipOp<E>
    extends Op<Condition<? super E>> {
        boolean active;

        SkipOp(Condition<? super E> condition) {
            super(condition);
            this.active = true;
        }

        @Override
        Object apply(Object o) {
            if (this.active && ((Condition)this.impl).value(o)) {
                return JBIterator.this.skip();
            }
            this.active = false;
            return o;
        }
    }

    private class WhileOp<E>
    extends Op<Condition<? super E>> {
        WhileOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
        }
    }

    private class FilterMapOp<E, T>
    extends Op<Function<? super E, ? extends T>> {
        FilterMapOp(Function<? super E, ? extends T> function2) {
            super(function2);
        }

        @Override
        Object apply(Object o) {
            Object e = ((Function)this.impl).fun(o);
            return e != null ? e : JBIterator.this.skip();
        }
    }

    private class FilterOp<E>
    extends Op<Condition<? super E>> {
        FilterOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.skip();
        }
    }

    private static class MapOp<E, T>
    extends Op<Function<? super E, ? extends T>> {
        MapOp(Function<? super E, ? extends T> function2) {
            super(function2);
        }

        @Override
        Object apply(Object o) {
            return ((Function)this.impl).fun(o);
        }
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        CountDown(int count) {
            this.cur = count;
        }

        @Override
        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return JBIterator.toShortString(this.impl == null ? this : this.impl);
        }
    }

    private static enum Do {
        INIT,
        STOP,
        SKIP;

    }
}

