/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.DefaultClassLoaderScope;
import org.gradle.api.internal.initialization.ImmutableClassLoaderScope;
import org.gradle.api.internal.initialization.MutableClassLoaderScope;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;

public abstract class AbstractClassLoaderScope
implements ClassLoaderScope {
    protected final ClassLoaderScopeIdentifier id;
    @Nullable
    protected final ClassLoaderScopeOrigin origin;
    protected final ClassLoaderCache classLoaderCache;
    protected final ClassLoaderScopeRegistryListener listener;

    protected AbstractClassLoaderScope(ClassLoaderScopeIdentifier id, @Nullable ClassLoaderScopeOrigin origin, ClassLoaderCache classLoaderCache, ClassLoaderScopeRegistryListener listener) {
        this.id = id;
        this.origin = origin;
        this.classLoaderCache = classLoaderCache;
        this.listener = listener;
    }

    @Override
    public ClassLoaderScopeId getId() {
        return this.id;
    }

    @Override
    @Nullable
    public ClassLoaderScopeOrigin getOrigin() {
        return this.origin;
    }

    public String getPath() {
        return this.id.getPath();
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        return this.immutable();
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        return this.immutable();
    }

    @Override
    public ClassLoaderScope export(ClassLoader classLoader) {
        return this.immutable();
    }

    private ClassLoaderScope immutable() {
        throw new UnsupportedOperationException(String.format("Class loader scope %s is immutable", this.id));
    }

    @Override
    public ClassLoaderScope createChild(String name, @Nullable ClassLoaderScopeOrigin origin) {
        return new MutableClassLoaderScope(new DefaultClassLoaderScope(this.id.child(name), this, origin, this.classLoaderCache, this.listener));
    }

    @Override
    public ClassLoaderScope createLockedChild(String name, @Nullable ClassLoaderScopeOrigin origin, ClassPath localClasspath, @Nullable HashCode classpathImplementationHash, @Nullable Function<ClassLoader, ClassLoader> localClassLoaderFactory) {
        return new ImmutableClassLoaderScope(this.id.child(name), this, origin, localClasspath, classpathImplementationHash, localClassLoaderFactory, this.classLoaderCache, this.listener);
    }

    @Override
    public ClassLoaderScope getOriginalScope() {
        return this;
    }
}

