/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.bundling.internal.Zip64RequiredException;
import org.gradle.internal.IoActions;

public class ZipCopyAction
implements CopyAction {
    public static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();
    private final File zipFile;
    private final ZipCompressor compressor;
    private final DocumentationRegistry documentationRegistry;
    private final String encoding;
    private final boolean preserveFileTimestamps;

    public ZipCopyAction(File zipFile, ZipCompressor compressor, DocumentationRegistry documentationRegistry, String encoding, boolean preserveFileTimestamps) {
        this.zipFile = zipFile;
        this.compressor = compressor;
        this.documentationRegistry = documentationRegistry;
        this.encoding = encoding;
        this.preserveFileTimestamps = preserveFileTimestamps;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        ZipArchiveOutputStream zipOutStr;
        try {
            zipOutStr = this.compressor.createArchiveOutputStream(this.zipFile);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create ZIP '%s'.", this.zipFile), (Throwable)e);
        }
        try {
            IoActions.withResource((Closeable)zipOutStr, outputStream -> stream.process(new StreamAction((ZipArchiveOutputStream)outputStream, this.encoding)));
        }
        catch (Exception e) {
            if (e.getCause() instanceof org.apache.commons.compress.archivers.zip.Zip64RequiredException) {
                throw new Zip64RequiredException(String.format("%s\n\nTo build this archive, please enable the zip64 extension.\nSee: %s", e.getCause().getMessage(), this.documentationRegistry.getDslRefForProperty(Zip.class, "zip64")));
            }
            this.zipFile.delete();
            throw e;
        }
        return WorkResults.didWork((boolean)true);
    }

    private long getArchiveTimeFor(FileCopyDetails details) {
        return this.preserveFileTimestamps ? details.getLastModified() : CONSTANT_TIME_FOR_ZIP_ENTRIES;
    }

    private class StreamAction
    implements CopyActionProcessingStreamAction {
        private final ZipArchiveOutputStream zipOutStr;

        public StreamAction(ZipArchiveOutputStream zipOutStr, String encoding) {
            this.zipOutStr = zipOutStr;
            if (encoding != null) {
                this.zipOutStr.setEncoding(encoding);
            }
        }

        @Override
        public void processFile(FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                this.visitDir(details);
            } else {
                this.visitFile(details);
            }
        }

        private void visitFile(FileCopyDetails fileDetails) {
            try {
                ZipArchiveEntry archiveEntry = new ZipArchiveEntry(fileDetails.getRelativePath().getPathString());
                archiveEntry.setTime(ZipCopyAction.this.getArchiveTimeFor(fileDetails));
                archiveEntry.setUnixMode(0x8000 | fileDetails.getPermissions().toUnixNumeric());
                this.zipOutStr.putArchiveEntry((ArchiveEntry)archiveEntry);
                fileDetails.copyTo((OutputStream)this.zipOutStr);
                this.zipOutStr.closeArchiveEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", fileDetails, ZipCopyAction.this.zipFile), (Throwable)e);
            }
        }

        private void visitDir(FileCopyDetails dirDetails) {
            try {
                ZipArchiveEntry archiveEntry = new ZipArchiveEntry(dirDetails.getRelativePath().getPathString() + '/');
                archiveEntry.setTime(ZipCopyAction.this.getArchiveTimeFor(dirDetails));
                archiveEntry.setUnixMode(0x4000 | dirDetails.getPermissions().toUnixNumeric());
                this.zipOutStr.putArchiveEntry((ArchiveEntry)archiveEntry);
                this.zipOutStr.closeArchiveEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", dirDetails, ZipCopyAction.this.zipFile), (Throwable)e);
            }
        }
    }
}

