/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.problems.internal.DefaultProblemReporter;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemsProgressEventEmitterHolder;
import org.gradle.internal.reflect.validation.DefaultTypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.plugin.use.PluginId;

public abstract class ProblemRecordingTypeValidationContext
implements TypeValidationContext {
    private final Class<?> rootType;
    private final Supplier<Optional<PluginId>> pluginId;

    public ProblemRecordingTypeValidationContext(@Nullable Class<?> rootType, Supplier<Optional<PluginId>> pluginId) {
        this.rootType = rootType;
        this.pluginId = pluginId;
    }

    @Override
    public void visitTypeProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        InternalProblems problems = ProblemsProgressEventEmitterHolder.get();
        InternalProblemReporter reporter = problems.getInternalReporter();
        DefaultTypeAwareProblemBuilder problemBuilder = new DefaultTypeAwareProblemBuilder((InternalProblemBuilder)((DefaultProblemReporter)reporter).createProblemBuilder());
        problemSpec.execute((Object)problemBuilder);
        this.recordProblem(problemBuilder.build());
    }

    private Optional<PluginId> pluginId() {
        return this.pluginId.get();
    }

    @Override
    public void visitPropertyProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        InternalProblemReporter reporter = ProblemsProgressEventEmitterHolder.get().getInternalReporter();
        DefaultTypeAwareProblemBuilder problemBuilder = new DefaultTypeAwareProblemBuilder((InternalProblemBuilder)((DefaultProblemReporter)reporter).createProblemBuilder());
        problemSpec.execute((Object)problemBuilder);
        problemBuilder.withAnnotationType(this.rootType);
        this.pluginId().map(PluginId::getId).ifPresent(id -> problemBuilder.additionalData("pluginId", id));
        this.recordProblem(problemBuilder.build());
    }

    protected abstract void recordProblem(Problem var1);
}

