/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.configurationcache.EncryptionKind;
import org.gradle.configurationcache.EncryptionService;
import org.gradle.configurationcache.EnvironmentVarKeySource;
import org.gradle.configurationcache.KeyStoreKeySource;
import org.gradle.configurationcache.NoEncryptionKeySource;
import org.gradle.configurationcache.SecretKeySource;
import org.gradle.configurationcache.StateType;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.EncryptionAlgorithm;
import org.gradle.util.internal.SupportedEncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0&H\u0016J\b\u0010'\u001a\u00020(H\u0002J\u001e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0&H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00162\u0006\u0010+\u001a\u00020,H\u0002JC\u0010-\u001a\u0002H.\"\b\b\u0000\u0010/*\u000200\"\b\b\u0001\u0010.*\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/0&2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u0002H.03H\u0002\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u0004\u0018\u00010\u00162\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020,H\u0002J\u0010\u0010:\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/gradle/configurationcache/DefaultEncryptionService;", "Lorg/gradle/configurationcache/EncryptionService;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;)V", "encryptionAlgorithm", "Lorg/gradle/util/internal/EncryptionAlgorithm;", "getEncryptionAlgorithm", "()Lorg/gradle/util/internal/EncryptionAlgorithm;", "encryptionAlgorithm$delegate", "Lkotlin/Lazy;", "encryptionKeyHashCode", "Lorg/gradle/internal/hash/HashCode;", "getEncryptionKeyHashCode", "()Lorg/gradle/internal/hash/HashCode;", "encryptionKeyHashCode$delegate", "isEncrypting", "", "()Z", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "assertKeyLength", "", "key", "decryptingInputStream", "Ljava/io/InputStream;", "inputStream", "encryptingOutputStream", "Ljava/io/OutputStream;", "outputStream", "stateType", "Lorg/gradle/configurationcache/StateType;", "input", "Lkotlin/Function0;", "newEncryptionSession", "Lorg/gradle/util/internal/EncryptionAlgorithm$Session;", "output", "produceSecretKey", "encryptionKind", "Lorg/gradle/configurationcache/EncryptionKind;", "safeWrap", "T", "C", "Ljava/io/Closeable;", "innerSupplier", "unsafeWrapper", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/io/Closeable;", "secretKeyFrom", "keySource", "Lorg/gradle/configurationcache/SecretKeySource;", "secretKeySource", "kind", "shouldEncryptStreams", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nEncryptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionService.kt\norg/gradle/configurationcache/DefaultEncryptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,365:1\n1#2:366\n*E\n"})
public final class DefaultEncryptionService
implements EncryptionService {
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    private final Lazy encryptionAlgorithm$delegate;
    @NotNull
    private final Lazy encryptionKeyHashCode$delegate;

    public DefaultEncryptionService(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        this.startParameter = startParameter;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.secretKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SecretKey>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SecretKey invoke() {
                return DefaultEncryptionService.access$produceSecretKey(this.this$0, EncryptionKind.Companion.select(DefaultEncryptionService.access$getStartParameter$p(this.this$0).getEncryptionRequested()));
            }
        }));
        this.encryptionAlgorithm$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EncryptionAlgorithm>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EncryptionAlgorithm invoke() {
                EncryptionAlgorithm encryptionAlgorithm2 = SupportedEncryptionAlgorithm.byTransformation((String)DefaultEncryptionService.access$getStartParameter$p(this.this$0).getEncryptionAlgorithm());
                Intrinsics.checkNotNullExpressionValue((Object)encryptionAlgorithm2, (String)"byTransformation(startPa\u2026eter.encryptionAlgorithm)");
                return encryptionAlgorithm2;
            }
        }));
        this.encryptionKeyHashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashCode>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HashCode invoke() {
                SecretKey secretKey2;
                block3: {
                    block2: {
                        Hasher hasher;
                        secretKey2 = DefaultEncryptionService.access$getSecretKey(this.this$0);
                        if (secretKey2 == null) break block2;
                        SecretKey secretKey3 = secretKey2;
                        DefaultEncryptionService defaultEncryptionService = this.this$0;
                        SecretKey it = secretKey3;
                        boolean bl = false;
                        Hasher $this$invoke_u24lambda_u241_u24lambda_u240 = hasher = Hashing.sha512().newHasher();
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.putBytes(it.getEncoded());
                        $this$invoke_u24lambda_u241_u24lambda_u240.putString((CharSequence)defaultEncryptionService.getEncryptionAlgorithm().getTransformation());
                        HashCode hashCode = hasher.hash();
                        secretKey2 = hashCode;
                        if (hashCode != null) break block3;
                    }
                    secretKey2 = Hashing.newHasher().hash();
                }
                Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"secretKey?.let {\n       \u2026ashing.newHasher().hash()");
                return secretKey2;
            }
        }));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final SecretKey produceSecretKey(EncryptionKind encryptionKind) {
        SecretKey secretKey2;
        SecretKeySource keySource = this.secretKeySource(encryptionKind);
        boolean bl = false;
        try {
            SecretKey secretKey3;
            SecretKey secretKey4 = this.secretKeyFrom(keySource);
            if (secretKey4 != null) {
                SecretKey secretKey5;
                SecretKey key = secretKey5 = secretKey4;
                boolean bl2 = false;
                this.assertKeyLength(key);
                secretKey3 = secretKey5;
            } else {
                secretKey3 = null;
            }
            secretKey2 = secretKey3;
        }
        catch (EncryptionAlgorithm.EncryptionException e) {
            if (e.getMessage() != null) {
                throw e;
            }
            throw new EncryptionAlgorithm.EncryptionException("Error loading encryption key from " + keySource.getSourceDescription(), e.getCause());
        }
        catch (Exception e) {
            throw new EncryptionAlgorithm.EncryptionException("Error loading encryption key from " + keySource.getSourceDescription(), (Throwable)e);
        }
        return secretKey2;
    }

    private final SecretKey secretKeyFrom(SecretKeySource keySource) {
        return keySource.getKey();
    }

    private final void assertKeyLength(SecretKey key) {
        int keyLength = key.getEncoded().length;
        if (keyLength < 16) {
            throw new InvalidKeyException("Encryption key length is " + keyLength + " bytes, but must be at least 16 bytes long");
        }
    }

    @Override
    @NotNull
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        Lazy lazy = this.encryptionAlgorithm$delegate;
        return (EncryptionAlgorithm)lazy.getValue();
    }

    @Override
    public boolean isEncrypting() {
        return this.getSecretKey() != null;
    }

    @Override
    @NotNull
    public HashCode getEncryptionKeyHashCode() {
        Lazy lazy = this.encryptionKeyHashCode$delegate;
        return (HashCode)lazy.getValue();
    }

    private final boolean shouldEncryptStreams(StateType stateType) {
        return this.isEncrypting() && stateType.getEncryptable();
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull StateType stateType, @NotNull Function0<? extends OutputStream> output) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        return this.shouldEncryptStreams(stateType) ? (OutputStream)this.safeWrap(output, (Function1)new Function1<OutputStream, OutputStream>((Object)this){

            @NotNull
            public final OutputStream invoke(@NotNull OutputStream p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DefaultEncryptionService.access$encryptingOutputStream((DefaultEncryptionService)this.receiver, p0);
            }
        }) : (OutputStream)output.invoke();
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull StateType stateType, @NotNull Function0<? extends InputStream> input) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return this.shouldEncryptStreams(stateType) ? (InputStream)this.safeWrap(input, (Function1)new Function1<InputStream, InputStream>((Object)this){

            @NotNull
            public final InputStream invoke(@NotNull InputStream p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DefaultEncryptionService.access$decryptingInputStream((DefaultEncryptionService)this.receiver, p0);
            }
        }) : (InputStream)input.invoke();
    }

    private final <C extends Closeable, T extends Closeable> T safeWrap(Function0<? extends C> innerSupplier, Function1<? super C, ? extends T> unsafeWrapper) {
        Closeable closeable;
        Closeable innerCloseable = (Closeable)innerSupplier.invoke();
        try {
            closeable = (Closeable)unsafeWrapper.invoke((Object)innerCloseable);
        }
        catch (Throwable e) {
            try {
                innerCloseable.close();
            }
            catch (Throwable closingException) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)closingException);
            }
            throw e;
        }
        Closeable outerCloseable = closeable;
        return (T)outerCloseable;
    }

    private final InputStream decryptingInputStream(InputStream inputStream2) {
        Cipher cipher2 = this.newEncryptionSession().decryptingCipher(new EncryptionAlgorithm.IVLoader(inputStream2){
            final /* synthetic */ InputStream $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void load(byte[] p0) {
                this.$tmp0.read(p0);
            }
        });
        return new CipherInputStream(inputStream2, cipher2);
    }

    private final OutputStream encryptingOutputStream(OutputStream outputStream2) {
        Cipher cipher2 = this.newEncryptionSession().encryptingCipher(new EncryptionAlgorithm.IVCollector(outputStream2){
            final /* synthetic */ OutputStream $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void collect(byte[] p0) {
                this.$tmp0.write(p0);
            }
        });
        return new CipherOutputStream(outputStream2, cipher2);
    }

    private final EncryptionAlgorithm.Session newEncryptionSession() {
        EncryptionAlgorithm.Session session = this.getEncryptionAlgorithm().newSession(this.getSecretKey());
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"encryptionAlgorithm.newSession(secretKey)");
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private final SecretKeySource secretKeySource(EncryptionKind kind) {
        SecretKeySource secretKeySource;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                File file;
                String string2 = this.getEncryptionAlgorithm().getAlgorithm();
                String string3 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encryptionAlgorithm.algorithm");
                String string4 = this.startParameter.getKeystoreDir();
                if (string4 != null) {
                    void it;
                    String string5 = string4;
                    String string6 = string3;
                    boolean bl = false;
                    file = new File((String)it);
                    string3 = string6;
                } else {
                    file = null;
                }
                GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory = this.cacheBuilderFactory;
                String string7 = "gradle-secret";
                File file2 = file;
                String string8 = string3;
                secretKeySource = new KeyStoreKeySource(string8, file2, string7, globalScopedCacheBuilderFactory);
                break;
            }
            case 2: {
                String string9 = this.getEncryptionAlgorithm().getAlgorithm();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"encryptionAlgorithm.algorithm");
                secretKeySource = new EnvironmentVarKeySource(string9);
                break;
            }
            case 3: {
                secretKeySource = new NoEncryptionKeySource();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return secretKeySource;
    }

    public static final /* synthetic */ OutputStream access$encryptingOutputStream(DefaultEncryptionService $this, OutputStream outputStream2) {
        return $this.encryptingOutputStream(outputStream2);
    }

    public static final /* synthetic */ InputStream access$decryptingInputStream(DefaultEncryptionService $this, InputStream inputStream2) {
        return $this.decryptingInputStream(inputStream2);
    }

    public static final /* synthetic */ SecretKey access$produceSecretKey(DefaultEncryptionService $this, EncryptionKind encryptionKind) {
        return $this.produceSecretKey(encryptionKind);
    }

    public static final /* synthetic */ ConfigurationCacheStartParameter access$getStartParameter$p(DefaultEncryptionService $this) {
        return $this.startParameter;
    }

    public static final /* synthetic */ SecretKey access$getSecretKey(DefaultEncryptionService $this) {
        return $this.getSecretKey();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionKind.values().length];
            try {
                nArray[EncryptionKind.KEYSTORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.ENV_VAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

