/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.MavenVersionSelectorScheme;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.provider.MergeProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.component.MavenPublishingAwareVariant;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.DependencyCoordinateResolverFactory;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.mapping.VariantDependencyResolver;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.validation.VariantWarningCollector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenPomDependencies;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenPomDependencies;
import org.gradle.api.publish.maven.internal.dependencies.VersionRangeMapper;
import org.gradle.api.publish.maven.internal.validation.MavenPublicationErrorChecker;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.typeconversion.NotationParser;

public class MavenComponentParser {
    @VisibleForTesting
    public static final String INCOMPATIBLE_FEATURE = " contains dependencies that will produce a pom file that cannot be consumed by a Maven client.";
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published pom file.";
    @VisibleForTesting
    public static final String PUBLICATION_WARNING_FOOTER = "These issues indicate information that is lost in the published 'pom' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Maven.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.";
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private static final Logger LOG = Logging.getLogger(MavenComponentParser.class);
    private final PlatformSupport platformSupport;
    private final VersionRangeMapper versionRangeMapper;
    private final DocumentationRegistry documentationRegistry;
    private final NotationParser<Object, MavenArtifact> mavenArtifactParser;
    private final DependencyCoordinateResolverFactory dependencyCoordinateResolverFactory;

    @Inject
    public MavenComponentParser(PlatformSupport platformSupport, VersionRangeMapper versionRangeMapper, DocumentationRegistry documentationRegistry, NotationParser<Object, MavenArtifact> mavenArtifactParser, DependencyCoordinateResolverFactory dependencyCoordinateResolverFactory) {
        this.platformSupport = platformSupport;
        this.versionRangeMapper = versionRangeMapper;
        this.documentationRegistry = documentationRegistry;
        this.mavenArtifactParser = mavenArtifactParser;
        this.dependencyCoordinateResolverFactory = dependencyCoordinateResolverFactory;
    }

    public Set<MavenArtifact> parseArtifacts(SoftwareComponentInternal component) {
        HashSet seenArtifacts = new HashSet();
        return MavenComponentParser.createSortedVariantsStream(component).flatMap(variant -> variant.getArtifacts().stream()).filter(artifact -> {
            ArtifactKey key = new ArtifactKey(artifact.getFile(), artifact.getClassifier(), artifact.getExtension());
            return seenArtifacts.add(key);
        }).map(arg_0 -> this.mavenArtifactParser.parseNotation(arg_0)).collect(Collectors.toSet());
    }

    public Provider<ParsedDependencyResult> parseDependencies(SoftwareComponentInternal component, VersionMappingStrategyInternal versionMappingStrategy, ModuleVersionIdentifier coordinates) {
        MavenPublicationErrorChecker.checkForUnpublishableAttributes((SoftwareComponentInternal)component, (DocumentationRegistry)this.documentationRegistry);
        List parsedVariants = MavenComponentParser.createSortedVariantsStream(component).map(variant -> this.dependencyCoordinateResolverFactory.createCoordinateResolvers(variant, versionMappingStrategy).map(resolvers -> this.getDependenciesForVariant((SoftwareComponentVariant)variant, (DependencyCoordinateResolverFactory.DependencyResolvers)resolvers, coordinates))).collect(Collectors.toList());
        return new MergeProvider(parsedVariants).map(variants -> {
            ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>();
            ArrayList<MavenDependency> constraints = new ArrayList<MavenDependency>();
            ArrayList<MavenDependency> platforms = new ArrayList<MavenDependency>();
            HashSet<MavenDependencyKey> seenDependencies = new HashSet<MavenDependencyKey>();
            HashSet<MavenDependencyKey> seenPlatforms = new HashSet<MavenDependencyKey>();
            HashSet<MavenDependencyKey> seenConstraints = new HashSet<MavenDependencyKey>();
            HashMap<String, VariantWarningCollector> warnings = new HashMap<String, VariantWarningCollector>();
            for (ParsedVariantDependencyResult variant : variants) {
                for (MavenDependency dependency : variant.dependencies) {
                    if (!seenDependencies.add(MavenDependencyKey.of(dependency))) continue;
                    dependencies.add(dependency);
                }
                for (MavenDependency platform : variant.platforms) {
                    if (!seenPlatforms.add(MavenDependencyKey.of(platform))) continue;
                    platforms.add(platform);
                }
                for (MavenDependency dep : variant.constraints) {
                    if (!seenConstraints.add(MavenDependencyKey.of(dep))) continue;
                    constraints.add(dep);
                }
                warnings.put(variant.name, variant.warnings);
            }
            return new ParsedDependencyResult(new DefaultMavenPomDependencies((ImmutableList<MavenDependency>)ImmutableList.copyOf(dependencies), (ImmutableList<MavenDependency>)ImmutableList.builder().addAll(constraints).addAll(platforms).build()), new PublicationWarningsCollector(warnings, LOG, UNSUPPORTED_FEATURE, INCOMPATIBLE_FEATURE, PUBLICATION_WARNING_FOOTER, "suppressPomMetadataWarningsFor"));
        });
    }

    private ParsedVariantDependencyResult getDependenciesForVariant(SoftwareComponentVariant variant, DependencyCoordinateResolverFactory.DependencyResolvers resolvers, ModuleVersionIdentifier coordinates) {
        VariantWarningCollector warnings = new VariantWarningCollector();
        ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>();
        ArrayList<MavenDependency> constraints = new ArrayList<MavenDependency>();
        ArrayList<MavenDependency> platforms = new ArrayList<MavenDependency>();
        MavenPublishingAwareVariant.ScopeMapping scopeMapping = MavenPublishingAwareVariant.scopeForVariant((SoftwareComponentVariant)variant);
        String scope = scopeMapping.getScope();
        boolean optional = scopeMapping.isOptional();
        Set globalExcludes = variant.getGlobalExcludes();
        MavenDependencyFactory dependencyFactory = new MavenDependencyFactory(warnings, resolvers.getVariantResolver(), resolvers.getComponentResolver(), this.versionRangeMapper, scope, optional, globalExcludes);
        for (ModuleDependency dependency : variant.getDependencies()) {
            if (MavenComponentParser.isDependencyWithDefaultArtifact(dependency) && MavenComponentParser.dependencyMatchesProject(dependency, coordinates)) continue;
            if (this.platformSupport.isTargetingPlatform((HasConfigurableAttributes)dependency)) {
                dependencyFactory.convertImportDependencyConstraint(dependency, platforms::add);
                continue;
            }
            dependencyFactory.convertDependency(dependency, dependencies::add);
        }
        for (ModuleDependency dependency : variant.getDependencyConstraints()) {
            block9: {
                block8: {
                    if (dependency instanceof DefaultProjectDependencyConstraint) break block8;
                    if (dependency.getVersion() == null) break block9;
                }
                dependencyFactory.convertDependencyConstraint((DependencyConstraint)dependency, constraints::add);
                continue;
            }
            warnings.addIncompatible(String.format("constraint %s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName()));
        }
        if (!variant.getCapabilities().isEmpty()) {
            for (Capability capability : variant.getCapabilities()) {
                if (!MavenComponentParser.isNotDefaultCapability(capability, coordinates)) continue;
                warnings.addVariantUnsupported(String.format("Declares capability %s:%s:%s which cannot be mapped to Maven", capability.getGroup(), capability.getName(), capability.getVersion()));
            }
        }
        return new ParsedVariantDependencyResult(variant.getName(), dependencies, platforms, constraints, warnings);
    }

    private static boolean isNotDefaultCapability(Capability capability, ModuleVersionIdentifier coordinates) {
        return !coordinates.getGroup().equals(capability.getGroup()) || !coordinates.getName().equals(capability.getName()) || !coordinates.getVersion().equals(capability.getVersion());
    }

    private static boolean isDependencyWithDefaultArtifact(ModuleDependency dependency) {
        if (dependency.getArtifacts().isEmpty()) {
            return true;
        }
        return dependency.getArtifacts().stream().allMatch(artifact -> Strings.nullToEmpty((String)artifact.getClassifier()).isEmpty());
    }

    private static boolean dependencyMatchesProject(ModuleDependency dependency, ModuleVersionIdentifier coordinates) {
        return coordinates.getModule().equals(DefaultModuleIdentifier.newId((String)dependency.getGroup(), (String)dependency.getName()));
    }

    private static Stream<? extends SoftwareComponentVariant> createSortedVariantsStream(SoftwareComponentInternal component) {
        return component.getUsages().stream().sorted(Comparator.comparing(MavenPublishingAwareVariant::scopeForVariant));
    }

    private static class MavenDependencyKey {
        private final String group;
        private final String name;
        private final String type;
        private final String classifier;

        private MavenDependencyKey(String group, String name, @Nullable String type, @Nullable String classifier) {
            this.group = group;
            this.name = name;
            this.type = type;
            this.classifier = classifier;
        }

        static MavenDependencyKey of(MavenDependency dep) {
            return new MavenDependencyKey(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenDependencyKey that = (MavenDependencyKey)o;
            return Objects.equals(this.group, that.group) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.classifier, that.classifier);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.name, this.type, this.classifier);
        }
    }

    private static class ArtifactKey {
        final File file;
        final String classifier;
        final String extension;

        public ArtifactKey(File file, @Nullable String classifier, @Nullable String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public boolean equals(Object obj) {
            ArtifactKey other = (ArtifactKey)obj;
            return this.file.equals(other.file) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.extension, other.extension);
        }

        public int hashCode() {
            return this.file.hashCode() ^ Objects.hash(this.classifier, this.extension);
        }
    }

    private static class ParsedVariantDependencyResult {
        private final String name;
        private final List<MavenDependency> dependencies;
        private final List<MavenDependency> platforms;
        private final List<MavenDependency> constraints;
        private final VariantWarningCollector warnings;

        public ParsedVariantDependencyResult(String name, List<MavenDependency> dependencies, List<MavenDependency> platforms, List<MavenDependency> constraints, VariantWarningCollector warnings) {
            this.name = name;
            this.dependencies = dependencies;
            this.platforms = platforms;
            this.constraints = constraints;
            this.warnings = warnings;
        }
    }

    public static class ParsedDependencyResult {
        private final MavenPomDependencies dependencies;
        private final PublicationWarningsCollector warnings;

        public ParsedDependencyResult(MavenPomDependencies dependencies, PublicationWarningsCollector warnings) {
            this.warnings = warnings;
            this.dependencies = dependencies;
        }

        public MavenPomDependencies getDependencies() {
            return this.dependencies;
        }

        public PublicationWarningsCollector getWarnings() {
            return this.warnings;
        }
    }

    private static class MavenDependencyFactory {
        private final VariantWarningCollector warnings;
        private final VariantDependencyResolver variantDependencyResolver;
        private final ComponentDependencyResolver componentDependencyResolver;
        private final VersionRangeMapper versionRangeMapper;
        private final String scope;
        private final boolean optional;
        private final Set<ExcludeRule> globalExcludes;

        public MavenDependencyFactory(VariantWarningCollector warnings, VariantDependencyResolver variantDependencyResolver, ComponentDependencyResolver componentDependencyResolver, VersionRangeMapper versionRangeMapper, String scope, boolean optional, Set<ExcludeRule> globalExcludes) {
            this.warnings = warnings;
            this.variantDependencyResolver = variantDependencyResolver;
            this.componentDependencyResolver = componentDependencyResolver;
            this.versionRangeMapper = versionRangeMapper;
            this.scope = scope;
            this.optional = optional;
            this.globalExcludes = globalExcludes;
        }

        private void convertDependency(ModuleDependency dependency, Consumer<MavenDependency> collector) {
            if (!dependency.getAttributes().isEmpty()) {
                this.warnings.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
            }
            if (!dependency.getRequestedCapabilities().isEmpty()) {
                this.warnings.addUnsupported(String.format("%s:%s:%s declared with Gradle capabilities", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
            }
            Set<ExcludeRule> allExcludeRules = MavenDependencyFactory.getExcludeRules(this.globalExcludes, dependency);
            if (dependency.getArtifacts().isEmpty()) {
                ResolvedCoordinates coordinates = this.resolveDependency(dependency);
                collector.accept(MavenDependencyFactory.newDependency(coordinates, null, null, this.scope, allExcludeRules, this.optional));
                return;
            }
            ResolvedCoordinates coordinates = this.convertDeclaredCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion());
            for (DependencyArtifact artifact : dependency.getArtifacts()) {
                ResolvedCoordinates artifactCoordinates = coordinates;
                if (!artifact.getName().equals(dependency.getName())) {
                    ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Publishing a dependency with an artifact name different from the dependency's artifactId.").withContext("This functionality is only supported by Ivy repositories.")).withAdvice(String.format("Declare a dependency with artifactId '%s' instead of '%s'.", artifact.getName(), dependency.getName()))).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "publishing_artifact_name_different_from_artifact_id_maven")).nagUser();
                    artifactCoordinates = ResolvedCoordinates.create((String)coordinates.getGroup(), (String)artifact.getName(), (String)coordinates.getVersion());
                }
                collector.accept(MavenDependencyFactory.newDependency(artifactCoordinates, artifact.getType(), artifact.getClassifier(), this.scope, allExcludeRules, this.optional));
            }
        }

        private void convertDependencyConstraint(DependencyConstraint dependency, Consumer<MavenDependency> collector) {
            ResolvedCoordinates identifier;
            if (dependency instanceof DefaultProjectDependencyConstraint) {
                identifier = this.componentDependencyResolver.resolveComponentCoordinates((DefaultProjectDependencyConstraint)dependency);
            } else {
                identifier = this.componentDependencyResolver.resolveComponentCoordinates(dependency);
                if (identifier == null) {
                    identifier = this.convertDeclaredCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion());
                }
            }
            if (identifier.getVersion() == null) {
                return;
            }
            collector.accept(MavenDependencyFactory.newDependency(identifier, null, null, null, Collections.emptySet(), false));
        }

        private void convertImportDependencyConstraint(ModuleDependency dependency, Consumer<MavenDependency> collector) {
            ResolvedCoordinates identifier = this.resolveDependency(dependency);
            collector.accept(MavenDependencyFactory.newDependency(identifier, "pom", null, "import", Collections.emptySet(), false));
        }

        private ResolvedCoordinates resolveDependency(ModuleDependency dependency) {
            if (dependency instanceof ProjectDependency) {
                return this.variantDependencyResolver.resolveVariantCoordinates((ProjectDependency)dependency, this.warnings);
            }
            if (dependency instanceof ExternalDependency) {
                ResolvedCoordinates identifier = this.variantDependencyResolver.resolveVariantCoordinates((ExternalDependency)dependency, this.warnings);
                if (identifier != null) {
                    return identifier;
                }
                return this.convertDeclaredCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion());
            }
            throw new GradleException("Unsupported dependency type: " + dependency.getClass().getName());
        }

        private ResolvedCoordinates convertDeclaredCoordinates(String groupId, String artifactId, @Nullable String version) {
            if (version == null) {
                return ResolvedCoordinates.create((String)groupId, (String)artifactId, null);
            }
            if (DefaultVersionSelectorScheme.isSubVersion((String)version) || DefaultVersionSelectorScheme.isLatestVersion((String)version) && !MavenVersionSelectorScheme.isSubstituableLatest((String)version)) {
                this.warnings.addIncompatible(String.format("%s:%s:%s declared with a Maven incompatible version notation", groupId, artifactId, version));
            }
            return ResolvedCoordinates.create((String)groupId, (String)artifactId, (String)this.versionRangeMapper.map(version));
        }

        private static MavenDependency newDependency(ResolvedCoordinates coordinates, @Nullable String type, @Nullable String classifier, @Nullable String scope, Set<ExcludeRule> excludeRules, boolean optional) {
            return new DefaultMavenDependency(coordinates.getGroup(), coordinates.getName(), coordinates.getVersion(), type, classifier, scope, excludeRules, optional);
        }

        private static Set<ExcludeRule> getExcludeRules(Set<ExcludeRule> globalExcludes, ModuleDependency dependency) {
            if (!dependency.isTransitive()) {
                return EXCLUDE_ALL_RULE;
            }
            Set excludeRules = dependency.getExcludeRules();
            if (excludeRules.isEmpty()) {
                return globalExcludes;
            }
            if (globalExcludes.isEmpty()) {
                return excludeRules;
            }
            return Sets.union(globalExcludes, (Set)excludeRules);
        }
    }
}

