/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.InputExecutionState;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureStateBeforeExecutionStep<C extends PreviousExecutionContext, R extends CachingResult>
extends BuildOperationStep<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureStateBeforeExecutionStep.class);
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final OutputSnapshotter outputSnapshotter;
    private final OverlappingOutputDetector overlappingOutputDetector;
    private final Step<? super BeforeExecutionContext, ? extends R> delegate;

    public CaptureStateBeforeExecutionStep(BuildOperationExecutor buildOperationExecutor, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, OutputSnapshotter outputSnapshotter, OverlappingOutputDetector overlappingOutputDetector, Step<? super BeforeExecutionContext, ? extends R> delegate) {
        super(buildOperationExecutor);
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.outputSnapshotter = outputSnapshotter;
        this.overlappingOutputDetector = overlappingOutputDetector;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        Optional<BeforeExecutionState> beforeExecutionState = ((WorkspaceContext)context).getHistory().map(history -> this.captureExecutionState(work, (PreviousExecutionContext)context));
        return (R)((CachingResult)this.delegate.execute(work, new BeforeExecutionContext((PreviousExecutionContext)context, beforeExecutionState.orElse(null))));
    }

    @Nonnull
    private BeforeExecutionState captureExecutionState(UnitOfWork work, PreviousExecutionContext context) {
        return this.operation(operationContext -> {
            ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
            OverlappingOutputs overlappingOutputs = this.detectOverlappingOutputs(work, context, unfilteredOutputSnapshots);
            BeforeExecutionState executionState = this.captureExecutionStateWithOutputs(work, context, unfilteredOutputSnapshots, overlappingOutputs);
            operationContext.setResult((Object)Operation.Result.INSTANCE);
            return executionState;
        }, BuildOperationDescriptor.displayName((String)("Snapshot inputs and outputs before executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    @Nullable
    private OverlappingOutputs detectOverlappingOutputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots) {
        if (work.getOverlappingOutputHandling() == UnitOfWork.OverlappingOutputHandling.IGNORE_OVERLAPS) {
            return null;
        }
        ImmutableSortedMap previousOutputSnapshots = context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        return this.overlappingOutputDetector.detect((ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputSnapshots, unfilteredOutputSnapshots);
    }

    private BeforeExecutionState captureExecutionStateWithOutputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots, @Nullable OverlappingOutputs overlappingOutputs) {
        Optional<PreviousExecutionState> previousExecutionState = context.getPreviousExecutionState();
        ImplementationsBuilder implementationsBuilder = new ImplementationsBuilder(this.classLoaderHierarchyHasher);
        work.visitImplementations(implementationsBuilder);
        ImplementationSnapshot implementation = implementationsBuilder.getImplementation();
        ImmutableList<ImplementationSnapshot> additionalImplementations = implementationsBuilder.getAdditionalImplementations();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)work.getDisplayName(), (Object)implementation);
            LOGGER.debug("Additional implementations for {}: {}", (Object)work.getDisplayName(), additionalImplementations);
        }
        ImmutableSortedMap previousInputPropertySnapshots = previousExecutionState.map(InputExecutionState::getInputProperties).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap previousInputFileFingerprints = previousExecutionState.map(InputExecutionState::getInputFileProperties).orElse(ImmutableSortedMap.of());
        InputFingerprinter.Result newInputs = work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)previousInputPropertySnapshots, (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)previousInputFileFingerprints, context.getInputProperties(), context.getInputFileProperties(), work::visitRegularInputs);
        return new DefaultBeforeExecutionState(implementation, additionalImplementations, newInputs.getAllValueSnapshots(), newInputs.getAllFileFingerprints(), unfilteredOutputSnapshots, overlappingOutputs);
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }

    private static class ImplementationsBuilder
    implements UnitOfWork.ImplementationVisitor {
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private ImplementationSnapshot implementation;
        private final ImmutableList.Builder<ImplementationSnapshot> additionalImplementations = ImmutableList.builder();

        public ImplementationsBuilder(ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        @Override
        public void visitImplementation(Class<?> implementation) {
            this.visitImplementation(ImplementationSnapshot.of(implementation, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher));
        }

        @Override
        public void visitImplementation(ImplementationSnapshot implementation) {
            if (this.implementation == null) {
                this.implementation = implementation;
            } else {
                this.additionalImplementations.add((Object)implementation);
            }
        }

        public ImplementationSnapshot getImplementation() {
            if (this.implementation == null) {
                throw new IllegalStateException("No implementation is set");
            }
            return this.implementation;
        }

        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.additionalImplementations.build();
        }
    }
}

