/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskOptionsGenerator;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ParsedCommandLineOption;
import org.gradle.execution.commandline.TaskConfigurationException;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.typeconversion.TypeConversionException;

@ServiceScope(value=Scopes.Gradle.class)
public class CommandLineTaskConfigurer {
    private OptionReader optionReader;

    public CommandLineTaskConfigurer(OptionReader optionReader) {
        this.optionReader = optionReader;
    }

    public List<String> configureTasks(Collection<Task> tasks, List<String> arguments) {
        assert (!tasks.isEmpty());
        if (arguments.isEmpty()) {
            return arguments;
        }
        return this.configureTasksNow(tasks, arguments);
    }

    private List<String> configureTasksNow(Collection<Task> tasks, List<String> arguments) {
        List remainingArguments = null;
        for (Task task : tasks) {
            ParsedCommandLine parsed;
            CommandLineParser parser = new CommandLineParser();
            TaskOptionsGenerator.TaskOptions taskOptions = TaskOptionsGenerator.generate(task, this.optionReader);
            List<OptionDescriptor> commandLineOptions = taskOptions.getAll();
            for (OptionDescriptor optionDescriptor : commandLineOptions) {
                String optionName = optionDescriptor.getName();
                CommandLineOption option = parser.option(new String[]{optionName});
                option.hasDescription(optionDescriptor.getDescription());
                option.hasArgument(optionDescriptor.getArgumentType());
            }
            taskOptions.addMutualExclusions(parser);
            try {
                parsed = parser.parse(arguments);
            }
            catch (CommandLineArgumentException e) {
                throw new TaskConfigurationException(task.getPath(), "Problem configuring task " + task.getPath() + " from command line.", (Exception)((Object)e));
            }
            for (OptionDescriptor commandLineOptionDescriptor : commandLineOptions) {
                String name = commandLineOptionDescriptor.getName();
                if (!parsed.hasOption(name)) continue;
                ParsedCommandLineOption o = parsed.option(name);
                try {
                    commandLineOptionDescriptor.apply(task, o.getValues());
                }
                catch (TypeConversionException ex) {
                    throw new TaskConfigurationException(task.getPath(), String.format("Problem configuring option '%s' on task '%s' from command line.", name, task.getPath()), (Exception)((Object)ex));
                }
            }
            assert (remainingArguments == null || remainingArguments.equals(parsed.getExtraArguments())) : "we expect all options to be consumed by each task so remainingArguments should be the same for each task";
            remainingArguments = parsed.getExtraArguments();
        }
        return remainingArguments;
    }
}

