/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.OutputStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.TerminalSize;
import net.rubygrapefruit.platform.terminal.Terminals;

public class WindowsTerminal
extends AbstractTerminal {
    private final Object lock = new Object();
    private final Terminals.Output output;
    private final OutputStream outputStream;

    public WindowsTerminal(Terminals.Output output) {
        this.output = output;
        this.outputStream = WindowsTerminal.streamForOutput(output);
    }

    public String toString() {
        return String.format("Windows console on %s", this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.initConsole(this.output.ordinal(), result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not open console for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
    }

    public boolean supportsColor() {
        return true;
    }

    public boolean supportsTextAttributes() {
        return true;
    }

    public boolean supportsCursorMotion() {
        return true;
    }

    public boolean supportsCursorVisibility() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalSize getTerminalSize() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            MutableTerminalSize size = new MutableTerminalSize();
            WindowsConsoleFunctions.getConsoleSize(this.output.ordinal(), size, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not determine console size for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
            return size;
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput bold() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.boldOn(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not switch console to bold mode for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput foreground(TerminalOutput.Color color) {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.foreground(color.ordinal(), result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not change console foreground color for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    public TerminalOutput dim() throws NativeException {
        return this.normal();
    }

    public TerminalOutput bright() throws NativeException {
        return this.bold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput defaultForeground() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.defaultForeground(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not switch console to default foreground for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput normal() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.boldOff(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not switch console to normal mode for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput reset() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.reset(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not reset console for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput hideCursor() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.hideCursor(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not hide cursor for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput showCursor() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.showCursor(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not show cursor for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorDown(int count) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.down(count, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not move cursor down for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorUp(int count) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.up(count, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not move cursor up for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorLeft(int count) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.left(count, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not move cursor left for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorRight(int count) throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.right(count, result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not move cursor right for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput cursorStartOfLine() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.startLine(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could not move cursor to start of line for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalOutput clearToEndOfLine() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result = new FunctionResult();
            WindowsConsoleFunctions.clearToEndOfLine(result);
            if (result.isFailed()) {
                throw new NativeException(String.format("Could clear to end of line for %s: %s", this.getOutputDisplay(), result.getMessage()));
            }
        }
        return this;
    }
}

