/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.gradle.api.GradleScriptException;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.initialization.exception.ExceptionCollector;
import org.gradle.initialization.exception.InitializationException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.problems.Location;
import org.gradle.problems.buildtree.ProblemLocationAnalyzer;

public class DefaultExceptionAnalyser
implements ExceptionCollector {
    private final ProblemLocationAnalyzer locationAnalyzer;

    public DefaultExceptionAnalyser(ProblemLocationAnalyzer locationAnalyzer) {
        this.locationAnalyzer = locationAnalyzer;
    }

    @Override
    public void collectFailures(Throwable exception, Collection<? super Throwable> failures) {
        if (exception instanceof ProjectConfigurationException) {
            ProjectConfigurationException projectConfigurationException = (ProjectConfigurationException)exception;
            ArrayList<Throwable> additionalFailures = new ArrayList<Throwable>();
            for (Throwable cause : projectConfigurationException.getCauses()) {
                if (cause instanceof GradleScriptException) {
                    failures.add(this.transform(cause));
                    continue;
                }
                additionalFailures.add(cause);
            }
            if (!additionalFailures.isEmpty()) {
                projectConfigurationException.initCauses(additionalFailures);
                failures.add(this.transform((Throwable)projectConfigurationException));
            }
        } else if (exception instanceof ServiceCreationException) {
            failures.add(this.transform((Throwable)((Object)new InitializationException(exception))));
        } else {
            failures.add(this.transform(exception));
        }
    }

    private Throwable transform(Throwable exception) {
        Throwable actualException = this.findDeepestRootException(exception);
        if (actualException instanceof LocationAwareException) {
            return actualException;
        }
        String source = null;
        Integer lineNumber = null;
        if (actualException instanceof ScriptCompilationException) {
            ScriptCompilationException scriptCompilationException = (ScriptCompilationException)((Object)actualException);
            source = scriptCompilationException.getScriptSource().getLongDisplayName().getCapitalizedDisplayName();
            lineNumber = scriptCompilationException.getLineNumber();
        }
        if (source == null) {
            for (Throwable currentException = actualException; currentException != null; currentException = currentException.getCause()) {
                Location location = this.locationAnalyzer.locationForUsage(Arrays.asList(currentException.getStackTrace()), true);
                if (location == null) continue;
                source = location.getSourceLongDisplayName().getCapitalizedDisplayName();
                lineNumber = location.getLineNumber();
            }
        }
        return new LocationAwareException(actualException, source, lineNumber);
    }

    private Throwable findDeepestRootException(Throwable exception) {
        Throwable locationAware = null;
        Throwable result = null;
        Throwable contextMatch = null;
        for (Throwable current = exception; current != null; current = current.getCause()) {
            if (current instanceof LocationAwareException) {
                locationAware = current;
                continue;
            }
            if (current instanceof GradleScriptException || current instanceof TaskExecutionException) {
                result = current;
                continue;
            }
            if (contextMatch != null || current.getClass().getAnnotation(Contextual.class) == null) continue;
            contextMatch = current;
        }
        if (locationAware != null) {
            return locationAware;
        }
        if (result != null) {
            return result;
        }
        if (contextMatch != null) {
            return contextMatch;
        }
        return exception;
    }
}

