/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.DefaultLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.model.ComponentConfigurationIdentifier;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultLocalConfigurationMetadataBuilder
implements LocalConfigurationMetadataBuilder {
    private final DependencyMetadataFactory dependencyMetadataFactory;
    private final ExcludeRuleConverter excludeRuleConverter;

    public DefaultLocalConfigurationMetadataBuilder(DependencyMetadataFactory dependencyMetadataFactory, ExcludeRuleConverter excludeRuleConverter) {
        this.dependencyMetadataFactory = dependencyMetadataFactory;
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public LocalConfigurationMetadata create(final ConfigurationInternal configuration, ConfigurationsProvider configurationsProvider, LocalComponentMetadata parent, LocalConfigurationMetadataBuilder.DependencyCache dependencyCache, final ModelContainer<?> model, final CalculatedValueContainerFactory calculatedValueContainerFactory) {
        final ComponentIdentifier componentId = parent.getId();
        final ComponentConfigurationIdentifier configurationIdentifier = new ComponentConfigurationIdentifier(componentId, configuration.getName());
        final ImmutableList.Builder artifactBuilder = ImmutableList.builder();
        final ImmutableSet.Builder variantsBuilder = ImmutableSet.builder();
        configuration.collectVariants(new ConfigurationInternal.VariantVisitor(){

            @Override
            public void visitArtifacts(Collection<? extends PublishArtifact> artifacts) {
                artifactBuilder.addAll(artifacts);
            }

            @Override
            public void visitOwnVariant(DisplayName displayName, ImmutableAttributes attributes, Collection<? extends Capability> capabilities, Collection<? extends PublishArtifact> artifacts) {
                variantsBuilder.add((Object)new LocalVariantMetadata(configuration.getName(), configurationIdentifier, componentId, displayName, attributes, artifacts, ImmutableCapabilities.of(capabilities), model, calculatedValueContainerFactory));
            }

            @Override
            public void visitChildVariant(String name, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends Capability> capabilities, Collection<? extends PublishArtifact> artifacts) {
                variantsBuilder.add((Object)new LocalVariantMetadata(configuration.getName() + "-" + name, new NestedVariantIdentifier(configurationIdentifier, name), componentId, displayName, attributes, artifacts, ImmutableCapabilities.of(capabilities), model, calculatedValueContainerFactory));
            }
        });
        DefaultLocalConfigurationMetadataBuilder.runDependencyActionsInHierarchy(configuration);
        ImmutableAttributes attributes = configuration.getAttributes().asImmutable();
        ImmutableSet<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        CalculatedValueContainer dependencies = calculatedValueContainerFactory.create(Describables.of((Object)"Dependency state for", (Object)configuration.getDescription()), context -> {
            LocalConfigurationMetadataBuilder.DependencyState state = this.getState(configurationsProvider, hierarchy, componentId, dependencyCache);
            return new DefaultLocalConfigurationMetadata.ConfigurationDependencyMetadata((List<LocalOriginDependencyMetadata>)DefaultLocalConfigurationMetadataBuilder.maybeForceDependencies(state.dependencies, attributes), (Set<LocalFileDependencyMetadata>)state.files, (List<ExcludeMetadata>)state.excludes);
        });
        return new DefaultLocalConfigurationMetadata(configuration.getName(), configuration.getDescription(), componentId, configuration.isVisible(), configuration.isTransitive(), (Set<String>)hierarchy, attributes, ImmutableCapabilities.of(Configurations.collectCapabilities(configuration, Sets.newHashSet(), Sets.newHashSet())), configuration.isCanBeConsumed(), configuration.isDeprecatedForConsumption(), configuration.isCanBeResolved(), (CalculatedValue<DefaultLocalConfigurationMetadata.ConfigurationDependencyMetadata>)dependencies, (Set<LocalVariantMetadata>)variantsBuilder.build(), (List<PublishArtifact>)artifactBuilder.build(), model, calculatedValueContainerFactory, parent);
    }

    private static void runDependencyActionsInHierarchy(ConfigurationInternal conf) {
        HashSet<Configuration> seen = new HashSet<Configuration>();
        ArrayDeque<Configuration> remaining = new ArrayDeque<Configuration>();
        remaining.add(conf);
        seen.add(conf);
        while (!remaining.isEmpty()) {
            Configuration current = (Configuration)remaining.remove();
            ((ConfigurationInternal)current).runDependencyActions();
            for (Configuration parent : current.getExtendsFrom()) {
                if (!seen.add(parent)) continue;
                remaining.add(parent);
            }
        }
    }

    public LocalConfigurationMetadataBuilder.DependencyState getState(ConfigurationsProvider configurations, ImmutableSet<String> hierarchy, ComponentIdentifier componentId, LocalConfigurationMetadataBuilder.DependencyCache cache) {
        ImmutableList.Builder dependencies = ImmutableList.builder();
        ImmutableSet.Builder files = ImmutableSet.builder();
        ImmutableList.Builder excludes = ImmutableList.builder();
        for (ConfigurationInternal configurationInternal : configurations.getAll()) {
            if (!hierarchy.contains((Object)configurationInternal.getName())) continue;
            LocalConfigurationMetadataBuilder.DependencyState defined = this.getDefinedState(configurationInternal, componentId, cache);
            dependencies.addAll(defined.dependencies);
            files.addAll(defined.files);
            excludes.addAll(defined.excludes);
        }
        return new LocalConfigurationMetadataBuilder.DependencyState((ImmutableList<LocalOriginDependencyMetadata>)dependencies.build(), (ImmutableSet<LocalFileDependencyMetadata>)files.build(), (ImmutableList<ExcludeMetadata>)excludes.build());
    }

    private LocalConfigurationMetadataBuilder.DependencyState getDefinedState(ConfigurationInternal configuration, ComponentIdentifier componentId, LocalConfigurationMetadataBuilder.DependencyCache cache) {
        return cache.computeIfAbsent(configuration, componentId, this::doGetDefinedState);
    }

    private LocalConfigurationMetadataBuilder.DependencyState doGetDefinedState(ConfigurationInternal configuration, ComponentIdentifier componentId) {
        AttributeContainerInternal attributes = configuration.getAttributes();
        ImmutableList.Builder dependencyBuilder = ImmutableList.builder();
        ImmutableSet.Builder fileBuilder = ImmutableSet.builder();
        ImmutableList.Builder excludeBuilder = ImmutableList.builder();
        for (Dependency dependency : configuration.getDependencies()) {
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                dependencyBuilder.add((Object)this.dependencyMetadataFactory.createDependencyMetadata(componentId, configuration.getName(), (AttributeContainer)attributes, moduleDependency));
                continue;
            }
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
                fileBuilder.add((Object)new DefaultLocalFileDependencyMetadata(fileDependency));
                continue;
            }
            throw new IllegalArgumentException("Cannot convert dependency " + dependency + " to local component dependency metadata.");
        }
        for (DependencyConstraint dependencyConstraint : configuration.getDependencyConstraints()) {
            dependencyBuilder.add((Object)this.dependencyMetadataFactory.createDependencyConstraintMetadata(componentId, configuration.getName(), (AttributeContainer)attributes, dependencyConstraint));
        }
        for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
            excludeBuilder.add((Object)this.excludeRuleConverter.convertExcludeRule(excludeRule));
        }
        return new LocalConfigurationMetadataBuilder.DependencyState((ImmutableList<LocalOriginDependencyMetadata>)dependencyBuilder.build(), (ImmutableSet<LocalFileDependencyMetadata>)fileBuilder.build(), (ImmutableList<ExcludeMetadata>)excludeBuilder.build());
    }

    private static ImmutableList<LocalOriginDependencyMetadata> maybeForceDependencies(ImmutableList<LocalOriginDependencyMetadata> dependencies, ImmutableAttributes attributes) {
        AttributeValue attributeValue = attributes.findEntry(Category.CATEGORY_ATTRIBUTE);
        if (!attributeValue.isPresent() || !((Category)attributeValue.get()).getName().equals("enforced-platform")) {
            return dependencies;
        }
        ImmutableList.Builder forcedDependencies = ImmutableList.builder();
        for (LocalOriginDependencyMetadata rawDependency : dependencies) {
            forcedDependencies.add((Object)rawDependency.forced());
        }
        return forcedDependencies.build();
    }

    private static class DefaultLocalFileDependencyMetadata
    implements LocalFileDependencyMetadata {
        private final FileCollectionDependency fileDependency;

        DefaultLocalFileDependencyMetadata(FileCollectionDependency fileDependency) {
            this.fileDependency = fileDependency;
        }

        @Override
        public FileCollectionDependency getSource() {
            return this.fileDependency;
        }

        @Override
        @Nullable
        public ComponentIdentifier getComponentId() {
            return ((SelfResolvingDependencyInternal)this.fileDependency).getTargetComponentId();
        }

        @Override
        public FileCollectionInternal getFiles() {
            return (FileCollectionInternal)this.fileDependency.getFiles();
        }
    }

    private static class NestedVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final VariantResolveMetadata.Identifier parent;
        private final String name;

        public NestedVariantIdentifier(VariantResolveMetadata.Identifier parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            return this.parent.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedVariantIdentifier other = (NestedVariantIdentifier)obj;
            return this.parent.equals(other.parent) && this.name.equals(other.name);
        }
    }
}

