/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u001a&\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002\u001a\u001d\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0012\u00a2\u0006\u0002\u0010\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u00a8\u0006\u001a"}, d2={"nTabs", "", "amount", "", "parseSpaceSeparatedArgs", "", "argsString", "printMilliseconds", "", "message", "body", "Lkotlin/Function0;", "profile", "profileIf", "condition", "", "getValueOrNull", "T", "Lkotlin/Lazy;", "(Lkotlin/Lazy;)Ljava/lang/Object;", "prefixBaseNameIfNot", "prefix", "prefixIfNot", "removeSuffixIfPresent", "suffix", "suffixIfNot", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\norg/jetbrains/kotlin/util/UtilKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,76:1\n17#2,6:77\n1179#3,2:83\n*S KotlinDebug\n*F\n+ 1 Util.kt\norg/jetbrains/kotlin/util/UtilKt\n*L\n12#1:77,6\n56#1:83,2\n*E\n"})
public final class UtilKt {
    private static final void printMilliseconds(String message, Function0<Unit> body2) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        body2.invoke();
        long time = System.currentTimeMillis() - start$iv;
        System.out.println((Object)(message + ": " + time + " ms"));
    }

    public static final void profile(@NotNull String message, @NotNull Function0<Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        String string2 = System.getProperty("konan.profile");
        UtilKt.profileIf(string2 != null ? string2.equals("true") : false, message, body2);
    }

    private static final void profileIf(boolean condition, String message, Function0<Unit> body2) {
        if (condition) {
            UtilKt.printMilliseconds(message, body2);
        } else {
            body2.invoke();
        }
    }

    @NotNull
    public static final String nTabs(int amount) {
        String string2 = "%1$-" + (amount + 1) * 4 + 's';
        Object[] objectArray = new Object[]{""};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public static final String prefixIfNot(@NotNull String $this$prefixIfNot, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prefixIfNot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.startsWith$default((String)$this$prefixIfNot, (String)prefix, (boolean)false, (int)2, null) ? $this$prefixIfNot : prefix + $this$prefixIfNot;
    }

    @NotNull
    public static final String prefixBaseNameIfNot(@NotNull String $this$prefixBaseNameIfNot, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prefixBaseNameIfNot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File file2 = new File($this$prefixBaseNameIfNot).getAbsoluteFile();
        String name2 = file2.getName();
        String directory = file2.getParent();
        return directory + '/' + UtilKt.prefixIfNot(name2, prefix);
    }

    @NotNull
    public static final String suffixIfNot(@NotNull String $this$suffixIfNot, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)$this$suffixIfNot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return StringsKt.endsWith$default((String)$this$suffixIfNot, (String)suffix, (boolean)false, (int)2, null) ? $this$suffixIfNot : $this$suffixIfNot + suffix;
    }

    @NotNull
    public static final String removeSuffixIfPresent(@NotNull String $this$removeSuffixIfPresent, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)$this$removeSuffixIfPresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return StringsKt.endsWith$default((String)$this$removeSuffixIfPresent, (String)suffix, (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$removeSuffixIfPresent, (int)suffix.length()) : $this$removeSuffixIfPresent;
    }

    @Nullable
    public static final <T> T getValueOrNull(@NotNull Lazy<? extends T> $this$getValueOrNull) {
        Intrinsics.checkNotNullParameter($this$getValueOrNull, (String)"<this>");
        return (T)($this$getValueOrNull.isInitialized() ? $this$getValueOrNull.getValue() : null);
    }

    @NotNull
    public static final List<String> parseSpaceSeparatedArgs(@NotNull String argsString) {
        Intrinsics.checkNotNullParameter((Object)argsString, (String)"argsString");
        List parsedArgs = new ArrayList();
        boolean inQuotes = false;
        Ref.ObjectRef currentCharSequence = new Ref.ObjectRef();
        currentCharSequence.element = new StringBuilder();
        CharSequence $this$forEach$iv = argsString;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (c == '\"') {
                boolean bl2 = inQuotes = !inQuotes;
                if (inQuotes) continue;
                UtilKt.parseSpaceSeparatedArgs$saveArg((Ref.ObjectRef<StringBuilder>)currentCharSequence, parsedArgs, true);
                continue;
            }
            if (CharsKt.isWhitespace((char)c) && !inQuotes) {
                UtilKt.parseSpaceSeparatedArgs$saveArg((Ref.ObjectRef<StringBuilder>)currentCharSequence, parsedArgs, false);
                continue;
            }
            ((StringBuilder)currentCharSequence.element).append(c);
        }
        if (inQuotes) {
            throw new IllegalStateException(("No close-quote was found in " + currentCharSequence.element + '.').toString());
        }
        UtilKt.parseSpaceSeparatedArgs$saveArg((Ref.ObjectRef<StringBuilder>)currentCharSequence, parsedArgs, false);
        return parsedArgs;
    }

    private static final void parseSpaceSeparatedArgs$saveArg(Ref.ObjectRef<StringBuilder> currentCharSequence, List<String> parsedArgs, boolean wasInQuotes) {
        if (wasInQuotes || !StringsKt.isBlank((CharSequence)((CharSequence)currentCharSequence.element))) {
            String string2 = ((StringBuilder)currentCharSequence.element).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentCharSequence.toString()");
            parsedArgs.add(string2);
            currentCharSequence.element = new StringBuilder();
        }
    }
}

