/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.incremental.js.FunctionWithSourceInfo;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.JsInlineFunctionHash;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJZ\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J(\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J0\u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0018\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u0013H\u0016J\u0006\u00105\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer;", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/EventManager;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "getRpcProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "processIrFile", "", "sourceFile", "Ljava/io/File;", "fileData", "", "types", "signatures", "strings", "declarations", "bodies", "fqn", "fileMetadata", "debugInfo", "processHeader", "headerMetadata", "processPackagePart", "packagePartMetadata", "binaryAst", "inlineData", "deferInlineFuncs", "", "Lorg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer$JsInlineFunction;", "processInlineFunction", "fqName", "", "inlineFunction", "", "line", "", "column", "processInlineFunctions", "", "functions", "", "Lorg/jetbrains/kotlin/incremental/js/JsInlineFunctionHash;", "processPackageMetadata", "packageName", "metadata", "flush", "JsInlineFunction", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nRemoteIncrementalResultsConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteIncrementalResultsConsumer.kt\norg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n44#2,4:76\n44#2,4:80\n44#2,4:84\n44#2,2:88\n46#2,2:94\n1557#3:90\n1628#3,3:91\n*S KotlinDebug\n*F\n+ 1 RemoteIncrementalResultsConsumer.kt\norg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer\n*L\n40#1:76,4\n46#1:80,4\n62#1:84,4\n68#1:88,2\n68#1:94,2\n69#1:90\n69#1:91,3\n*E\n"})
public final class RemoteIncrementalResultsConsumer
implements IncrementalResultsConsumer {
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final Profiler rpcProfiler;
    @NotNull
    private final List<JsInlineFunction> deferInlineFuncs;

    public RemoteIncrementalResultsConsumer(@NotNull CompilerCallbackServicesFacade facade, @NotNull EventManager eventManager, @NotNull Profiler rpcProfiler) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)eventManager, (String)"eventManager");
        Intrinsics.checkNotNullParameter((Object)rpcProfiler, (String)"rpcProfiler");
        this.facade = facade;
        this.rpcProfiler = rpcProfiler;
        eventManager.onCompilationFinished((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((RemoteIncrementalResultsConsumer)this.receiver).flush();
            }

            public final String getSignature() {
                return "flush()V";
            }

            public final String getName() {
                return "flush";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(RemoteIncrementalResultsConsumer.class);
            }
        }));
        this.deferInlineFuncs = new ArrayList();
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final Profiler getRpcProfiler() {
        return this.rpcProfiler;
    }

    public void processIrFile(@NotNull File sourceFile, @NotNull byte[] fileData, @NotNull byte[] types, @NotNull byte[] signatures, @NotNull byte[] strings, @NotNull byte[] declarations, @NotNull byte[] bodies, @NotNull byte[] fqn, @NotNull byte[] fileMetadata, @Nullable byte[] debugInfo) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)declarations, (String)"declarations");
        Intrinsics.checkNotNullParameter((Object)bodies, (String)"bodies");
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Intrinsics.checkNotNullParameter((Object)fileMetadata, (String)"fileMetadata");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public void processHeader(@NotNull byte[] headerMetadata) {
        Intrinsics.checkNotNullParameter((Object)headerMetadata, (String)"headerMetadata");
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.facade.incrementalResultsConsumer_processHeader(headerMetadata);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }

    public void processPackagePart(@NotNull File sourceFile, @NotNull byte[] packagePartMetadata, @NotNull byte[] binaryAst, @NotNull byte[] inlineData) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)packagePartMetadata, (String)"packagePartMetadata");
        Intrinsics.checkNotNullParameter((Object)binaryAst, (String)"binaryAst");
        Intrinsics.checkNotNullParameter((Object)inlineData, (String)"inlineData");
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        String string = sourceFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.facade.incrementalResultsConsumer_processPackagePart(string, packagePartMetadata, binaryAst, inlineData);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }

    public void processInlineFunction(@NotNull File sourceFile, @NotNull String fqName, @NotNull Object inlineFunction, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)inlineFunction, (String)"inlineFunction");
        String string = sourceFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.deferInlineFuncs.add(new JsInlineFunction(string, fqName, new FunctionWithSourceInfo(inlineFunction, line, column)));
    }

    @NotNull
    public Void processInlineFunctions(@NotNull Collection<JsInlineFunctionHash> functions) {
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        throw new IllegalStateException("Should not be called in Daemon Server".toString());
    }

    public void processPackageMetadata(@NotNull String packageName, @NotNull byte[] metadata) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.facade.incrementalResultsConsumer_processPackageMetadata(packageName, metadata);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void flush() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Iterable iterable = this.deferInlineFuncs;
        CompilerCallbackServicesFacade compilerCallbackServicesFacade = this.facade;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsInlineFunction jsInlineFunction = (JsInlineFunction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new JsInlineFunctionHash(it.getSourceFilePath(), it.getFqName(), it.getInlineFunction().getMd5()));
        }
        compilerCallbackServicesFacade.incrementalResultsConsumer_processInlineFunctions((List)destination$iv$iv);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer$JsInlineFunction;", "", "sourceFilePath", "", "fqName", "inlineFunction", "Lorg/jetbrains/kotlin/incremental/js/FunctionWithSourceInfo;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/incremental/js/FunctionWithSourceInfo;)V", "getSourceFilePath", "()Ljava/lang/String;", "getFqName", "getInlineFunction", "()Lorg/jetbrains/kotlin/incremental/js/FunctionWithSourceInfo;", "kotlin-daemon"})
    private static final class JsInlineFunction {
        @NotNull
        private final String sourceFilePath;
        @NotNull
        private final String fqName;
        @NotNull
        private final FunctionWithSourceInfo inlineFunction;

        public JsInlineFunction(@NotNull String sourceFilePath, @NotNull String fqName, @NotNull FunctionWithSourceInfo inlineFunction) {
            Intrinsics.checkNotNullParameter((Object)sourceFilePath, (String)"sourceFilePath");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)inlineFunction, (String)"inlineFunction");
            this.sourceFilePath = sourceFilePath;
            this.fqName = fqName;
            this.inlineFunction = inlineFunction;
        }

        @NotNull
        public final String getSourceFilePath() {
            return this.sourceFilePath;
        }

        @NotNull
        public final String getFqName() {
            return this.fqName;
        }

        @NotNull
        public final FunctionWithSourceInfo getInlineFunction() {
            return this.inlineFunction;
        }
    }
}

