/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.GenericTestReportGenerator;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.results.TestExecutionResultsListener;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.problems.buildtree.ProblemReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class AggregateTestEventReporter
implements ProblemReporter,
TestExecutionResultsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateTestEventReporter.class);
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationExecutor buildOperationExecutor;
    private final MetadataRendererRegistry metadataRendererRegistry;
    private final AtomicInteger numFailedResults = new AtomicInteger(0);
    private final Map<TestDescriptorInternal, Path> results = new ConcurrentHashMap<TestDescriptorInternal, Path>();

    @Inject
    public AggregateTestEventReporter(BuildOperationRunner buildOperationRunner, BuildOperationExecutor buildOperationExecutor, MetadataRendererRegistry metadataRendererRegistry) {
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationExecutor = buildOperationExecutor;
        this.metadataRendererRegistry = metadataRendererRegistry;
    }

    public String getId() {
        return "aggregate-test-results";
    }

    @Override
    public void executionResultsAvailable(TestDescriptorInternal rootDescriptor, Path binaryResultsDir, boolean hasFailures) {
        this.results.put(rootDescriptor, binaryResultsDir);
        if (hasFailures) {
            this.numFailedResults.incrementAndGet();
        }
    }

    public void report(File reportDir, ProblemReporter.ProblemConsumer validationFailures) {
        Path reportLocation = reportDir.toPath().resolve("reports").resolve("aggregate-test-results");
        if (!this.results.isEmpty()) {
            Path reportIndexFile = this.generateTestReport(reportLocation);
            if (this.numFailedResults.get() > 1) {
                AggregateTestEventReporter.emitReport(reportIndexFile);
            }
        } else if (Files.exists(reportLocation, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)reportLocation.toFile());
            }
            catch (IOException e) {
                LOGGER.debug("Failed to delete stale aggregate report directory", (Throwable)e);
            }
        }
    }

    private Path generateTestReport(Path reportDirectory) {
        ArrayList<Path> sortedResults = new ArrayList<Path>(this.results.values());
        sortedResults.sort(Comparator.naturalOrder());
        new GenericTestReportGenerator(sortedResults, this.metadataRendererRegistry).generateReport(this.buildOperationRunner, this.buildOperationExecutor, reportDirectory);
        return reportDirectory.resolve("index.html");
    }

    private static void emitReport(Path reportIndexFile) {
        String url = new ConsoleRenderer().asClickableFileUrl(reportIndexFile.toFile());
        LOGGER.warn("Aggregate test results: {}", (Object)url);
    }
}

