/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator.main;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.declarative.dsl.evaluation.InterpretationSequence;
import org.gradle.declarative.dsl.evaluation.InterpretationSequenceStep;
import org.gradle.internal.declarativedsl.evaluator.defaults.ModelDefaultsDefinitionCollector;
import org.gradle.internal.declarativedsl.evaluator.features.ResolutionResultHandler;
import org.gradle.internal.declarativedsl.evaluator.main.AllSoftwareTypesApplyModelDefaultsHandler;
import org.gradle.internal.declarativedsl.evaluator.main.AnalysisSequenceResult;
import org.gradle.internal.declarativedsl.evaluator.main.ModelDefaultsStorage;
import org.gradle.internal.declarativedsl.evaluator.main.PrebuiltInterpretationSchemaBuilder;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepContext;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepResult;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepRunner;
import org.gradle.internal.declarativedsl.evaluator.runner.EvaluationResult;
import org.gradle.internal.declarativedsl.evaluator.schema.DeclarativeScriptContext;
import org.gradle.internal.declarativedsl.evaluator.schema.InterpretationSchemaBuilder;
import org.gradle.internal.declarativedsl.evaluator.schema.InterpretationSchemaBuildingResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator;", "", "schemaBuilder", "Lorg/gradle/internal/declarativedsl/evaluator/schema/InterpretationSchemaBuilder;", "(Lorg/gradle/internal/declarativedsl/evaluator/schema/InterpretationSchemaBuilder;)V", "analysisContext", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepContext;", "modelDefaultsStorage", "Lorg/gradle/internal/declarativedsl/evaluator/main/ModelDefaultsStorage;", "getSchemaBuilder", "()Lorg/gradle/internal/declarativedsl/evaluator/schema/InterpretationSchemaBuilder;", "stepRunner", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepRunner;", "evaluate", "Lorg/gradle/internal/declarativedsl/evaluator/main/AnalysisSequenceResult;", "scriptFileName", "", "scriptSource", "scriptContextFromFileName", "Lorg/gradle/internal/declarativedsl/evaluator/schema/DeclarativeScriptContext;", "fileName", "Companion", "declarative-dsl-evaluator"})
@SourceDebugExtension(value={"SMAP\nSimpleAnalysisEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAnalysisEvaluator.kt\norg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1279#2,2:98\n1293#2,4:100\n*S KotlinDebug\n*F\n+ 1 SimpleAnalysisEvaluator.kt\norg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator\n*L\n76#1:98,2\n76#1:100,4\n*E\n"})
public final class SimpleAnalysisEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InterpretationSchemaBuilder schemaBuilder;
    @NotNull
    private final AnalysisStepRunner stepRunner;
    @NotNull
    private final ModelDefaultsStorage modelDefaultsStorage;
    @NotNull
    private final AnalysisStepContext analysisContext;

    public SimpleAnalysisEvaluator(@NotNull InterpretationSchemaBuilder schemaBuilder) {
        Intrinsics.checkNotNullParameter((Object)schemaBuilder, (String)"schemaBuilder");
        this.schemaBuilder = schemaBuilder;
        this.stepRunner = new AnalysisStepRunner();
        this.modelDefaultsStorage = new ModelDefaultsStorage();
        Object[] objectArray = new ResolutionResultHandler[]{new ModelDefaultsDefinitionCollector(this.modelDefaultsStorage), new AllSoftwareTypesApplyModelDefaultsHandler(this.modelDefaultsStorage)};
        this.analysisContext = new AnalysisStepContext(CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final InterpretationSchemaBuilder getSchemaBuilder() {
        return this.schemaBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisSequenceResult evaluate(@NotNull String scriptFileName, @NotNull String scriptSource) {
        AnalysisSequenceResult analysisSequenceResult;
        Intrinsics.checkNotNullParameter((Object)scriptFileName, (String)"scriptFileName");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        DeclarativeScriptContext scriptContext = this.scriptContextFromFileName(scriptFileName);
        InterpretationSchemaBuildingResult built = this.schemaBuilder.getEvaluationSchemaForScript(scriptContext);
        if (Intrinsics.areEqual((Object)built, (Object)InterpretationSchemaBuildingResult.SchemaNotBuilt.INSTANCE)) {
            analysisSequenceResult = new AnalysisSequenceResult(MapsKt.emptyMap());
        } else if (built instanceof InterpretationSchemaBuildingResult.InterpretationSequenceAvailable) {
            Iterable $this$associateWith$iv = ((InterpretationSchemaBuildingResult.InterpretationSequenceAvailable)built).getSequence().getSteps();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                InterpretationSequenceStep interpretationSequenceStep = (InterpretationSequenceStep)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                EvaluationResult<AnalysisStepResult> evaluationResult = this.stepRunner.runInterpretationSequenceStep(scriptFileName, scriptSource, (InterpretationSequenceStep)it, this.analysisContext);
                map.put(t, evaluationResult);
            }
            Map map = result$iv;
            analysisSequenceResult = new AnalysisSequenceResult(map);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return analysisSequenceResult;
    }

    private final DeclarativeScriptContext scriptContextFromFileName(String fileName) {
        String string = new File(fileName).getName();
        return Intrinsics.areEqual((Object)string, (Object)"build.gradle.dcl") ? (DeclarativeScriptContext)DeclarativeScriptContext.ProjectScript.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)"settings.gradle.dcl") ? (DeclarativeScriptContext)new DeclarativeScriptContext.SettingsScript(){} : (DeclarativeScriptContext)DeclarativeScriptContext.UnknownScript.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator$Companion;", "", "()V", "withSchema", "Lorg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator;", "settings", "Lorg/gradle/declarative/dsl/evaluation/InterpretationSequence;", "project", "declarative-dsl-evaluator"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleAnalysisEvaluator withSchema(@NotNull InterpretationSequence settings, @NotNull InterpretationSequence project) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new SimpleAnalysisEvaluator(new PrebuiltInterpretationSchemaBuilder(settings, project));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

