/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.impl;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.cc.impl.problems.BuildNameProvider;
import org.gradle.internal.cc.impl.problems.JsonSource;
import org.gradle.internal.cc.impl.problems.JsonWriter;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.configuration.problems.CommonReport;
import org.gradle.internal.configuration.problems.FailureDecorator;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.problems.buildtree.ProblemReporter;
import org.gradle.problems.internal.ProblemReportCreator;
import org.gradle.problems.internal.impl.DefaultProblemsReportCreatorKt;
import org.gradle.problems.internal.impl.JsonProblemWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gradle/problems/internal/impl/DefaultProblemsReportCreator;", "Lorg/gradle/problems/internal/ProblemReportCreator;", "executorFactory", "Lorg/gradle/internal/concurrent/ExecutorFactory;", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "internalOptions", "Lorg/gradle/internal/buildoption/InternalOptions;", "startParameter", "Lorg/gradle/api/internal/StartParameterInternal;", "failureFactory", "Lorg/gradle/internal/problems/failure/FailureFactory;", "buildNameProvider", "Lorg/gradle/internal/cc/impl/problems/BuildNameProvider;", "(Lorg/gradle/internal/concurrent/ExecutorFactory;Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;Lorg/gradle/internal/buildoption/InternalOptions;Lorg/gradle/api/internal/StartParameterInternal;Lorg/gradle/internal/problems/failure/FailureFactory;Lorg/gradle/internal/cc/impl/problems/BuildNameProvider;)V", "failureDecorator", "Lorg/gradle/internal/configuration/problems/FailureDecorator;", "problemCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "report", "Lorg/gradle/internal/configuration/problems/CommonReport;", "taskNames", "", "", "emit", "", "problem", "Lorg/gradle/api/problems/internal/Problem;", "id", "Lorg/gradle/internal/operations/OperationIdentifier;", "getId", "reportDir", "Ljava/io/File;", "validationFailures", "Lorg/gradle/problems/buildtree/ProblemReporter$ProblemConsumer;", "problems"})
public final class DefaultProblemsReportCreator
implements ProblemReportCreator {
    @NotNull
    private final FailureFactory failureFactory;
    @NotNull
    private final BuildNameProvider buildNameProvider;
    @NotNull
    private final CommonReport report;
    @NotNull
    private final List<String> taskNames;
    @NotNull
    private final AtomicInteger problemCount;
    @NotNull
    private final FailureDecorator failureDecorator;

    public DefaultProblemsReportCreator(@NotNull ExecutorFactory executorFactory, @NotNull TemporaryFileProvider temporaryFileProvider, @NotNull InternalOptions internalOptions, @NotNull StartParameterInternal startParameter, @NotNull FailureFactory failureFactory, @NotNull BuildNameProvider buildNameProvider) {
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter((Object)temporaryFileProvider, (String)"temporaryFileProvider");
        Intrinsics.checkNotNullParameter((Object)internalOptions, (String)"internalOptions");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)failureFactory, (String)"failureFactory");
        Intrinsics.checkNotNullParameter((Object)buildNameProvider, (String)"buildNameProvider");
        this.failureFactory = failureFactory;
        this.buildNameProvider = buildNameProvider;
        this.report = new CommonReport(executorFactory, temporaryFileProvider, internalOptions, "problems report", "problems-report", false);
        List list2 = startParameter.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"startParameter.taskNames");
        this.taskNames = list2;
        this.problemCount = new AtomicInteger(0);
        this.failureDecorator = new FailureDecorator();
    }

    @NotNull
    public String getId() {
        return "DefaultProblemsReportCreator";
    }

    public void report(@NotNull File reportDir, @NotNull ProblemReporter.ProblemConsumer validationFailures) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
            Intrinsics.checkNotNullParameter((Object)validationFailures, (String)"validationFailures");
            File file = this.report.writeReportFileTo(FilesKt.resolve((File)reportDir, (String)"reports/problems"), new JsonSource(this){
                final /* synthetic */ DefaultProblemsReportCreator this$0;
                {
                    this.this$0 = $receiver;
                }

                public void writeToJson(JsonWriter jsonWriter) {
                    Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
                    DefaultProblemsReportCreator defaultProblemsReportCreator = this.this$0;
                    JsonWriter $this$writeToJson_u24lambda_u240 = jsonWriter;
                    boolean bl = false;
                    $this$writeToJson_u24lambda_u240.property("problemsReport", (Function0)new Function0<Unit>($this$writeToJson_u24lambda_u240, defaultProblemsReportCreator){
                        final /* synthetic */ JsonWriter $this_with;
                        final /* synthetic */ DefaultProblemsReportCreator this$0;
                        {
                            this.$this_with = $receiver;
                            this.this$0 = $receiver2;
                            super(0);
                        }

                        public final void invoke() {
                            this.$this_with.jsonObject((Function0)new Function0<Unit>(this.$this_with, this.this$0){
                                final /* synthetic */ JsonWriter $this_with;
                                final /* synthetic */ DefaultProblemsReportCreator this$0;
                                {
                                    this.$this_with = $receiver;
                                    this.this$0 = $receiver2;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$this_with.property("totalProblemCount", DefaultProblemsReportCreator.access$getProblemCount$p(this.this$0).get());
                                    String string = DefaultProblemsReportCreator.access$getBuildNameProvider$p(this.this$0).buildName();
                                    if (string != null) {
                                        String string2 = string;
                                        JsonWriter jsonWriter = this.$this_with;
                                        String it = string2;
                                        boolean bl = false;
                                        jsonWriter.property("buildName", it);
                                    }
                                    this.$this_with.property("requestedTasks", CollectionsKt.joinToString$default((Iterable)DefaultProblemsReportCreator.access$getTaskNames$p(this.this$0), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                                    String string3 = new DocumentationRegistry().getDocumentationFor("problems-report");
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DocumentationRegistry().\u2026ionFor(\"problems-report\")");
                                    this.$this_with.property("documentationLink", string3);
                                    this.$this_with.property("documentationLinkCaption", "Problem report");
                                }
                            });
                        }
                    });
                }
            });
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            String url = new ConsoleRenderer().asClickableFileUrl(it);
            DefaultProblemsReportCreatorKt.getLogger().warn("[Incubating] Problems report is available at: " + url);
        }
    }

    public void emit(@NotNull Problem problem, @Nullable OperationIdentifier id) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.problemCount.incrementAndGet();
        this.report.onProblem((JsonSource)new JsonProblemWriter(problem, this.failureDecorator, this.failureFactory));
    }

    public static final /* synthetic */ AtomicInteger access$getProblemCount$p(DefaultProblemsReportCreator $this) {
        return $this.problemCount;
    }

    public static final /* synthetic */ BuildNameProvider access$getBuildNameProvider$p(DefaultProblemsReportCreator $this) {
        return $this.buildNameProvider;
    }

    public static final /* synthetic */ List access$getTaskNames$p(DefaultProblemsReportCreator $this) {
        return $this.taskNames;
    }
}

