/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.nativeplatform.tasks.UnexportMainSymbol;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;

public abstract class CppUnitTestPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        ProviderFactory providers = project.getProviders();
        TaskContainer tasks = project.getTasks();
        final DefaultCppTestSuite testComponent = (DefaultCppTestSuite)this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", (Object)testComponent);
        project.getComponents().add((Object)testComponent);
        testComponent.getBaseName().convention((Object)(project.getName() + "Test"));
        testComponent.getTargetMachines().convention((Iterable)Dimensions.useHostAsDefaultTargetMachine((TargetMachineFactory)this.targetMachineFactory));
        String mainComponentName = "main";
        project.getComponents().withType(ProductionCppComponent.class, component -> {
            if ("main".equals(component.getName())) {
                testComponent.getTargetMachines().convention((Provider)component.getTargetMachines());
                testComponent.getTestedComponent().convention(component);
            }
        });
        testComponent.getTestBinary().convention(project.provider((Callable)new Callable<CppTestExecutable>(){

            @Override
            public CppTestExecutable call() throws Exception {
                return this.getAllBuildableTestExecutable().filter(it -> this.isCurrentArchitecture(it.getNativePlatform())).findFirst().orElseGet(() -> this.getAllBuildableTestExecutable().findFirst().orElseGet(() -> this.getAllTestExecutable().findFirst().orElse(null)));
            }

            private boolean isCurrentArchitecture(NativePlatform targetPlatform) {
                return targetPlatform.getArchitecture().equals(DefaultNativePlatform.getCurrentArchitecture());
            }

            private Stream<DefaultCppTestExecutable> getAllBuildableTestExecutable() {
                return this.getAllTestExecutable().filter(it -> it.getPlatformToolProvider().isAvailable());
            }

            private Stream<DefaultCppTestExecutable> getAllTestExecutable() {
                return testComponent.getBinaries().get().stream().filter(CppTestExecutable.class::isInstance).map(DefaultCppTestExecutable.class::cast);
            }
        }));
        testComponent.getBinaries().whenElementKnown(DefaultCppTestExecutable.class, binary -> {
            TaskProvider testTask = tasks.register(binary.getNames().getTaskName("run"), RunTestExecutable.class, task -> {
                task.setGroup("verification");
                task.setDescription("Executes C++ unit tests.");
                InstallExecutable installTask = (InstallExecutable)binary.getInstallTask().get();
                DirectoryProperty installDirectory = binary.getInstallDirectory();
                task.onlyIf("Test executable installation directory exists", SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)t -> ((Directory)installDirectory.get()).getAsFile().exists()));
                task.getInputs().dir((Object)installDirectory).withPropertyName("installDirectory");
                task.setExecutable(((RegularFile)installTask.getRunScriptFile().get()).getAsFile());
                task.dependsOn(new Object[]{installDirectory});
                task.setOutputDir(((Directory)project.getLayout().getBuildDirectory().dir("test-results/" + binary.getNames().getDirName()).get()).getAsFile());
            });
            binary.getRunTask().set((Provider)testTask);
            this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, (DefaultCppTestExecutable)binary);
        });
        project.afterEvaluate(p -> {
            CppComponent mainComponent = (CppComponent)testComponent.getTestedComponent().getOrNull();
            SetProperty mainTargetMachines = mainComponent != null ? mainComponent.getTargetMachines() : null;
            Dimensions.unitTestVariants((Provider)testComponent.getBaseName(), (SetProperty)testComponent.getTargetMachines(), (SetProperty)mainTargetMachines, (ObjectFactory)this.objectFactory, (ImmutableAttributesFactory)this.attributesFactory, (Provider)providers.provider(() -> project.getGroup().toString()), (Provider)providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost((NativeVariantIdentity)variantIdentity)) {
                    ToolChainSelector.Result result = this.toolChainSelector.select(CppPlatform.class, (Object)new DefaultCppPlatform(variantIdentity.getTargetMachine()));
                    testComponent.addExecutable(variantIdentity.getName().replace("debug", ""), (NativeVariantIdentity)variantIdentity, (CppPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                }
            });
            testComponent.getBinaries().realizeNow();
        });
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project, DefaultCppTestSuite testSuite, DefaultCppTestExecutable testExecutable) {
        CppComponent target = (CppComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionCppComponent)) {
            return;
        }
        ProductionCppComponent testedComponent = (ProductionCppComponent)target;
        TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized(testedBinary -> {
            if (!this.isTestedBinary(testExecutable, testedComponent, (CppBinary)testedBinary)) {
                return;
            }
            testExecutable.getImplementationDependencies().extendsFrom(new Configuration[]{((DefaultCppBinary)testedBinary).getImplementationDependencies()});
            ConfigurableFileCollection testableObjects = project.files(new Object[0]);
            if (target instanceof CppApplication) {
                TaskProvider unexportMainSymbol = tasks.register(testExecutable.getNames().getTaskName("relocateMainFor"), UnexportMainSymbol.class, task -> {
                    String dirName = ((DefaultCppBinary)testedBinary).getNames().getDirName();
                    task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/for-test/" + dirName));
                    task.getObjects().from(new Object[]{testedBinary.getObjects()});
                });
                testableObjects.from(new Object[]{unexportMainSymbol.map(task -> task.getRelocatedObjects())});
            } else {
                testableObjects.from(new Object[]{testedBinary.getObjects()});
            }
            Dependency linkDependency = project.getDependencies().create((Object)testableObjects);
            testExecutable.getLinkConfiguration().getDependencies().add((Object)linkDependency);
        });
    }

    private boolean isTestedBinary(DefaultCppTestExecutable testExecutable, ProductionCppComponent mainComponent, CppBinary testedBinary) {
        return testedBinary.getTargetMachine().getOperatingSystemFamily().getName().equals(testExecutable.getTargetMachine().getOperatingSystemFamily().getName()) && testedBinary.getTargetMachine().getArchitecture().getName().equals(testExecutable.getTargetMachine().getArchitecture().getName()) && !testedBinary.isOptimized() && this.hasDevelopmentBinaryLinkage(mainComponent, testedBinary);
    }

    private boolean hasDevelopmentBinaryLinkage(ProductionCppComponent mainComponent, CppBinary testedBinary) {
        if (!(testedBinary instanceof ConfigurableComponentWithLinkUsage)) {
            return true;
        }
        ConfigurableComponentWithLinkUsage developmentBinaryWithUsage = (ConfigurableComponentWithLinkUsage)mainComponent.getDevelopmentBinary().get();
        ConfigurableComponentWithLinkUsage testedBinaryWithUsage = (ConfigurableComponentWithLinkUsage)testedBinary;
        return testedBinaryWithUsage.getLinkage() == developmentBinaryWithUsage.getLinkage();
    }
}

