/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import java.util.Objects;

public abstract class InterceptScope {
    protected final CallType callType;

    private InterceptScope(CallType callType) {
        this.callType = callType;
    }

    public static InterceptScope constructorsOf(Class<?> constructorClass) {
        return new ConstructorScope(constructorClass);
    }

    public static InterceptScope methodsNamed(String methodName) {
        return new NamedMemberScope(CallType.METHOD, methodName);
    }

    public static InterceptScope readsOfPropertiesNamed(String propertyName) {
        return new NamedMemberScope(CallType.GET_PROPERTY, propertyName);
    }

    public static InterceptScope writesOfPropertiesNamed(String propertyName) {
        return new NamedMemberScope(CallType.SET_PROPERTY, propertyName);
    }

    abstract String getCallSiteName();

    abstract String getTargetDescription();

    public String toString() {
        return "InterceptScope{" + this.callType.descriptorStringPrefix + " " + this.getTargetDescription() + "}";
    }

    private static class ConstructorScope
    extends InterceptScope {
        private final Class<?> constructorClass;

        ConstructorScope(Class<?> constructorClass) {
            super(CallType.CONSTRUCTOR);
            this.constructorClass = constructorClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstructorScope that = (ConstructorScope)o;
            return this.constructorClass.equals(that.constructorClass);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.callType, this.constructorClass});
        }

        @Override
        String getCallSiteName() {
            return "<$constructor$>";
        }

        @Override
        String getTargetDescription() {
            return this.constructorClass.getName();
        }
    }

    private static class NamedMemberScope
    extends InterceptScope {
        private final String memberName;

        NamedMemberScope(CallType callType, String memberName) {
            super(callType);
            this.memberName = memberName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedMemberScope that = (NamedMemberScope)o;
            return this.callType == that.callType && Objects.equals(this.memberName, that.memberName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.callType, this.memberName});
        }

        @Override
        String getCallSiteName() {
            return this.memberName;
        }

        @Override
        String getTargetDescription() {
            return this.memberName;
        }
    }

    private static enum CallType {
        METHOD("call method"),
        GET_PROPERTY("get property"),
        SET_PROPERTY("set property"),
        CONSTRUCTOR("call constructor");

        final String descriptorStringPrefix;

        private CallType(String descriptorStringPrefix) {
            this.descriptorStringPrefix = descriptorStringPrefix;
        }
    }
}

