/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.io.IoFunction;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.tools.api.ApiClassExtractor;
import org.gradle.internal.tools.api.ApiMemberWriterAdapter;
import org.gradle.internal.tools.api.impl.JavaApiMemberWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);
    public static final AbiExtractingClasspathResourceHasher DEFAULT = AbiExtractingClasspathResourceHasher.withFallback(ApiClassExtractor.withWriter((ApiMemberWriterAdapter)JavaApiMemberWriter.adapter()).includePackagePrivateMembers().build());
    private final ApiClassExtractor extractor;
    private final FallbackStrategy fallbackStrategy;

    private AbiExtractingClasspathResourceHasher(ApiClassExtractor extractor, FallbackStrategy fallbackStrategy) {
        this.extractor = extractor;
        this.fallbackStrategy = fallbackStrategy;
    }

    public static AbiExtractingClasspathResourceHasher withFallback(ApiClassExtractor extractor) {
        return new AbiExtractingClasspathResourceHasher(extractor, FallbackStrategy.FULL_HASH);
    }

    public static AbiExtractingClasspathResourceHasher withoutFallback(ApiClassExtractor extractor) {
        return new AbiExtractingClasspathResourceHasher(extractor, FallbackStrategy.NONE);
    }

    @Nullable
    private HashCode hashClassBytes(byte[] classBytes) {
        return this.extractor.extractApiClassFrom(classBytes).map(Hashing::hashBytes).orElse(null);
    }

    @Nullable
    public HashCode hash(RegularFileSnapshotContext fileSnapshotContext) throws IOException {
        RegularFileSnapshot fileSnapshot = fileSnapshotContext.getSnapshot();
        if (AbiExtractingClasspathResourceHasher.isNotClassFile(fileSnapshot.getName())) {
            return null;
        }
        return this.fallbackStrategy.handle(fileSnapshot, (IoFunction<RegularFileSnapshot, HashCode>)((IoFunction)snapshot -> {
            Path path = Paths.get(snapshot.getAbsolutePath(), new String[0]);
            byte[] classBytes = Files.readAllBytes(path);
            return this.hashClassBytes(classBytes);
        }));
    }

    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (AbiExtractingClasspathResourceHasher.isNotClassFile(zipEntry.getName())) {
            return null;
        }
        byte[] content = zipEntry.getContent();
        return this.fallbackStrategy.handle(new ZipEntryContent(zipEntry.getName(), content), (IoFunction<ZipEntryContent, HashCode>)((IoFunction)entry -> this.hashClassBytes(content)));
    }

    private static boolean isNotClassFile(String name) {
        return !name.endsWith(".class");
    }

    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
        hasher.putString((CharSequence)this.extractor.getClass().getName());
    }

    static enum FallbackStrategy {
        FULL_HASH{

            @Override
            @Nullable
            HashCode handle(RegularFileSnapshot fileSnapshot, IoFunction<RegularFileSnapshot, HashCode> function) {
                try {
                    return (HashCode)function.apply((Object)fileSnapshot);
                }
                catch (Exception e) {
                    LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)fileSnapshot.getName(), (Object)e);
                    return fileSnapshot.getHash();
                }
            }

            @Override
            @Nullable
            HashCode handle(ZipEntryContent zipEntry, IoFunction<ZipEntryContent, HashCode> function) {
                try {
                    return (HashCode)function.apply((Object)zipEntry);
                }
                catch (Exception e) {
                    LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)zipEntry.name, (Object)e);
                    return Hashing.hashBytes((byte[])zipEntry.content);
                }
            }
        }
        ,
        NONE{

            @Override
            @Nullable
            HashCode handle(RegularFileSnapshot fileSnapshot, IoFunction<RegularFileSnapshot, HashCode> function) throws IOException {
                return (HashCode)function.apply((Object)fileSnapshot);
            }

            @Override
            @Nullable
            HashCode handle(ZipEntryContent zipEntry, IoFunction<ZipEntryContent, HashCode> function) throws IOException {
                return (HashCode)function.apply((Object)zipEntry);
            }
        };


        @Nullable
        abstract HashCode handle(RegularFileSnapshot var1, IoFunction<RegularFileSnapshot, HashCode> var2) throws IOException;

        @Nullable
        abstract HashCode handle(ZipEntryContent var1, IoFunction<ZipEntryContent, HashCode> var2) throws IOException;
    }

    private static class ZipEntryContent {
        final String name;
        final byte[] content;

        ZipEntryContent(String name, byte[] content) {
            this.name = name;
            this.content = content;
        }
    }
}

