/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.PropertyFileCollection;
import org.gradle.api.internal.tasks.properties.DefaultInputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;

public class GetInputFilesVisitor
implements PropertyVisitor {
    private final List<InputFilePropertySpec> specs = Lists.newArrayList();
    private final FileCollectionFactory fileCollectionFactory;
    private final String ownerDisplayName;
    private boolean hasSourceFiles;
    private ImmutableSortedSet<InputFilePropertySpec> fileProperties;

    public GetInputFilesVisitor(String ownerDisplayName, FileCollectionFactory fileCollectionFactory) {
        this.ownerDisplayName = ownerDisplayName;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public void visitInputFileProperty(String propertyName, boolean optional, InputBehavior behavior, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, @Nullable FileNormalizer fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
        FileCollectionInternal actualValue = FileParameterUtils.resolveInputFileValue(this.fileCollectionFactory, filePropertyType, value);
        FileNormalizer normalizer = FileParameterUtils.normalizerOrDefault(fileNormalizer);
        this.specs.add(new DefaultInputFilePropertySpec(propertyName, normalizer, (FileCollectionInternal)new PropertyFileCollection(this.ownerDisplayName, propertyName, "input", actualValue), value, behavior, this.normalizeDirectorySensitivity(normalizer, directorySensitivity), lineEndingSensitivity));
        if (behavior.shouldSkipWhenEmpty()) {
            this.hasSourceFiles = true;
        }
    }

    private DirectorySensitivity normalizeDirectorySensitivity(FileNormalizer normalizer, DirectorySensitivity directorySensitivity) {
        return normalizer.isIgnoringDirectories() ? DirectorySensitivity.DEFAULT : directorySensitivity;
    }

    public ImmutableSortedSet<InputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = FileParameterUtils.collectFileProperties("input", this.specs.iterator());
        }
        return this.fileProperties;
    }

    public boolean hasSourceFiles() {
        return this.hasSourceFiles;
    }
}

