/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.component.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.internal.DefaultAdhocSoftwareComponent;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;

public class DefaultJvmSoftwareComponent
extends DefaultAdhocSoftwareComponent
implements JvmSoftwareComponentInternal {
    private static final String SOURCE_ELEMENTS_VARIANT_NAME_SUFFIX = "SourceElements";
    private final Project project;
    private final JvmPluginServices jvmPluginServices;
    private final SourceSet sourceSet;
    private final Configuration implementation;
    private final Configuration runtimeOnly;
    private final Configuration compileOnly;
    private final Configuration runtimeClasspath;
    private final Configuration compileClasspath;
    private final Configuration runtimeElements;
    private final Configuration apiElements;
    private final TaskProvider<JavaCompile> compileJava;
    private final TaskProvider<Jar> jar;

    @Inject
    public DefaultJvmSoftwareComponent(String componentName, String sourceSetName, Project project, JvmPluginServices jvmPluginServices, ObjectFactory objectFactory, ProviderFactory providerFactory, Instantiator instantiator) {
        super(componentName, instantiator);
        this.project = project;
        this.jvmPluginServices = jvmPluginServices;
        TaskContainer tasks = project.getTasks();
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        PluginContainer plugins = project.getPlugins();
        ExtensionContainer extensions = project.getExtensions();
        JavaPluginExtension javaExtension = DefaultJvmSoftwareComponent.getJavaPluginExtension(extensions);
        this.sourceSet = DefaultJvmSoftwareComponent.createSourceSet(sourceSetName, javaExtension.getSourceSets());
        this.compileJava = tasks.named(this.sourceSet.getCompileJavaTaskName(), JavaCompile.class);
        this.jar = DefaultJvmSoftwareComponent.registerJarTask(tasks, this.sourceSet);
        this.implementation = configurations.getByName(this.sourceSet.getImplementationConfigurationName());
        this.compileOnly = configurations.getByName(this.sourceSet.getCompileOnlyConfigurationName());
        this.runtimeOnly = configurations.getByName(this.sourceSet.getRuntimeOnlyConfigurationName());
        this.runtimeClasspath = configurations.getByName(this.sourceSet.getRuntimeClasspathConfigurationName());
        this.compileClasspath = configurations.getByName(this.sourceSet.getCompileClasspathConfigurationName());
        PublishArtifact jarArtifact = DefaultJvmSoftwareComponent.configureArchives(project, this.jar, tasks, extensions);
        this.runtimeElements = this.createRuntimeElements(configurations, this.sourceSet, jarArtifact);
        this.apiElements = this.createApiElements(configurations, this.sourceSet, jarArtifact);
        this.createSourceElements(configurations, providerFactory, objectFactory, this.sourceSet);
        JvmPluginsHelper.configureJavaDocTask(null, this.sourceSet, tasks, javaExtension);
        DefaultJvmSoftwareComponent.configurePublishing(plugins, extensions, this.sourceSet);
        this.addVariantsFromConfiguration(this.apiElements, new JavaConfigurationVariantMapping("compile", false));
        this.addVariantsFromConfiguration(this.runtimeElements, new JavaConfigurationVariantMapping("runtime", false));
    }

    private static JavaPluginExtension getJavaPluginExtension(ExtensionContainer extensions) {
        JavaPluginExtension javaExtension = (JavaPluginExtension)extensions.findByType(JavaPluginExtension.class);
        if (javaExtension == null) {
            throw new GradleException("The java-base plugin must be applied in order to create instances of " + DefaultJvmSoftwareComponent.class.getSimpleName() + ".");
        }
        return javaExtension;
    }

    private static SourceSet createSourceSet(String name, SourceSetContainer sourceSets) {
        if (sourceSets.findByName(name) != null) {
            throw new GradleException("Cannot create multiple instances of " + DefaultJvmSoftwareComponent.class.getSimpleName() + " with source set name '" + name + "'.");
        }
        return (SourceSet)sourceSets.create(name);
    }

    private static TaskProvider<Jar> registerJarTask(TaskContainer tasks, SourceSet sourceSet) {
        return tasks.register(sourceSet.getJarTaskName(), Jar.class, jar -> {
            jar.setDescription("Assembles a jar archive containing the main classes.");
            jar.setGroup("build");
            jar.from(new Object[]{sourceSet.getOutput()});
        });
    }

    private static PublishArtifact configureArchives(Project project, TaskProvider<Jar> jarTaskProvider, TaskContainer tasks, ExtensionContainer extensions) {
        tasks.withType(Test.class).configureEach(test -> test.shouldRunAfter(new Object[]{tasks.withType(Jar.class)}));
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(jarTaskProvider, ((ProjectInternal)project).getFileResolver(), ((ProjectInternal)project).getTaskDependencyFactory());
        ((DefaultArtifactPublicationSet)extensions.getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)jarArtifact);
        return jarArtifact;
    }

    private static void addJarArtifactToConfiguration(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
    }

    private Configuration createRuntimeElements(RoleBasedConfigurationContainerInternal configurations, SourceSet sourceSet, PublishArtifact jarArtifact) {
        Configuration runtimeElementsConfiguration = configurations.maybeCreateWithRole(sourceSet.getRuntimeElementsConfigurationName(), (ConfigurationRole)ConfigurationRoles.INTENDED_CONSUMABLE, false, false);
        runtimeElementsConfiguration.setVisible(false);
        this.jvmPluginServices.useDefaultTargetPlatformInference(runtimeElementsConfiguration, this.compileJava);
        this.jvmPluginServices.configureAsRuntimeElements((HasConfigurableAttributes<?>)runtimeElementsConfiguration);
        runtimeElementsConfiguration.setDescription("Elements of runtime for main.");
        runtimeElementsConfiguration.extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
        DefaultJvmSoftwareComponent.addJarArtifactToConfiguration(runtimeElementsConfiguration, jarArtifact);
        this.jvmPluginServices.configureClassesDirectoryVariant(runtimeElementsConfiguration, sourceSet);
        this.jvmPluginServices.configureResourcesDirectoryVariant(runtimeElementsConfiguration, sourceSet);
        return runtimeElementsConfiguration;
    }

    private Configuration createApiElements(RoleBasedConfigurationContainerInternal configurations, SourceSet sourceSet, PublishArtifact jarArtifact) {
        Configuration apiElementsConfiguration = configurations.maybeCreateWithRole(sourceSet.getApiElementsConfigurationName(), (ConfigurationRole)ConfigurationRoles.INTENDED_CONSUMABLE, false, false);
        apiElementsConfiguration.setVisible(false);
        this.jvmPluginServices.useDefaultTargetPlatformInference(apiElementsConfiguration, this.compileJava);
        this.jvmPluginServices.configureAsApiElements((HasConfigurableAttributes<?>)apiElementsConfiguration);
        apiElementsConfiguration.setDescription("API elements for main.");
        DefaultJvmSoftwareComponent.addJarArtifactToConfiguration(apiElementsConfiguration, jarArtifact);
        return apiElementsConfiguration;
    }

    private Configuration createSourceElements(RoleBasedConfigurationContainerInternal configurations, ProviderFactory providerFactory, ObjectFactory objectFactory, SourceSet sourceSet) {
        String variantName = sourceSet.getName() + SOURCE_ELEMENTS_VARIANT_NAME_SUFFIX;
        Configuration variant = configurations.createWithRole(variantName, (ConfigurationRole)ConfigurationRolesForMigration.INTENDED_CONSUMABLE_BUCKET_TO_INTENDED_CONSUMABLE);
        variant.setDescription("List of source directories contained in the Main SourceSet.");
        variant.setVisible(false);
        variant.extendsFrom(new Configuration[]{this.implementation});
        variant.attributes(attributes -> {
            attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "verification")));
            attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objectFactory.named(VerificationType.class, "main-sources")));
        });
        variant.getOutgoing().artifacts(sourceSet.getAllSource().getSourceDirectories().getElements().flatMap(e -> providerFactory.provider(() -> e)), artifact -> artifact.setType("directory"));
        return variant;
    }

    private static void configurePublishing(PluginContainer plugins, ExtensionContainer extensions, SourceSet sourceSet) {
        plugins.withType(PublishingPlugin.class, plugin -> {
            PublishingExtension publishing = (PublishingExtension)extensions.getByType(PublishingExtension.class);
            publishing.getPublications().withType(IvyPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((IvyPublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", sourceSet.getCompileClasspathConfigurationName());
                strategy.defaultResolutionConfiguration("java-runtime", sourceSet.getRuntimeClasspathConfigurationName());
            });
            publishing.getPublications().withType(MavenPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((MavenPublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", sourceSet.getCompileClasspathConfigurationName());
                strategy.defaultResolutionConfiguration("java-runtime", sourceSet.getRuntimeClasspathConfigurationName());
            });
        });
    }

    @Override
    public void enableJavadocJarVariant() {
        if (this.project.getConfigurations().findByName(this.sourceSet.getJavadocElementsConfigurationName()) != null) {
            return;
        }
        Configuration javadocVariant = JvmPluginsHelper.createDocumentationVariantWithArtifact(this.sourceSet.getJavadocElementsConfigurationName(), null, "javadoc", (List<Capability>)ImmutableList.of(), this.sourceSet.getJavadocJarTaskName(), this.project.getTasks().named(this.sourceSet.getJavadocTaskName()), (ProjectInternal)this.project);
        this.addVariantsFromConfiguration(javadocVariant, new JavaConfigurationVariantMapping("runtime", true));
    }

    @Override
    public void enableSourcesJarVariant() {
        if (this.project.getConfigurations().findByName(this.sourceSet.getSourcesElementsConfigurationName()) != null) {
            return;
        }
        Configuration sourcesVariant = JvmPluginsHelper.createDocumentationVariantWithArtifact(this.sourceSet.getSourcesElementsConfigurationName(), null, "sources", (List<Capability>)ImmutableList.of(), this.sourceSet.getSourcesJarTaskName(), this.sourceSet.getAllSource(), (ProjectInternal)this.project);
        this.addVariantsFromConfiguration(sourcesVariant, new JavaConfigurationVariantMapping("runtime", true));
    }

    @Override
    public TaskProvider<Jar> getMainJarTask() {
        return this.jar;
    }

    @Override
    public TaskProvider<JavaCompile> getMainCompileJavaTask() {
        return this.compileJava;
    }

    @Override
    public SourceSetOutput getMainOutput() {
        return this.sourceSet.getOutput();
    }

    @Override
    public SourceSet getSourceSet() {
        return this.sourceSet;
    }

    @Override
    public Configuration getImplementationConfiguration() {
        return this.implementation;
    }

    @Override
    public Configuration getRuntimeOnlyConfiguration() {
        return this.runtimeOnly;
    }

    @Override
    public Configuration getCompileOnlyConfiguration() {
        return this.compileOnly;
    }

    @Override
    public Configuration getRuntimeClasspathConfiguration() {
        return this.runtimeClasspath;
    }

    @Override
    public Configuration getCompileClasspathConfiguration() {
        return this.compileClasspath;
    }

    @Override
    public Configuration getRuntimeElementsConfiguration() {
        return this.runtimeElements;
    }

    @Override
    public Configuration getApiElementsConfiguration() {
        return this.apiElements;
    }
}

