/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.AttributesToMapConverter;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.ExecutePlannedTransformStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.execution.plan.CreationOrderedNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.Describables;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationMetadata;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.taskgraph.NodeIdentity;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.gradle.operations.dependencies.transforms.ExecutePlannedTransformStepBuildOperationType;
import org.gradle.operations.dependencies.transforms.PlannedTransformStepIdentity;
import org.gradle.operations.dependencies.variants.Capability;
import org.gradle.operations.dependencies.variants.OpaqueComponentIdentifier;
import org.gradle.operations.dependencies.variants.ProjectComponentIdentifier;

public abstract class TransformationNode
extends CreationOrderedNode
implements SelfExecutingNode {
    private static final AtomicLong SEQUENCE = new AtomicLong();
    protected final TransformationStep transformationStep;
    protected final ResolvableArtifact artifact;
    private final ComponentVariantIdentifier targetComponentVariant;
    private final AttributeContainer sourceAttributes;
    protected final TransformUpstreamDependencies upstreamDependencies;
    private final long transformationNodeId;
    private PlannedTransformStepIdentity cachedIdentity;
    private static final ExecutePlannedTransformStepBuildOperationType.Result RESULT = new ExecutePlannedTransformStepBuildOperationType.Result(){};

    public static ChainedTransformationNode chained(ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep current, TransformationNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return new ChainedTransformationNode(TransformationNode.createId(), targetComponentVariant, sourceAttributes, current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public static ChainedTransformationNode chained(long transformationNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep current, TransformationNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        TransformationNode.useAssignedId(transformationNodeId);
        return new ChainedTransformationNode(transformationNodeId, targetComponentVariant, sourceAttributes, current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public static InitialTransformationNode initial(ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return new InitialTransformationNode(TransformationNode.createId(), targetComponentVariant, sourceAttributes, initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public static InitialTransformationNode initial(long transformationNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        TransformationNode.useAssignedId(transformationNodeId);
        return new InitialTransformationNode(transformationNodeId, targetComponentVariant, sourceAttributes, initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    private static long createId() {
        return SEQUENCE.incrementAndGet();
    }

    private static void useAssignedId(long assignedUniqueId) {
        SEQUENCE.getAndAccumulate(assignedUniqueId, (current, assignedId) -> current > assignedId ? current : assignedId + 1L);
    }

    protected TransformationNode(long id, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep transformationStep, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies) {
        this.targetComponentVariant = targetComponentVariant;
        this.sourceAttributes = sourceAttributes;
        this.transformationStep = transformationStep;
        this.artifact = artifact;
        this.upstreamDependencies = upstreamDependencies;
        this.transformationNodeId = id;
    }

    public long getTransformationNodeId() {
        return this.transformationNodeId;
    }

    public ComponentVariantIdentifier getTargetComponentVariant() {
        return this.targetComponentVariant;
    }

    public AttributeContainer getSourceAttributes() {
        return this.sourceAttributes;
    }

    public PlannedTransformStepIdentity getNodeIdentity() {
        if (this.cachedIdentity == null) {
            this.cachedIdentity = this.createIdentity();
        }
        return this.cachedIdentity;
    }

    private PlannedTransformStepIdentity createIdentity() {
        final String consumerBuildPath = this.transformationStep.getOwningProject().getBuildPath().toString();
        final String consumerProjectPath = this.transformationStep.getOwningProject().getProjectPath().toString();
        final org.gradle.operations.dependencies.variants.ComponentIdentifier componentId = TransformationNode.getComponentIdentifier(this.targetComponentVariant.getComponentId());
        final Map<String, String> sourceAttributes = AttributesToMapConverter.convertToMap(this.sourceAttributes);
        final Map<String, String> targetAttributes = AttributesToMapConverter.convertToMap(this.targetComponentVariant.getAttributes());
        final List capabilities = this.targetComponentVariant.getCapabilities().stream().map(TransformationNode::convertCapability).collect(Collectors.toList());
        return new PlannedTransformStepIdentity(){

            public NodeIdentity.NodeType getNodeType() {
                return NodeIdentity.NodeType.TRANSFORM_STEP;
            }

            public String getConsumerBuildPath() {
                return consumerBuildPath;
            }

            public String getConsumerProjectPath() {
                return consumerProjectPath;
            }

            public org.gradle.operations.dependencies.variants.ComponentIdentifier getComponentId() {
                return componentId;
            }

            public Map<String, String> getSourceAttributes() {
                return sourceAttributes;
            }

            public Map<String, String> getTargetAttributes() {
                return targetAttributes;
            }

            public List<? extends Capability> getCapabilities() {
                return capabilities;
            }

            public String getArtifactName() {
                return TransformationNode.this.artifact.getArtifactName().toString();
            }

            public ConfigurationIdentity getDependenciesConfigurationIdentity() {
                return TransformationNode.this.upstreamDependencies.getConfigurationIdentity();
            }

            public long getTransformStepNodeId() {
                return TransformationNode.this.transformationNodeId;
            }

            public String toString() {
                return "Transform '" + TransformationNode.this.targetComponentVariant.getComponentId() + "' with " + TransformationNode.this.transformationStep.getTransformer().getImplementationClass().getName();
            }
        };
    }

    private static Capability convertCapability(final org.gradle.api.capabilities.Capability capability) {
        return new Capability(){

            public String getGroup() {
                return capability.getGroup();
            }

            public String getName() {
                return capability.getName();
            }

            public String getVersion() {
                return capability.getVersion();
            }

            public String toString() {
                return this.getGroup() + ":" + this.getName() + (this.getVersion() == null ? "" : ":" + this.getVersion());
            }
        };
    }

    private static org.gradle.operations.dependencies.variants.ComponentIdentifier getComponentIdentifier(final ComponentIdentifier componentId) {
        if (componentId instanceof org.gradle.api.artifacts.component.ProjectComponentIdentifier) {
            final org.gradle.api.artifacts.component.ProjectComponentIdentifier projectComponentIdentifier = (org.gradle.api.artifacts.component.ProjectComponentIdentifier)componentId;
            return new ProjectComponentIdentifier(){

                public String getBuildPath() {
                    String buildName = projectComponentIdentifier.getBuild().getName();
                    return buildName.startsWith(":") ? buildName : ":" + buildName;
                }

                public String getProjectPath() {
                    return projectComponentIdentifier.getProjectPath();
                }

                public String toString() {
                    return projectComponentIdentifier.getDisplayName();
                }
            };
        }
        if (componentId instanceof ModuleComponentIdentifier) {
            final ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)componentId;
            return new org.gradle.operations.dependencies.variants.ModuleComponentIdentifier(){

                public String getGroup() {
                    return moduleComponentIdentifier.getGroup();
                }

                public String getModule() {
                    return moduleComponentIdentifier.getModule();
                }

                public String getVersion() {
                    return moduleComponentIdentifier.getVersion();
                }

                public String toString() {
                    return moduleComponentIdentifier.getDisplayName();
                }
            };
        }
        return new OpaqueComponentIdentifier(){

            public String getDisplayName() {
                return componentId.getDisplayName();
            }

            public String getClassName() {
                return componentId.getClass().getName();
            }

            public String toString() {
                return componentId.getDisplayName();
            }
        };
    }

    public ResolvableArtifact getInputArtifact() {
        return this.artifact;
    }

    public TransformUpstreamDependencies getUpstreamDependencies() {
        return this.upstreamDependencies;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return this.transformationStep.getOwningProject();
    }

    public boolean isPublicNode() {
        return true;
    }

    public String toString() {
        return this.transformationStep.getDisplayName();
    }

    public TransformationStep getTransformationStep() {
        return this.transformationStep;
    }

    public Try<TransformationSubject> getTransformedSubject() {
        return this.getTransformedArtifacts().getValue();
    }

    public void execute(NodeExecutionContext context) {
        this.getTransformedArtifacts().run(context);
    }

    public void executeIfNotAlready() {
        this.transformationStep.isolateParametersIfNotAlready();
        this.upstreamDependencies.finalizeIfNotAlready();
        this.getTransformedArtifacts().finalizeIfNotAlready();
    }

    protected abstract CalculatedValueContainer<TransformationSubject, ?> getTransformedArtifacts();

    public Throwable getNodeFailure() {
        return null;
    }

    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        this.processDependencies(dependencyResolver.resolveDependenciesFor(null, context -> this.getTransformedArtifacts().visitDependencies(context)));
    }

    protected void processDependencies(Set<Node> dependencies) {
        for (Node dependency : dependencies) {
            this.addDependencySuccessor(dependency);
        }
    }

    private abstract class ArtifactTransformationStepBuildOperation
    implements CallableBuildOperation<TransformationSubject> {
        private static final String TRANSFORMING_PROGRESS_PREFIX = "Transforming ";

        private ArtifactTransformationStepBuildOperation() {
        }

        public final BuildOperationDescriptor.Builder description() {
            String transformerName = TransformationNode.this.transformationStep.getDisplayName();
            String subjectName = this.describeSubject();
            String basicName = subjectName + " with " + transformerName;
            return BuildOperationDescriptor.displayName((String)("Transform " + basicName)).progressDisplayName(TRANSFORMING_PROGRESS_PREFIX + basicName).metadata((BuildOperationMetadata)BuildOperationCategory.TRANSFORM).details((Object)new ExecutePlannedTransformStepBuildOperationDetails(TransformationNode.this, transformerName, subjectName));
        }

        protected abstract String describeSubject();

        public TransformationSubject call(BuildOperationContext context) {
            context.setResult((Object)RESULT);
            return this.transform();
        }

        protected abstract TransformationSubject transform();
    }

    public static class ChainedTransformationNode
    extends TransformationNode {
        private final TransformationNode previousTransformationNode;
        private final CalculatedValueContainer<TransformationSubject, TransformPreviousArtifacts> result;

        public ChainedTransformationNode(long id, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep transformationStep, TransformationNode previousTransformationNode, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(id, targetComponentVariant, sourceAttributes, transformationStep, previousTransformationNode.artifact, upstreamDependencies);
            this.previousTransformationNode = previousTransformationNode;
            this.result = calculatedValueContainerFactory.create(Describables.of((Object)((Object)this)), (ValueCalculator)new TransformPreviousArtifacts(buildOperationExecutor));
        }

        public TransformationNode getPreviousTransformationNode() {
            return this.previousTransformationNode;
        }

        protected CalculatedValueContainer<TransformationSubject, TransformPreviousArtifacts> getTransformedArtifacts() {
            return this.result;
        }

        @Override
        public void executeIfNotAlready() {
            this.previousTransformationNode.executeIfNotAlready();
            super.executeIfNotAlready();
        }

        private class TransformPreviousArtifacts
        implements ValueCalculator<TransformationSubject> {
            private final BuildOperationExecutor buildOperationExecutor;

            public TransformPreviousArtifacts(BuildOperationExecutor buildOperationExecutor) {
                this.buildOperationExecutor = buildOperationExecutor;
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add((Object)ChainedTransformationNode.this.transformationStep);
                context.add((Object)ChainedTransformationNode.this.upstreamDependencies);
                context.add((Object)new DefaultTransformationDependency(Collections.singletonList(ChainedTransformationNode.this.previousTransformationNode)));
            }

            public TransformationSubject calculateValue(final NodeExecutionContext context) {
                return (TransformationSubject)this.buildOperationExecutor.call((CallableBuildOperation)new ArtifactTransformationStepBuildOperation(){

                    @Override
                    protected TransformationSubject transform() {
                        return (TransformationSubject)ChainedTransformationNode.this.previousTransformationNode.getTransformedSubject().flatMap(transformedSubject -> (Try)ChainedTransformationNode.this.transformationStep.createInvocation((TransformationSubject)transformedSubject, ChainedTransformationNode.this.upstreamDependencies, context).completeAndGet()).get();
                    }

                    @Override
                    protected String describeSubject() {
                        return (String)ChainedTransformationNode.this.previousTransformationNode.getTransformedSubject().map(Describable::getDisplayName).getOrMapFailure(Throwable::getMessage);
                    }
                });
            }
        }
    }

    public static class InitialTransformationNode
    extends TransformationNode {
        private final CalculatedValueContainer<TransformationSubject, TransformInitialArtifact> result;

        public InitialTransformationNode(long id, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformationStep transformationStep, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(id, targetComponentVariant, sourceAttributes, transformationStep, artifact, upstreamDependencies);
            this.result = calculatedValueContainerFactory.create(Describables.of((Object)((Object)this)), (ValueCalculator)new TransformInitialArtifact(buildOperationExecutor));
        }

        protected CalculatedValueContainer<TransformationSubject, TransformInitialArtifact> getTransformedArtifacts() {
            return this.result;
        }

        private class TransformInitialArtifact
        implements ValueCalculator<TransformationSubject> {
            private final BuildOperationExecutor buildOperationExecutor;

            public TransformInitialArtifact(BuildOperationExecutor buildOperationExecutor) {
                this.buildOperationExecutor = buildOperationExecutor;
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add((Object)InitialTransformationNode.this.transformationStep);
                context.add((Object)InitialTransformationNode.this.upstreamDependencies);
                context.add((Object)InitialTransformationNode.this.artifact);
            }

            public TransformationSubject calculateValue(final NodeExecutionContext context) {
                return (TransformationSubject)this.buildOperationExecutor.call((CallableBuildOperation)new ArtifactTransformationStepBuildOperation(){

                    @Override
                    protected TransformationSubject transform() {
                        TransformationSubject initialArtifactTransformationSubject;
                        try {
                            initialArtifactTransformationSubject = TransformationSubject.initial(InitialTransformationNode.this.artifact);
                        }
                        catch (ResolveException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            throw new DefaultLenientConfiguration.ArtifactResolveException("artifacts", InitialTransformationNode.this.transformationStep.getDisplayName(), "artifact transform", Collections.singleton(e));
                        }
                        return (TransformationSubject)((Try)InitialTransformationNode.this.transformationStep.createInvocation(initialArtifactTransformationSubject, InitialTransformationNode.this.upstreamDependencies, context).completeAndGet()).get();
                    }

                    @Override
                    protected String describeSubject() {
                        return InitialTransformationNode.this.artifact.getId().getDisplayName();
                    }
                });
            }
        }
    }
}

