/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.kotlin.dsl.support.KotlinCompilerKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gradle/kotlin/dsl/support/LoggingMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "log", "Lorg/slf4j/Logger;", "pathTranslation", "Lkotlin/Function1;", "", "(Lorg/slf4j/Logger;Lkotlin/jvm/functions/Function1;)V", "errors", "Ljava/util/ArrayList;", "Lorg/gradle/kotlin/dsl/support/ScriptCompilationError;", "Lkotlin/collections/ArrayList;", "getErrors", "()Ljava/util/ArrayList;", "getLog$kotlin_dsl", "()Lorg/slf4j/Logger;", "clear", "", "hasErrors", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nKotlinCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompiler.kt\norg/gradle/kotlin/dsl/support/LoggingMessageCollector\n+ 2 Logger.kt\norg/gradle/kotlin/dsl/support/LoggerKt\n*L\n1#1,582:1\n54#2,2:583\n30#2,2:585\n48#2,2:587\n48#2,2:589\n42#2,2:591\n36#2,2:593\n*S KotlinDebug\n*F\n+ 1 KotlinCompiler.kt\norg/gradle/kotlin/dsl/support/LoggingMessageCollector\n*L\n561#1:583,2\n564#1:585,2\n565#1:587,2\n566#1:589,2\n567#1:591,2\n568#1:593,2\n*E\n"})
public final class LoggingMessageCollector
implements MessageCollector {
    @NotNull
    private final Logger log;
    @NotNull
    private final Function1<String, String> pathTranslation;
    @NotNull
    private final ArrayList<ScriptCompilationError> errors;

    public LoggingMessageCollector(@NotNull Logger log, @NotNull Function1<? super String, String> pathTranslation) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(pathTranslation, (String)"pathTranslation");
        this.log = log;
        this.pathTranslation = pathTranslation;
        this.errors = new ArrayList();
    }

    @NotNull
    public final Logger getLog$kotlin_dsl() {
        return this.log;
    }

    @NotNull
    public final ArrayList<ScriptCompilationError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    public void clear() {
        this.errors.clear();
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CompilerMessageSeverity compilerMessageSeverity = severity;
        if (compilerMessageSeverity == CompilerMessageSeverity.ERROR ? true : compilerMessageSeverity == CompilerMessageSeverity.EXCEPTION) {
            ((Collection)this.errors).add(new ScriptCompilationError(message, location));
            Logger $this$error$iv = this.log;
            boolean $i$f$error = false;
            if ($this$error$iv.isErrorEnabled()) {
                Logger logger2 = $this$error$iv;
                boolean bl = false;
                logger2.error(LoggingMessageCollector.report$taggedMsg(severity, location, message, this));
            }
        } else if (CompilerMessageSeverity.VERBOSE.contains(compilerMessageSeverity)) {
            Logger $this$trace$iv = this.log;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger3 = $this$trace$iv;
                boolean bl = false;
                logger3.trace(LoggingMessageCollector.report$msg(location, message, this));
            }
        } else if (compilerMessageSeverity == CompilerMessageSeverity.STRONG_WARNING) {
            Logger $this$warn$iv = this.log;
            boolean $i$f$warn = false;
            if ($this$warn$iv.isWarnEnabled()) {
                Logger logger4 = $this$warn$iv;
                boolean bl = false;
                logger4.warn(LoggingMessageCollector.report$taggedMsg(severity, location, message, this));
            }
        } else if (compilerMessageSeverity == CompilerMessageSeverity.WARNING) {
            Logger $this$warn$iv = this.log;
            boolean $i$f$warn = false;
            if ($this$warn$iv.isWarnEnabled()) {
                Logger logger5 = $this$warn$iv;
                boolean bl = false;
                logger5.warn(LoggingMessageCollector.report$taggedMsg(severity, location, message, this));
            }
        } else if (compilerMessageSeverity == CompilerMessageSeverity.INFO) {
            Logger $this$info$iv = this.log;
            boolean $i$f$info = false;
            if ($this$info$iv.isInfoEnabled()) {
                Logger logger6 = $this$info$iv;
                boolean bl = false;
                logger6.info(LoggingMessageCollector.report$msg(location, message, this));
            }
        } else {
            Logger $this$debug$iv = this.log;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger7 = $this$debug$iv;
                boolean bl = false;
                logger7.debug(LoggingMessageCollector.report$taggedMsg(severity, location, message, this));
            }
        }
    }

    private static final String report$msg(CompilerMessageSourceLocation $location, String $message, LoggingMessageCollector this$0) {
        Object object;
        block4: {
            block3: {
                object = $location;
                if (object == null) break block3;
                CompilerMessageSourceLocation $this$report_u24msg_u24lambda_u241 = object;
                boolean bl = false;
                String string2 = $this$report_u24msg_u24lambda_u241.getPath();
                String path2 = (String)this$0.pathTranslation.invoke((Object)string2);
                boolean bl2 = false;
                String string3 = $this$report_u24msg_u24lambda_u241.getLine() >= 0 && $this$report_u24msg_u24lambda_u241.getColumn() >= 0 ? KotlinCompilerKt.compilerMessageFor(path2, $this$report_u24msg_u24lambda_u241.getLine(), $this$report_u24msg_u24lambda_u241.getColumn(), $message) : KotlinCompilerKt.access$clickableFileUrlFor(path2) + ": " + $message;
                object = string3;
                if (string3 != null) break block4;
            }
            object = $message;
        }
        return object;
    }

    private static final String report$taggedMsg(CompilerMessageSeverity $severity, CompilerMessageSourceLocation $location, String $message, LoggingMessageCollector this$0) {
        return $severity.getPresentableName().charAt(0) + ": " + LoggingMessageCollector.report$msg($location, $message, this$0);
    }
}

