/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.ToPlannedNodeConverter;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.service.scopes.ToPlannedNodeConverterRegistry;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.internal.taskgraph.NodeIdentity;

public class BuildOperationFiringBuildWorkPreparer
implements BuildWorkPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildWorkPreparer delegate;
    private final ToPlannedNodeConverterRegistry converterRegistry;

    public BuildOperationFiringBuildWorkPreparer(BuildOperationExecutor buildOperationExecutor, BuildWorkPreparer delegate, ToPlannedNodeConverterRegistry converterRegistry) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
        this.converterRegistry = converterRegistry;
    }

    @Override
    public ExecutionPlan newExecutionPlan() {
        return this.delegate.newExecutionPlan();
    }

    @Override
    public void populateWorkGraph(GradleInternal gradle, ExecutionPlan plan, Consumer<? super ExecutionPlan> action) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new PopulateWorkGraph(this.delegate, gradle, plan, action, this.converterRegistry));
    }

    @Override
    public FinalizedExecutionPlan finalizeWorkGraph(GradleInternal gradle, ExecutionPlan plan) {
        return this.delegate.finalizeWorkGraph(gradle, plan);
    }

    private static List<String> toSortedTaskPaths(Set<Task> tasks) {
        return tasks.stream().map(Task::getPath).distinct().sorted().collect(Collectors.toList());
    }

    private static class NodeDependencyLookup
    implements ToPlannedNodeConverter.DependencyLookup {
        private final ToPlannedNodeConverterRegistry converterRegistry;

        private NodeDependencyLookup(ToPlannedNodeConverterRegistry converterRegistry) {
            this.converterRegistry = converterRegistry;
        }

        @Override
        public List<? extends NodeIdentity> findNodeDependencies(Node node) {
            return this.findDependencies(node, Node::getDependencySuccessors, it -> true).collect(Collectors.toList());
        }

        @Override
        public List<? extends CalculateTaskGraphBuildOperationType.TaskIdentity> findTaskDependencies(Node node) {
            return this.findDependencies(node, Node::getDependencySuccessors, it -> it instanceof CalculateTaskGraphBuildOperationType.TaskIdentity).map(CalculateTaskGraphBuildOperationType.TaskIdentity.class::cast).collect(Collectors.toList());
        }

        private Stream<? extends NodeIdentity> findDependencies(Node node, Function<? super Node, ? extends Collection<Node>> traverser, Predicate<NodeIdentity> isDependencyNode) {
            return this.findIdentifiedNodes(node, traverser, isDependencyNode, Collections.newSetFromMap(new IdentityHashMap()));
        }

        private Stream<NodeIdentity> findIdentifiedNodes(Node curNode, Function<? super Node, ? extends Collection<Node>> traverser, Predicate<NodeIdentity> isDependencyNode, Set<Node> seen) {
            Collection<Node> nodes = traverser.apply(curNode);
            if (nodes.isEmpty()) {
                return Stream.empty();
            }
            return nodes.stream().filter(seen::add).flatMap(node -> {
                NodeIdentity nodeIdentity = this.identifyAsDependencyNode((Node)node, isDependencyNode);
                return nodeIdentity != null ? Stream.of(nodeIdentity) : this.findIdentifiedNodes((Node)node, traverser, isDependencyNode, seen);
            });
        }

        private NodeIdentity identifyAsDependencyNode(Node node, Predicate<NodeIdentity> isDependencyNode) {
            ToPlannedNodeConverter converter = this.converterRegistry.getConverter(node);
            if (converter == null) {
                return null;
            }
            NodeIdentity nodeIdentity = converter.getNodeIdentity(node);
            return isDependencyNode.test(nodeIdentity) ? nodeIdentity : null;
        }
    }

    private static class PopulateWorkGraph
    implements RunnableBuildOperation {
        private final BuildWorkPreparer delegate;
        private final GradleInternal gradle;
        private final ExecutionPlan plan;
        private final Consumer<? super ExecutionPlan> action;
        private final ToPlannedNodeConverterRegistry converterRegistry;
        private final NodeDependencyLookup dependencyLookup;

        public PopulateWorkGraph(BuildWorkPreparer delegate, GradleInternal gradle, ExecutionPlan plan, Consumer<? super ExecutionPlan> action, ToPlannedNodeConverterRegistry converterRegistry) {
            this.delegate = delegate;
            this.gradle = gradle;
            this.plan = plan;
            this.action = action;
            this.converterRegistry = converterRegistry;
            this.dependencyLookup = new NodeDependencyLookup(converterRegistry);
        }

        public void run(BuildOperationContext buildOperationContext) {
            this.populateTaskGraph();
            QueryableExecutionPlan contents = this.plan.getContents();
            Set<Task> requestedTasks = contents.getRequestedTasks();
            Set<Task> filteredTasks = contents.getFilteredTasks();
            QueryableExecutionPlan.ScheduledNodes scheduledWork = contents.getScheduledNodes();
            List<CalculateTaskGraphBuildOperationType.PlannedNode> plannedNodes = this.toPlannedNodes(scheduledWork);
            buildOperationContext.setResult((Object)new CalculateTaskGraphResult(requestedTasks, filteredTasks, plannedNodes));
        }

        void populateTaskGraph() {
            this.delegate.populateWorkGraph(this.gradle, this.plan, this.action);
        }

        @Nonnull
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Calculate task graph")).details((Object)new CalculateTaskGraphBuildOperationType.Details(){

                public String getBuildPath() {
                    return gradle.getIdentityPath().getPath();
                }
            });
        }

        private List<CalculateTaskGraphBuildOperationType.PlannedNode> toPlannedNodes(QueryableExecutionPlan.ScheduledNodes scheduledWork) {
            ArrayList<CalculateTaskGraphBuildOperationType.PlannedNode> plannedNodes = new ArrayList<CalculateTaskGraphBuildOperationType.PlannedNode>();
            scheduledWork.visitNodes(nodes -> {
                for (Node node : nodes) {
                    ToPlannedNodeConverter converter = this.converterRegistry.getConverter(node);
                    if (converter == null || !converter.isInSamePlan(node)) continue;
                    CalculateTaskGraphBuildOperationType.PlannedNode plannedNode = converter.convert(node, this.dependencyLookup);
                    plannedNodes.add(plannedNode);
                }
            });
            return plannedNodes;
        }

        private static class CalculateTaskGraphResult
        implements CalculateTaskGraphBuildOperationType.Result,
        CustomOperationTraceSerialization {
            private static final Set<NodeIdentity.NodeType> TASKS_ONLY = EnumSet.of(NodeIdentity.NodeType.TASK);
            private static final Set<NodeIdentity.NodeType> TASKS_AND_TRANSFORMS = EnumSet.of(NodeIdentity.NodeType.TASK, NodeIdentity.NodeType.TRANSFORM_STEP);
            private final Set<Task> requestedTasks;
            private final Set<Task> filteredTasks;
            private final List<CalculateTaskGraphBuildOperationType.PlannedNode> plannedNodes;

            public CalculateTaskGraphResult(Set<Task> requestedTasks, Set<Task> filteredTasks, List<CalculateTaskGraphBuildOperationType.PlannedNode> plannedNodes) {
                this.requestedTasks = requestedTasks;
                this.filteredTasks = filteredTasks;
                this.plannedNodes = plannedNodes;
            }

            public List<String> getRequestedTaskPaths() {
                return BuildOperationFiringBuildWorkPreparer.toSortedTaskPaths(this.requestedTasks);
            }

            public List<String> getExcludedTaskPaths() {
                return BuildOperationFiringBuildWorkPreparer.toSortedTaskPaths(this.filteredTasks);
            }

            public List<CalculateTaskGraphBuildOperationType.PlannedTask> getTaskPlan() {
                return this.plannedNodes.stream().filter(CalculateTaskGraphBuildOperationType.PlannedTask.class::isInstance).map(CalculateTaskGraphBuildOperationType.PlannedTask.class::cast).collect(Collectors.toList());
            }

            public List<CalculateTaskGraphBuildOperationType.PlannedNode> getExecutionPlan(Set<NodeIdentity.NodeType> types) {
                if (types.isEmpty()) {
                    return Collections.emptyList();
                }
                if (TASKS_ONLY.equals(types)) {
                    return this.getTaskExecutionPlan();
                }
                if (TASKS_AND_TRANSFORMS.equals(types)) {
                    return this.plannedNodes;
                }
                throw new IllegalArgumentException("Unsupported node types: " + types);
            }

            @Override
            public Object getCustomOperationTraceSerializableModel() {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)"requestedTaskPaths", this.getRequestedTaskPaths());
                builder.put((Object)"excludedTaskPaths", this.getExcludedTaskPaths());
                builder.put((Object)"taskPlan", this.getTaskPlan());
                builder.put((Object)"executionPlan", this.getExecutionPlan(EnumSet.allOf(NodeIdentity.NodeType.class)));
                return builder.build();
            }

            private List<CalculateTaskGraphBuildOperationType.PlannedNode> getTaskExecutionPlan() {
                return this.plannedNodes.stream().filter(CalculateTaskGraphBuildOperationType.PlannedTask.class::isInstance).map(n -> CalculateTaskGraphResult.filterOnlyTaskDependencies((CalculateTaskGraphBuildOperationType.PlannedTask)n)).collect(Collectors.toList());
            }

            private static CalculateTaskGraphBuildOperationType.PlannedTask filterOnlyTaskDependencies(final CalculateTaskGraphBuildOperationType.PlannedTask plannedTask) {
                return new CalculateTaskGraphBuildOperationType.PlannedTask(){

                    public NodeIdentity getNodeIdentity() {
                        return plannedTask.getNodeIdentity();
                    }

                    public List<? extends NodeIdentity> getNodeDependencies() {
                        return plannedTask.getDependencies();
                    }

                    public CalculateTaskGraphBuildOperationType.TaskIdentity getTask() {
                        return plannedTask.getTask();
                    }

                    public List<CalculateTaskGraphBuildOperationType.TaskIdentity> getDependencies() {
                        return plannedTask.getDependencies();
                    }

                    public List<CalculateTaskGraphBuildOperationType.TaskIdentity> getMustRunAfter() {
                        return plannedTask.getMustRunAfter();
                    }

                    public List<CalculateTaskGraphBuildOperationType.TaskIdentity> getShouldRunAfter() {
                        return plannedTask.getShouldRunAfter();
                    }

                    public List<CalculateTaskGraphBuildOperationType.TaskIdentity> getFinalizedBy() {
                        return plannedTask.getFinalizedBy();
                    }
                };
            }
        }
    }
}

