/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.declarations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.FileUtils;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.instrumentation.api.annotations.CallableKind;
import org.gradle.internal.instrumentation.api.annotations.InterceptCalls;
import org.gradle.internal.instrumentation.api.annotations.ParameterKind;
import org.gradle.internal.instrumentation.api.annotations.SpecificGroovyCallInterceptors;
import org.gradle.internal.instrumentation.api.annotations.SpecificJvmCallInterceptors;

@SpecificJvmCallInterceptors(generatedClassName="org.gradle.internal.classpath.InterceptorDeclaration_JvmBytecodeImpl")
@SpecificGroovyCallInterceptors(generatedClassName="org.gradle.internal.classpath.InterceptorDeclaration_GroovyInterceptorsImpl")
public class NioFileInterceptors {
    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static boolean intercept_isRegularFile(Path path, @ParameterKind.VarargParameter LinkOption[] options, @ParameterKind.CallerClassName String consumer) {
        FileUtils.tryReportFileSystemEntryObserved(path, consumer);
        return Files.isRegularFile(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static boolean intercept_isDirectory(Path path, @ParameterKind.VarargParameter LinkOption[] options, @ParameterKind.CallerClassName String consumer) {
        FileUtils.tryReportFileSystemEntryObserved(path, consumer);
        return Files.isDirectory(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static boolean intercept_exists(Path path, @ParameterKind.VarargParameter LinkOption[] options, @ParameterKind.CallerClassName String consumer) {
        FileUtils.tryReportFileSystemEntryObserved(path, consumer);
        return Files.exists(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static boolean intercept_notExists(Path path, @ParameterKind.VarargParameter LinkOption[] options, @ParameterKind.CallerClassName String consumer) {
        FileUtils.tryReportFileSystemEntryObserved(path, consumer);
        return Files.notExists(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static SeekableByteChannel intercept_newByteChannel(Path path, @ParameterKind.VarargParameter OpenOption[] options, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return Files.newByteChannel(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static SeekableByteChannel intercept_newByteChannel(Path path, Set<?> options, @ParameterKind.VarargParameter FileAttribute<?>[] attrs, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return Files.newByteChannel(path, (Set)Cast.uncheckedNonnullCast(options), attrs);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static BufferedReader intercept_newBufferedReader(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.newBufferedReader(path);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static BufferedReader intercept_newBufferedReader(Path path, Charset charset, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.newBufferedReader(path, charset);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static InputStream intercept_newInputStream(Path path, @ParameterKind.VarargParameter OpenOption[] options, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return Files.newInputStream(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static String intercept_readString(Path path, @ParameterKind.CallerClassName String consumer) throws Throwable {
        return Instrumented.filesReadString(path, consumer);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static String intercept_readString(Path path, Charset charset, @ParameterKind.CallerClassName String consumer) throws Throwable {
        return Instrumented.filesReadString(path, charset, consumer);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static byte[] intercept_readAllBytes(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.readAllBytes(path);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static List<String> intercept_readAllLines(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.readAllLines(path);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static List<String> intercept_readAllLines(Path path, Charset charset, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.readAllLines(path, charset);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static Stream<String> intercept_lines(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.lines(path);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static Stream<String> intercept_lines(Path path, Charset charset, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.lines(path, charset);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static DirectoryStream<Path> intercept_newDirectoryStream(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportDirectoryContentObserved(path, consumer);
        return Files.newDirectoryStream(path);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static DirectoryStream<Path> intercept_newDirectoryStream(Path path, String glob, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportDirectoryContentObserved(path, consumer);
        return Files.newDirectoryStream(path, glob);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static DirectoryStream<Path> intercept_newDirectoryStream(Path path, DirectoryStream.Filter<?> filter, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportDirectoryContentObserved(path, consumer);
        return Files.newDirectoryStream(path, (DirectoryStream.Filter)Cast.uncheckedNonnullCast(filter));
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static Stream<Path> intercept_list(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportDirectoryContentObserved(path, consumer);
        return Files.list(path);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=Files.class)
    public static String intercept_probeContentType(Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return Files.probeContentType(path);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static String intercept_probeContentType(@ParameterKind.Receiver FileTypeDetector self, Path path, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportFileOpened(path, consumer);
        return self.probeContentType(path);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static SeekableByteChannel intercept_newByteChannel(@ParameterKind.Receiver FileSystemProvider self, Path path, Set<?> options, @ParameterKind.VarargParameter FileAttribute<?>[] attrs, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return self.newByteChannel(path, (Set)Cast.uncheckedCast(options), attrs);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static InputStream intercept_newInputStream(@ParameterKind.Receiver FileSystemProvider self, Path path, @ParameterKind.VarargParameter OpenOption[] options, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return self.newInputStream(path, options);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static DirectoryStream<Path> intercept_newDirectoryStream(@ParameterKind.Receiver FileSystemProvider self, Path path, DirectoryStream.Filter<?> filter, @ParameterKind.CallerClassName String consumer) throws IOException {
        FileUtils.tryReportDirectoryContentObserved(path, consumer);
        return self.newDirectoryStream(path, (DirectoryStream.Filter)Cast.uncheckedCast(filter));
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FileChannel.class)
    public static FileChannel intercept_open(Path path, @ParameterKind.VarargParameter OpenOption[] options, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return FileChannel.open(path, options);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FileChannel.class)
    public static FileChannel intercept_open(Path path, Set<?> options, @ParameterKind.VarargParameter FileAttribute<?>[] attrs, @ParameterKind.CallerClassName String consumer) throws IOException {
        if (FileUtils.optionsAllowReading(options)) {
            FileUtils.tryReportFileOpened(path, consumer);
        }
        return FileChannel.open(path, (Set)Cast.uncheckedCast(options), attrs);
    }
}

