/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultScriptHandler
implements ScriptHandler,
ScriptHandlerInternal,
DynamicObjectAware {
    public static final String DISABLE_RESET_CONFIGURATION_SYSTEM_PROPERTY = "org.gradle.incubating.reset-buildscript-classpath.disabled";
    private static final Logger LOGGER = Logging.getLogger(DefaultScriptHandler.class);
    private final ResourceLocation scriptResource;
    private final ClassLoaderScope classLoaderScope;
    private final ScriptClassPathResolver scriptClassPathResolver;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final DependencyLockingHandler dependencyLockingHandler;
    private ClassPath resolvedClasspath;
    private RepositoryHandler repositoryHandler;
    private DependencyHandler dependencyHandler;
    private RoleBasedConfigurationContainerInternal configContainer;
    private Configuration classpathConfiguration;
    private DynamicObject dynamicObject;

    public DefaultScriptHandler(ScriptSource scriptSource, DependencyResolutionServices dependencyResolutionServices, ClassLoaderScope classLoaderScope, ScriptClassPathResolver scriptClassPathResolver) {
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.scriptResource = scriptSource.getResource().getLocation();
        this.classLoaderScope = classLoaderScope;
        this.scriptClassPathResolver = scriptClassPathResolver;
        this.dependencyLockingHandler = dependencyResolutionServices.getDependencyLockingHandler();
        JavaEcosystemSupport.configureSchema(dependencyResolutionServices.getAttributesSchema(), dependencyResolutionServices.getObjectFactory());
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencies());
    }

    @Override
    public void addScriptClassPathDependency(Object notation) {
        this.getDependencies().add("classpath", notation);
    }

    @Override
    public ClassPath getScriptClassPath() {
        return ClasspathUtil.getClasspath((ClassLoader)this.getClassLoader());
    }

    @Override
    public ClassPath getInstrumentedScriptClassPath() {
        if (this.resolvedClasspath == null) {
            this.resolvedClasspath = this.scriptClassPathResolver.resolveClassPath(this.classpathConfiguration);
            if (!System.getProperty(DISABLE_RESET_CONFIGURATION_SYSTEM_PROPERTY, "false").equals("true") && this.classpathConfiguration != null) {
                ((ResettableConfiguration)this.classpathConfiguration).resetResolutionState();
            }
        }
        return this.resolvedClasspath;
    }

    public DependencyHandler getDependencies() {
        this.defineConfiguration();
        return this.dependencyHandler;
    }

    public RepositoryHandler getRepositories() {
        if (this.repositoryHandler == null) {
            this.repositoryHandler = this.dependencyResolutionServices.getResolveRepositoryHandler();
        }
        return this.repositoryHandler;
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRepositories());
    }

    public ConfigurationContainer getConfigurations() {
        this.defineConfiguration();
        return this.configContainer;
    }

    private void defineConfiguration() {
        if (this.configContainer == null) {
            this.configContainer = (RoleBasedConfigurationContainerInternal)this.dependencyResolutionServices.getConfigurationContainer();
        }
        if (this.dependencyHandler == null) {
            this.dependencyHandler = this.dependencyResolutionServices.getDependencyHandler();
        }
        if (this.classpathConfiguration == null) {
            this.classpathConfiguration = this.configContainer.createWithRole("classpath", ConfigurationRolesForMigration.LEGACY_TO_INTENDED_RESOLVABLE_BUCKET);
            this.scriptClassPathResolver.prepareClassPath(this.classpathConfiguration, this.dependencyHandler);
        }
    }

    public void dependencyLocking(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencyLocking());
    }

    public DependencyLockingHandler getDependencyLocking() {
        return this.dependencyLockingHandler;
    }

    public File getSourceFile() {
        return this.scriptResource.getFile();
    }

    public URI getSourceURI() {
        return this.scriptResource.getURI();
    }

    public ClassLoader getClassLoader() {
        if (!this.classLoaderScope.isLocked()) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", (Object)this.scriptResource.getDisplayName());
        }
        return this.classLoaderScope.getLocalClassLoader();
    }

    public DynamicObject getAsDynamicObject() {
        if (this.dynamicObject == null) {
            this.dynamicObject = new BeanDynamicObject((Object)this);
        }
        return this.dynamicObject;
    }
}

