/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.configurationcache.InputTrackingState;
import org.gradle.configurationcache.initialization.ConfigurationCacheProblemsListener;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemFactory;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.configurationcache.serialization.Workarounds;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.execution.WorkExecutionTracker;
import org.gradle.internal.service.scopes.ListenerService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ListenerService
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010$\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010 H\u0016J\u001a\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010\u0019H\u0016J\"\u0010)\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010 H\u0016J\"\u0010*\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010 H\u0016J\"\u0010+\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010 H\u0002J\u0018\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gradle/configurationcache/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "problemFactory", "Lorg/gradle/configurationcache/problems/ProblemFactory;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "workExecutionTracker", "Lorg/gradle/internal/execution/WorkExecutionTracker;", "featureFlags", "Lorg/gradle/internal/buildoption/FeatureFlags;", "inputTrackingState", "Lorg/gradle/configurationcache/InputTrackingState;", "(Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configurationcache/problems/ProblemFactory;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/execution/WorkExecutionTracker;Lorg/gradle/internal/buildoption/FeatureFlags;Lorg/gradle/configurationcache/InputTrackingState;)V", "atConfigurationTime", "", "isBuildSrcBuild", "invocationSource", "", "isExecutingWork", "isInputTrackingDisabled", "listenerRegistrationProblem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "invocationDescription", "", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "locationForTask", "Lorg/gradle/configurationcache/problems/PropertyTrace;", "location", "task", "Lorg/gradle/api/internal/TaskInternal;", "onBuildScopeListenerRegistration", "", "listener", "onConventionAccess", "runningTask", "onExternalProcessStarted", "command", "consumer", "onProjectAccess", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "onUnsafeCredentials", "locationSpecificReason", "problemsListenerFor", "configuration-cache"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener {
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final ProblemFactory problemFactory;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final WorkExecutionTracker workExecutionTracker;
    @NotNull
    private final FeatureFlags featureFlags;
    @NotNull
    private final InputTrackingState inputTrackingState;

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems, @NotNull ProblemFactory problemFactory, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull WorkExecutionTracker workExecutionTracker, @NotNull FeatureFlags featureFlags, @NotNull InputTrackingState inputTrackingState) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)problemFactory, (String)"problemFactory");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)workExecutionTracker, (String)"workExecutionTracker");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter((Object)inputTrackingState, (String)"inputTrackingState");
        this.problems = problems;
        this.problemFactory = problemFactory;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.workExecutionTracker = workExecutionTracker;
        this.featureFlags = featureFlags;
        this.inputTrackingState = inputTrackingState;
    }

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onConventionAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string2 = task.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.javaClass.name");
        if (Workarounds.INSTANCE.canAccessConventions(string2, invocationDescription)) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onExternalProcessStarted(@NotNull String command, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.atConfigurationTime() || this.isExecutingWork() || this.isInputTrackingDisabled()) {
            return;
        }
        this.problems.onProblem(new PropertyProblem(this.problemFactory.locationForCaller(consumer), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(command){
            final /* synthetic */ String $command;
            {
                this.$command = $command;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("external process started ");
                $this$build.reference(this.$command);
            }
        })), (Throwable)new InvalidUserCodeException("Starting an external process '" + command + "' during configuration time is unsupported."), DocumentationSection.RequirementsExternalProcess));
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task, TaskInternal runningTask) {
        TaskInternal contextTask;
        TaskInternal taskInternal = runningTask;
        if (taskInternal == null) {
            taskInternal = task;
        }
        boolean isExecutingOtherTask = !Intrinsics.areEqual((Object)(contextTask = taskInternal), (Object)task);
        this.problemsListenerFor(contextTask).onProblem(this.problemFactory.problem((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(isExecutingOtherTask, contextTask, invocationDescription){
            final /* synthetic */ boolean $isExecutingOtherTask;
            final /* synthetic */ TaskInternal $contextTask;
            final /* synthetic */ String $invocationDescription;
            {
                this.$isExecutingOtherTask = $isExecutingOtherTask;
                this.$contextTask = $contextTask;
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                if (this.$isExecutingOtherTask) {
                    $this$problem.text("execution of task ");
                    String string2 = this.$contextTask.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contextTask.path");
                    $this$problem.reference(string2);
                    $this$problem.text(" caused invocation of ");
                    $this$problem.reference(this.$invocationDescription);
                    $this$problem.text(" in other task at execution time which is unsupported.");
                } else {
                    $this$problem.text("invocation of ");
                    $this$problem.reference(this.$invocationDescription);
                    $this$problem.text(" at execution time is unsupported.");
                }
            }
        })).exception(isExecutingOtherTask ? "Execution of " + runningTask + " caused invocation of '" + invocationDescription + "' by " + task + " at execution time which is unsupported." : "Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported.").documentationSection(DocumentationSection.RequirementsUseProjectDuringExecution).mapLocation((Function1<? super PropertyTrace, ? extends PropertyTrace>)((Function1)new Function1<PropertyTrace, PropertyTrace>(this, contextTask){
            final /* synthetic */ DefaultConfigurationCacheProblemsListener this$0;
            final /* synthetic */ TaskInternal $contextTask;
            {
                this.this$0 = $receiver;
                this.$contextTask = $contextTask;
                super(1);
            }

            @NotNull
            public final PropertyTrace invoke(@NotNull PropertyTrace it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultConfigurationCacheProblemsListener.access$locationForTask(this.this$0, it, this.$contextTask);
            }
        })).build());
    }

    private final PropertyTrace locationForTask(PropertyTrace location, TaskInternal task) {
        PropertyTrace propertyTrace;
        if (location instanceof PropertyTrace.BuildLogic) {
            propertyTrace = location;
        } else {
            Class clazz = GeneratedSubclasses.unpackType((Object)task);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"unpackType(task)");
            String string2 = task.getIdentityPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            propertyTrace = new PropertyTrace.Task(clazz, string2);
        }
        return propertyTrace;
    }

    private final ProblemsListener problemsListenerFor(TaskInternal task) {
        ProblemsListener problemsListener;
        if (task.isCompatibleWithConfigurationCache()) {
            problemsListener = this.problems;
        } else {
            String string2 = task.getIdentityPath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            problemsListener = this.problems.forIncompatibleTask(string2);
        }
        return problemsListener;
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (this.isBuildSrcBuild(invocationSource)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    public void onUnsafeCredentials(@NotNull String locationSpecificReason, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)locationSpecificReason, (String)"locationSpecificReason");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.problems.onProblem(this.problemFactory.problem((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(locationSpecificReason){
            final /* synthetic */ String $locationSpecificReason;
            {
                this.$locationSpecificReason = $locationSpecificReason;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                $this$problem.text("Credential values found in configuration for: ");
                $this$problem.text(this.$locationSpecificReason);
            }
        })).exception().documentationSection(DocumentationSection.RequirementsSafeCredentials).mapLocation((Function1<? super PropertyTrace, ? extends PropertyTrace>)((Function1)new Function1<PropertyTrace, PropertyTrace>(this, task){
            final /* synthetic */ DefaultConfigurationCacheProblemsListener this$0;
            final /* synthetic */ TaskInternal $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(1);
            }

            @NotNull
            public final PropertyTrace invoke(@NotNull PropertyTrace it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultConfigurationCacheProblemsListener.access$locationForTask(this.this$0, it, this.$task);
            }
        })).build());
    }

    private final PropertyProblem listenerRegistrationProblem(String invocationDescription, InvalidUserCodeException exception) {
        return this.problemFactory.problem(StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
        })), (Throwable)exception, DocumentationSection.RequirementsBuildListeners);
    }

    private final boolean isBuildSrcBuild(Object invocationSource) {
        boolean bl;
        GradleInternal gradleInternal = invocationSource instanceof GradleInternal ? (GradleInternal)invocationSource : null;
        if (gradleInternal != null) {
            GradleInternal $this$isBuildSrcBuild_u24lambda_u240 = gradleInternal;
            boolean bl2 = false;
            bl = !$this$isBuildSrcBuild_u24lambda_u240.isRootBuild() && Intrinsics.areEqual((Object)$this$isBuildSrcBuild_u24lambda_u240.getIdentityPath().getName(), (Object)"buildSrc");
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }

    private final boolean isInputTrackingDisabled() {
        return !this.inputTrackingState.isEnabledForCurrentThread();
    }

    private final boolean isExecutingWork() {
        return this.workExecutionTracker.getCurrentTask().isPresent() || this.workExecutionTracker.isExecutingTransformAction();
    }

    public static final /* synthetic */ PropertyTrace access$locationForTask(DefaultConfigurationCacheProblemsListener $this, PropertyTrace location, TaskInternal task) {
        return $this.locationForTask(location, task);
    }
}

