/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.AttributeSelectionSchema;

public interface AttributeMatcher {
    @VisibleForTesting
    public AttributeSelectionSchema getSelectionSchema();

    public boolean isMatching(AttributeContainerInternal var1, AttributeContainerInternal var2);

    public <T> boolean isMatching(Attribute<T> var1, T var2, T var3);

    public <T extends HasAttributes> List<T> matches(Collection<? extends T> var1, AttributeContainerInternal var2, AttributeMatchingExplanationBuilder var3);

    public <T extends HasAttributes, E extends T> List<T> matches(Collection<E> var1, AttributeContainerInternal var2, @Nullable T var3, AttributeMatchingExplanationBuilder var4);

    public List<MatchingDescription<?>> describeMatching(AttributeContainerInternal var1, AttributeContainerInternal var2);

    public static class MatchingDescription<T> {
        private final Attribute<T> requestedAttribute;
        private final AttributeValue<T> requestedValue;
        private final AttributeValue<T> found;
        private final boolean match;

        public MatchingDescription(Attribute<T> requestedAttribute, AttributeValue<T> requestedValue, AttributeValue<T> found, boolean match) {
            this.requestedAttribute = requestedAttribute;
            this.requestedValue = requestedValue;
            this.found = found;
            this.match = match;
        }

        public Attribute<T> getRequestedAttribute() {
            return this.requestedAttribute;
        }

        public AttributeValue<T> getRequestedValue() {
            return this.requestedValue;
        }

        public AttributeValue<T> getFound() {
            return this.found;
        }

        public boolean isMatch() {
            return this.match;
        }
    }
}

