/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.ElvisInfo;
import org.jetbrains.kotlin.backend.jvm.lower.JvmSafeCallChainFoldingLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SafeCallInfo;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\n*\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\nH\u0002J\f\u0010\u001e\u001a\u00020\u000f*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u000f*\u00020\u001fH\u0002J\u0016\u0010!\u001a\u00020\"*\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSafeCallChainFoldingLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "booleanNot", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "irAndAnd", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "left", "right", "irFalse", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "startOffset", "", "endOffset", "irTrue", "irValNotNull", "irVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irEqEqNull", "irNot", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "isJvmNullable", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isJvmPrimitive", "wrapWithBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "Transformer", "backend.jvm.lower"})
public final class JvmSafeCallChainFoldingLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol booleanNot;

    public JvmSafeCallChainFoldingLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.booleanNot = this.context.getIrBuiltIns().getBooleanNotSymbol();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new Transformer());
    }

    private final IrCallImpl irNot(IrExpression $this$irNot) {
        IrCallImpl irCallImpl;
        IrCallImpl $this$irNot_u24lambda_u240 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner($this$irNot.getStartOffset(), $this$irNot.getEndOffset(), this.booleanNot);
        boolean bl = false;
        $this$irNot_u24lambda_u240.setDispatchReceiver($this$irNot);
        return irCallImpl;
    }

    private final IrExpression irAndAnd(IrExpression left, IrExpression right) {
        IrCallImpl irCallImpl;
        IrCallImpl $this$irAndAnd_u24lambda_u241 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner(right.getStartOffset(), right.getEndOffset(), this.context.getIrBuiltIns().getAndandSymbol());
        boolean bl = false;
        $this$irAndAnd_u24lambda_u241.putValueArgument(0, left);
        $this$irAndAnd_u24lambda_u241.putValueArgument(1, right);
        return irCallImpl;
    }

    private final IrExpression irEqEqNull(IrExpression $this$irEqEqNull) {
        IrCallImpl irCallImpl;
        IrCallImpl $this$irEqEqNull_u24lambda_u242 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner($this$irEqEqNull.getStartOffset(), $this$irEqEqNull.getEndOffset(), this.context.getIrBuiltIns().getEqeqSymbol());
        boolean bl = false;
        $this$irEqEqNull_u24lambda_u242.putValueArgument(0, $this$irEqEqNull);
        $this$irEqEqNull_u24lambda_u242.putValueArgument(1, IrConstImpl.Companion.constNull($this$irEqEqNull_u24lambda_u242.getStartOffset(), $this$irEqEqNull_u24lambda_u242.getEndOffset(), this.context.getIrBuiltIns().getNothingNType()));
        return irCallImpl;
    }

    private final IrBlock wrapWithBlock(IrExpression $this$wrapWithBlock, IrStatementOrigin origin) {
        return new IrBlockImpl($this$wrapWithBlock.getStartOffset(), $this$wrapWithBlock.getEndOffset(), $this$wrapWithBlock.getType(), origin, CollectionsKt.listOf((Object)$this$wrapWithBlock));
    }

    private final IrConstImpl<Boolean> irTrue(int startOffset, int endOffset) {
        return IrConstImpl.Companion.boolean(startOffset, endOffset, this.context.getIrBuiltIns().getBooleanType(), true);
    }

    private final IrConstImpl<Boolean> irFalse(int startOffset, int endOffset) {
        return IrConstImpl.Companion.boolean(startOffset, endOffset, this.context.getIrBuiltIns().getBooleanType(), false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrExpression irValNotNull(int startOffset, int endOffset, IrVariable irVariable2) {
        IrExpression irExpression;
        if (!this.isJvmNullable(irVariable2.getType())) {
            IrExpression irExpression2 = irVariable2.getInitializer();
            boolean bl = irExpression2 != null ? IrUtilsKt.isConstantLike(irExpression2) : false;
            if (bl) {
                irExpression = this.irTrue(startOffset, endOffset);
                return irExpression;
            }
        }
        irExpression = this.irNot(this.irEqEqNull(new IrGetValueImpl(startOffset, endOffset, irVariable2.getSymbol(), null, 8, null)));
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJvmNullable(IrType $this$isJvmNullable) {
        if (IrTypeUtilsKt.isNullable($this$isJvmNullable)) return true;
        IrAnnotationContainer irAnnotationContainer = $this$isJvmNullable;
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJvmPrimitive(IrType $this$isJvmPrimitive) {
        if (!(IrTypePredicatesKt.isBoolean($this$isJvmPrimitive) || IrTypePredicatesKt.isByte($this$isJvmPrimitive) || IrTypePredicatesKt.isShort($this$isJvmPrimitive) || IrTypePredicatesKt.isInt($this$isJvmPrimitive) || IrTypePredicatesKt.isLong($this$isJvmPrimitive) || IrTypePredicatesKt.isChar($this$isJvmPrimitive) || IrTypePredicatesKt.isFloat($this$isJvmPrimitive))) {
            if (!IrTypePredicatesKt.isDouble($this$isJvmPrimitive)) return false;
        }
        IrAnnotationContainer irAnnotationContainer = $this$isJvmPrimitive;
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSafeCallChainFoldingLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSafeCallChainFoldingLowering;)V", "foldElvis", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "elvisInfo", "Lorg/jetbrains/kotlin/backend/jvm/lower/ElvisInfo;", "foldSafeCall", "safeCallInfo", "Lorg/jetbrains/kotlin/backend/jvm/lower/SafeCallInfo;", "visitBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isFoldedSafeCallWithNonNullResult", "", "backend.jvm.lower"})
    private final class Transformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.transformChildrenVoid(expression2);
            SafeCallInfo safeCallInfo = JvmSafeCallChainFoldingLoweringKt.parseSafeCall(expression2, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns());
            if (safeCallInfo != null) {
                return this.foldSafeCall(safeCallInfo);
            }
            ElvisInfo elvisInfo = JvmSafeCallChainFoldingLoweringKt.parseElvis(expression2, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns());
            if (elvisInfo != null) {
                return this.foldElvis(elvisInfo);
            }
            return expression2;
        }

        private final IrExpression foldSafeCall(SafeCallInfo safeCallInfo) {
            IrBlock safeCallBlock = safeCallInfo.getBlock();
            int startOffset = safeCallBlock.getStartOffset();
            int endOffset = safeCallBlock.getEndOffset();
            IrType safeCallType = safeCallBlock.getType();
            IrVariable safeCallTmpVal = safeCallInfo.getTmpVal();
            IrExpression tmpValInitializer = safeCallTmpVal.getInitializer();
            if (tmpValInitializer instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)tmpValInitializer).getOrigin(), (Object)JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE)) {
                IrBlock foldedBlock = (IrBlock)tmpValInitializer;
                IrStatement irStatement = foldedBlock.getStatements().get(0);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                IrWhen foldedWhen = (IrWhen)irStatement;
                IrExpression safeReceiverCondition = foldedWhen.getBranches().get(0).getCondition();
                IrExpression safeReceiverResult = foldedWhen.getBranches().get(0).getResult();
                safeCallTmpVal.setInitializer(safeReceiverResult);
                safeCallTmpVal.setType(safeReceiverResult.getType());
                Object[] objectArray = new IrStatement[]{safeCallTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, safeCallTmpVal)};
                IrCompositeImpl foldedConditionPart = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])objectArray));
                foldedBlock.setType(safeCallType);
                foldedWhen.setType(safeCallType);
                foldedWhen.getBranches().get(0).setCondition(JvmSafeCallChainFoldingLowering.this.irAndAnd(safeReceiverCondition, foldedConditionPart));
                foldedWhen.getBranches().get(0).setResult(safeCallInfo.getIfNotNullBranch().getResult());
                return foldedBlock;
            }
            Object[] foldedWhen = new IrStatement[]{safeCallTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, safeCallTmpVal)};
            IrCompositeImpl foldedCondition = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])foldedWhen));
            IrExpression safeCallResult = safeCallInfo.getIfNotNullBranch().getResult();
            IrExpression nullResult = safeCallInfo.getIfNullBranch().getResult();
            Object[] objectArray = new IrBranchImpl[]{new IrBranchImpl(startOffset, endOffset, foldedCondition, safeCallResult), new IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), nullResult)};
            IrWhenImpl foldedWhen2 = new IrWhenImpl(startOffset, endOffset, safeCallType, JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE, CollectionsKt.listOf((Object[])objectArray));
            return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(foldedWhen2, JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE);
        }

        private final IrExpression foldElvis(ElvisInfo elvisInfo) {
            IrExpression elvisLhs = elvisInfo.getElvisLhs();
            IrBlock elvisBlock = elvisInfo.getBlock();
            int startOffset = elvisBlock.getStartOffset();
            int endOffset = elvisBlock.getEndOffset();
            IrType elvisType = elvisBlock.getType();
            IrVariable elvisTmpVal = elvisInfo.getTmpVal();
            if (elvisLhs instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)elvisLhs).getOrigin(), (Object)JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE)) {
                IrStatement irStatement = ((IrBlock)elvisLhs).getStatements().get(0);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                IrWhen safeCallWhen = (IrWhen)irStatement;
                IrExpression safeCallCondition = safeCallWhen.getBranches().get(0).getCondition();
                IrExpression safeCallResult = safeCallWhen.getBranches().get(0).getResult();
                elvisTmpVal.setInitializer(safeCallResult);
                elvisTmpVal.setType(safeCallResult.getType());
                Object[] objectArray = new IrStatement[]{elvisTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, elvisTmpVal)};
                IrCompositeImpl foldedConditionPart = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])objectArray));
                ArrayList<IrBranchImpl> branches = new ArrayList<IrBranchImpl>();
                branches.add(new IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irAndAnd(safeCallCondition, foldedConditionPart), new IrGetValueImpl(startOffset, endOffset, elvisTmpVal.getSymbol(), null, 8, null)));
                IrExpression elvisRhs = elvisInfo.getElvisRhs();
                if (this.isFoldedSafeCallWithNonNullResult(elvisRhs)) {
                    Intrinsics.checkNotNull((Object)elvisRhs, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlock");
                    IrStatement irStatement2 = ((IrBlock)elvisRhs).getStatements().get(0);
                    Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                    IrWhen rhsInnerWhen = (IrWhen)irStatement2;
                    branches.addAll((Collection)rhsInnerWhen.getBranches());
                } else {
                    branches.add(new IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), elvisInfo.getElvisRhs()));
                }
                return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(new IrWhenImpl(startOffset, endOffset, elvisType, JvmLoweredStatementOrigin.FOLDED_ELVIS.INSTANCE, (List<? extends IrBranch>)branches), JvmLoweredStatementOrigin.FOLDED_ELVIS.INSTANCE);
            }
            if (elvisLhs instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)elvisLhs).getOrigin(), (Object)JvmLoweredStatementOrigin.FOLDED_ELVIS.INSTANCE)) {
                IrStatement irStatement = ((IrBlock)elvisLhs).getStatements().get(0);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                IrWhen innerElvisWhen = (IrWhen)irStatement;
                IrBranch innerElvisLastBranch = (IrBranch)CollectionsKt.last(innerElvisWhen.getBranches());
                IrExpression innerElvisRhs = innerElvisLastBranch.getResult();
                elvisTmpVal.setInitializer(innerElvisRhs);
                elvisTmpVal.setType(innerElvisRhs.getType());
                Object[] objectArray = new IrElement[]{elvisTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, elvisTmpVal)};
                IrCompositeImpl newCondition = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])objectArray));
                innerElvisLastBranch.setCondition(newCondition);
                innerElvisLastBranch.setResult(new IrGetValueImpl(startOffset, endOffset, elvisTmpVal.getSymbol(), null, 8, null));
                innerElvisWhen.getBranches().add(new IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), elvisInfo.getElvisRhs()));
                innerElvisWhen.setType(elvisType);
                return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(innerElvisWhen, JvmLoweredStatementOrigin.FOLDED_ELVIS.INSTANCE);
            }
            Object[] innerElvisLastBranch = new IrElement[]{elvisTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, elvisTmpVal)};
            IrCompositeImpl newCondition = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])innerElvisLastBranch));
            Object[] objectArray = new IrBranchImpl[]{new IrBranchImpl(startOffset, endOffset, newCondition, new IrGetValueImpl(startOffset, endOffset, elvisTmpVal.getSymbol(), null, 8, null)), new IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), elvisInfo.getElvisRhs())};
            IrWhenImpl foldedWhen = new IrWhenImpl(startOffset, endOffset, elvisType, JvmLoweredStatementOrigin.FOLDED_ELVIS.INSTANCE, CollectionsKt.listOf((Object[])objectArray));
            return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(foldedWhen, JvmLoweredStatementOrigin.FOLDED_ELVIS.INSTANCE);
        }

        private final boolean isFoldedSafeCallWithNonNullResult(IrExpression $this$isFoldedSafeCallWithNonNullResult) {
            if (!($this$isFoldedSafeCallWithNonNullResult instanceof IrBlock)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((IrBlock)$this$isFoldedSafeCallWithNonNullResult).getOrigin(), (Object)JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE)) {
                return false;
            }
            IrStatement irStatement = ((IrBlock)$this$isFoldedSafeCallWithNonNullResult).getStatements().get(0);
            IrWhen irWhen = irStatement instanceof IrWhen ? (IrWhen)irStatement : null;
            if (irWhen == null) {
                return false;
            }
            IrWhen innerWhen = irWhen;
            IrExpression safeCallResult = innerWhen.getBranches().get(0).getResult();
            return !JvmSafeCallChainFoldingLowering.this.isJvmNullable(safeCallResult.getType());
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.transformChildrenVoid(expression2);
            if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getEqeqSymbol())) {
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                IrExpression irExpression = expression2.getValueArgument(0);
                if (irExpression == null) {
                    throw new AssertionError((Object)("No value argument #0: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null)));
                }
                IrExpression left = irExpression;
                IrExpression irExpression2 = expression2.getValueArgument(1);
                if (irExpression2 == null) {
                    throw new AssertionError((Object)("No value argument #1: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null)));
                }
                IrExpression right = irExpression2;
                if (left instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)left).getOrigin(), (Object)JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE) && JvmSafeCallChainFoldingLowering.this.isJvmPrimitive(right.getType())) {
                    IrStatement irStatement = ((IrBlock)left).getStatements().get(0);
                    Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                    IrWhen safeCallWhen = (IrWhen)irStatement;
                    IrExpression safeCallResult = safeCallWhen.getBranches().get(0).getResult();
                    expression2.putValueArgument(0, safeCallResult);
                    safeCallWhen.getBranches().get(0).setResult(expression2);
                    safeCallWhen.getBranches().get(1).setResult(JvmSafeCallChainFoldingLowering.this.irFalse(startOffset, endOffset));
                    safeCallWhen.setType(expression2.getType());
                    return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(safeCallWhen, null);
                }
                if (right instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)right).getOrigin(), (Object)JvmLoweredStatementOrigin.FOLDED_SAFE_CALL.INSTANCE) && JvmSafeCallChainFoldingLowering.this.isJvmPrimitive(left.getType())) {
                    IrStatement irStatement = ((IrBlock)right).getStatements().get(0);
                    Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                    IrWhen safeCallWhen = (IrWhen)irStatement;
                    IrExpression safeCallResult = safeCallWhen.getBranches().get(0).getResult();
                    expression2.putValueArgument(1, safeCallResult);
                    safeCallWhen.getBranches().get(0).setResult(expression2);
                    safeCallWhen.getBranches().get(1).setResult(JvmSafeCallChainFoldingLowering.this.irFalse(startOffset, endOffset));
                    safeCallWhen.setType(expression2.getType());
                    return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(safeCallWhen, null);
                }
            }
            return expression2;
        }
    }
}

