/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAnyOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeNothing;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleSetExclude;

class Intersections {
    private final ExcludeFactory factory;

    public Intersections(ExcludeFactory factory) {
        this.factory = factory;
    }

    ExcludeSpec tryIntersect(ExcludeSpec left, ExcludeSpec right) {
        ExcludeSpec excludeSpec;
        if (left.equals(right)) {
            return left;
        }
        if (left instanceof ExcludeAnyOf) {
            ExcludeSpec excludeSpec2 = this.intersectAnyOf((ExcludeAnyOf)left, right);
            if (excludeSpec2 != null) {
                return excludeSpec2;
            }
        } else if (right instanceof ExcludeAnyOf && (excludeSpec = this.intersectAnyOf((ExcludeAnyOf)right, left)) != null) {
            return excludeSpec;
        }
        if (left instanceof GroupExclude) {
            return this.intersectGroup((GroupExclude)left, right);
        }
        if (right instanceof GroupExclude) {
            return this.intersectGroup((GroupExclude)right, left);
        }
        if (left instanceof ModuleExclude) {
            return this.intersectModule((ModuleExclude)left, right);
        }
        if (right instanceof ModuleExclude) {
            return this.intersectModule((ModuleExclude)right, left);
        }
        if (left instanceof GroupSetExclude) {
            return this.intersectGroupSet((GroupSetExclude)left, right);
        }
        if (right instanceof GroupSetExclude) {
            return this.intersectGroupSet((GroupSetExclude)right, left);
        }
        if (left instanceof ModuleIdExclude) {
            return this.intersectModuleId((ModuleIdExclude)left, right);
        }
        if (right instanceof ModuleIdExclude) {
            return this.intersectModuleId((ModuleIdExclude)right, left);
        }
        if (left instanceof ModuleIdSetExclude) {
            return this.intersectModuleIdSet((ModuleIdSetExclude)left, right);
        }
        if (right instanceof ModuleIdSetExclude) {
            return this.intersectModuleIdSet((ModuleIdSetExclude)right, left);
        }
        if (left instanceof ModuleSetExclude) {
            return this.intersectModuleSet((ModuleSetExclude)left, right);
        }
        if (right instanceof ModuleSetExclude) {
            return this.intersectModuleSet((ModuleSetExclude)right, left);
        }
        return null;
    }

    private ExcludeSpec intersectModuleSet(ModuleSetExclude left, ExcludeSpec right) {
        if (right instanceof ModuleSetExclude) {
            ModuleSetExclude msr = (ModuleSetExclude)right;
            HashSet modules = Sets.newHashSet(left.getModules());
            modules.retainAll(msr.getModules());
            if (modules.isEmpty()) {
                return this.factory.nothing();
            }
            if (modules.size() == 1) {
                return this.factory.module((String)modules.iterator().next());
            }
            return this.factory.moduleSet(modules);
        }
        return null;
    }

    private ExcludeSpec intersectAnyOf(ExcludeAnyOf left, ExcludeSpec right) {
        Set<ExcludeSpec> leftComponents = left.getComponents();
        if (right instanceof ExcludeAnyOf) {
            Set<ExcludeSpec> rightComponents = ((ExcludeAnyOf)right).getComponents();
            HashSet common = Sets.newHashSet(leftComponents);
            common.retainAll(rightComponents);
            if (common.size() >= 1) {
                ExcludeSpec alpha = this.asUnion(common);
                if (leftComponents.equals(common) || rightComponents.equals(common)) {
                    return alpha;
                }
                HashSet remainderLeft = Sets.newHashSet(leftComponents);
                remainderLeft.removeAll(common);
                HashSet remainderRight = Sets.newHashSet(rightComponents);
                remainderRight.removeAll(common);
                ExcludeSpec unionLeft = this.asUnion(remainderLeft);
                ExcludeSpec unionRight = this.asUnion(remainderRight);
                ExcludeSpec beta = this.factory.allOf(unionLeft, unionRight);
                return this.factory.anyOf(alpha, beta);
            }
            HashSet intersections = Sets.newHashSetWithExpectedSize((int)(leftComponents.size() * rightComponents.size()));
            for (ExcludeSpec leftSpec : leftComponents) {
                for (ExcludeSpec rightSpec : rightComponents) {
                    ExcludeSpec merged = this.tryIntersect(leftSpec, rightSpec);
                    if (merged == null) {
                        merged = this.factory.allOf(leftSpec, rightSpec);
                    }
                    if (merged instanceof ExcludeNothing) continue;
                    intersections.add(merged);
                }
            }
            return this.asUnion(intersections);
        }
        ExcludeSpec[] excludeSpecs = leftComponents.toArray(new ExcludeSpec[0]);
        ExcludeSpec[] intersections = null;
        for (int i = 0; i < excludeSpecs.length; ++i) {
            ExcludeSpec excludeSpec = this.tryIntersect(excludeSpecs[i], right);
            if (excludeSpec == null) continue;
            if (intersections == null) {
                intersections = new ExcludeSpec[excludeSpecs.length];
            }
            intersections[i] = excludeSpec;
        }
        if (intersections != null) {
            HashSet simplified = Sets.newHashSetWithExpectedSize((int)excludeSpecs.length);
            for (int i = 0; i < intersections.length; ++i) {
                ExcludeSpec intersection = intersections[i];
                if (intersection instanceof ExcludeNothing) continue;
                if (intersection != null) {
                    simplified.add(intersection);
                    continue;
                }
                simplified.add(this.factory.allOf(excludeSpecs[i], right));
            }
            return this.asUnion(simplified);
        }
        return null;
    }

    private ExcludeSpec asUnion(Set<ExcludeSpec> remainder) {
        if (remainder.isEmpty()) {
            return this.factory.nothing();
        }
        return remainder.size() == 1 ? remainder.iterator().next() : this.factory.anyOf(remainder);
    }

    private ExcludeSpec intersectModuleId(ModuleIdExclude left, ExcludeSpec right) {
        if (right instanceof ModuleIdExclude) {
            if (left.equals(right)) {
                return left;
            }
            return this.factory.nothing();
        }
        if (right instanceof ModuleIdSetExclude) {
            Set<ModuleIdentifier> rightModuleIds = ((ModuleIdSetExclude)right).getModuleIds();
            if (rightModuleIds.contains(left.getModuleId())) {
                return left;
            }
            return this.factory.nothing();
        }
        return null;
    }

    private ExcludeSpec intersectModuleIdSet(ModuleIdSetExclude left, ExcludeSpec right) {
        Set<ModuleIdentifier> moduleIds = left.getModuleIds();
        if (right instanceof ModuleIdSetExclude) {
            HashSet common = Sets.newHashSet(((ModuleIdSetExclude)right).getModuleIds());
            common.retainAll(moduleIds);
            return this.moduleIds(common);
        }
        if (right instanceof ModuleSetExclude) {
            Set<String> modules = ((ModuleSetExclude)right).getModules();
            Set<ModuleIdentifier> identifiers = moduleIds.stream().filter(e -> modules.contains(e.getName())).collect(Collectors.toSet());
            if (identifiers.isEmpty()) {
                return this.factory.nothing();
            }
            if (identifiers.size() == 1) {
                return this.factory.moduleId((ModuleIdentifier)identifiers.iterator().next());
            }
            return this.factory.moduleIdSet(identifiers);
        }
        return null;
    }

    private ExcludeSpec moduleIds(Set<ModuleIdentifier> common) {
        if (common.isEmpty()) {
            return this.factory.nothing();
        }
        if (common.size() == 1) {
            return this.factory.moduleId(common.iterator().next());
        }
        return this.factory.moduleIdSet(common);
    }

    private ExcludeSpec intersectGroup(GroupExclude left, ExcludeSpec right) {
        String group = left.getGroup();
        if (right instanceof GroupExclude) {
            return this.factory.nothing();
        }
        if (right instanceof ModuleIdExclude) {
            if (((ModuleIdExclude)right).getModuleId().getGroup().equals(group)) {
                return right;
            }
            return this.factory.nothing();
        }
        if (right instanceof GroupSetExclude) {
            if (((GroupSetExclude)right).getGroups().stream().anyMatch(g -> g.equals(group))) {
                return left;
            }
            return this.factory.nothing();
        }
        if (right instanceof ModuleIdSetExclude) {
            Set<ModuleIdentifier> moduleIds = ((ModuleIdSetExclude)right).getModuleIds().stream().filter(id -> id.getGroup().equals(group)).collect(Collectors.toSet());
            return this.moduleIdSet(moduleIds);
        }
        if (right instanceof ModuleExclude) {
            return this.factory.moduleId(DefaultModuleIdentifier.newId(left.getGroup(), ((ModuleExclude)right).getModule()));
        }
        if (right instanceof ModuleSetExclude) {
            ModuleSetExclude moduleSet = (ModuleSetExclude)right;
            return this.factory.moduleIdSet(moduleSet.getModules().stream().map(module -> DefaultModuleIdentifier.newId(left.getGroup(), module)).collect(Collectors.toSet()));
        }
        return null;
    }

    private ExcludeSpec moduleIdSet(Set<ModuleIdentifier> moduleIds) {
        if (moduleIds.isEmpty()) {
            return this.factory.nothing();
        }
        if (moduleIds.size() == 1) {
            return this.factory.moduleId(moduleIds.iterator().next());
        }
        return this.factory.moduleIdSet(moduleIds);
    }

    private ExcludeSpec intersectGroupSet(GroupSetExclude left, ExcludeSpec right) {
        Set<String> groups = left.getGroups();
        if (right instanceof GroupSetExclude) {
            HashSet common = Sets.newHashSet(((GroupSetExclude)right).getGroups());
            common.retainAll(groups);
            return this.groupSet(common);
        }
        if (right instanceof ModuleIdExclude) {
            if (groups.contains(((ModuleIdExclude)right).getModuleId().getGroup())) {
                return right;
            }
            return this.factory.nothing();
        }
        if (right instanceof ModuleIdSetExclude) {
            Set<ModuleIdentifier> filtered = ((ModuleIdSetExclude)right).getModuleIds().stream().filter(id -> groups.contains(id.getGroup())).collect(Collectors.toSet());
            return this.moduleIdSet(filtered);
        }
        if (right instanceof ModuleSetExclude) {
            return this.factory.moduleIdSet(groups.stream().flatMap(group -> ((ModuleSetExclude)right).getModules().stream().map(module -> DefaultModuleIdentifier.newId(group, module))).collect(Collectors.toSet()));
        }
        return null;
    }

    private ExcludeSpec groupSet(Set<String> common) {
        if (common.isEmpty()) {
            return this.factory.nothing();
        }
        if (common.size() == 1) {
            return this.factory.group(common.iterator().next());
        }
        return this.factory.groupSet(common);
    }

    private ExcludeSpec intersectModule(ModuleExclude left, ExcludeSpec right) {
        String module = left.getModule();
        if (right instanceof ModuleExclude) {
            if (((ModuleExclude)right).getModule().equals(module)) {
                return left;
            }
            return this.factory.nothing();
        }
        if (right instanceof ModuleIdExclude) {
            if (((ModuleIdExclude)right).getModuleId().getName().equals(module)) {
                return right;
            }
            return this.factory.nothing();
        }
        if (right instanceof ModuleSetExclude) {
            if (((ModuleSetExclude)right).getModules().stream().anyMatch(g -> g.equals(module))) {
                return left;
            }
            return this.factory.nothing();
        }
        if (right instanceof ModuleIdSetExclude) {
            Set<ModuleIdentifier> common = ((ModuleIdSetExclude)right).getModuleIds().stream().filter(id -> id.getName().equals(module)).collect(Collectors.toSet());
            return this.moduleIdSet(common);
        }
        if (right instanceof GroupSetExclude) {
            return this.factory.moduleIdSet(((GroupSetExclude)right).getGroups().stream().map(group -> DefaultModuleIdentifier.newId(group, module)).collect(Collectors.toSet()));
        }
        return null;
    }
}

