/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.DefaultScriptClassPathResolver;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class BuildSrcBuildListenerFactory {
    private final Action<ProjectInternal> buildSrcRootProjectConfiguration;
    private final NamedObjectInstantiator instantiator;
    private final CachedClasspathTransformer classpathTransformer;

    public BuildSrcBuildListenerFactory(Action<ProjectInternal> buildSrcRootProjectConfiguration, NamedObjectInstantiator instantiator, CachedClasspathTransformer classpathTransformer) {
        this.buildSrcRootProjectConfiguration = buildSrcRootProjectConfiguration;
        this.instantiator = instantiator;
        this.classpathTransformer = classpathTransformer;
    }

    Listener create() {
        return new Listener(this.buildSrcRootProjectConfiguration, this.instantiator, this.classpathTransformer);
    }

    public static class Listener
    extends InternalBuildAdapter
    implements EntryTaskSelector {
        private Configuration classpathConfiguration;
        private ProjectState rootProjectState;
        private final Action<ProjectInternal> rootProjectConfiguration;
        private final ScriptClassPathResolver resolver;

        private Listener(Action<ProjectInternal> rootProjectConfiguration, NamedObjectInstantiator instantiator, CachedClasspathTransformer classpathTransformer) {
            this.rootProjectConfiguration = rootProjectConfiguration;
            this.resolver = new DefaultScriptClassPathResolver(Collections.emptyList(), instantiator, classpathTransformer);
        }

        public void projectsLoaded(Gradle gradle) {
            GradleInternal gradleInternal = (GradleInternal)gradle;
            gradleInternal.getStartParameter().setTaskRequests(Collections.emptyList());
            ProjectInternal rootProject = gradleInternal.getRootProject();
            this.rootProjectState = rootProject.getOwner();
            this.rootProjectConfiguration.execute((Object)rootProject);
        }

        @Override
        public void applyTasksTo(EntryTaskSelector.Context context, ExecutionPlan plan) {
            this.rootProjectState.applyToMutableState(rootProject -> {
                this.classpathConfiguration = (Configuration)rootProject.getConfigurations().create("buildScriptClasspath");
                this.classpathConfiguration.setCanBeConsumed(false);
                this.resolver.prepareClassPath(this.classpathConfiguration, rootProject.getDependencies());
                this.classpathConfiguration.getDependencies().add((Object)rootProject.getDependencies().create(rootProject));
                plan.addEntryTasks(TaskDependencyUtil.getDependenciesForInternalUse((TaskDependency)this.classpathConfiguration.getBuildDependencies(), null));
            });
        }

        public ClassPath getRuntimeClasspath() {
            return this.rootProjectState.fromMutableState(project -> this.resolver.resolveClassPath(this.classpathConfiguration));
        }
    }
}

