/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\n\u0010\u0018\u001a\u00020\u0010*\u00020\f\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0019"}, d2={"fileClassPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getFileClassPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "checkAllFileLevelDeclarationsAreClasses", "", "irModuleFragment", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shortName", "", "getFileClassInfoFromIrFile", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "fileName", "getLiteralStringFromAnnotation", "annotationCall", "manglePartName", "facadeName", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/backend/jvm/lower/ParsedJvmFileClassAnnotations;", "getFileClassInfo", "backend.jvm.lower"})
public final class FileClassLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> fileClassPhase = PhaseBuildersKt.makeIrModulePhase$default(fileClassPhase.1.INSTANCE, "FileClass", "Put file level function and property declaration into a class", null, null, null, SetsKt.setOf((Object)((Object)fileClassPhase.2.INSTANCE)), null, 184, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> getFileClassPhase() {
        return fileClassPhase;
    }

    public static final void checkAllFileLevelDeclarationsAreClasses(@NotNull IrModuleFragment irModuleFragment) {
        boolean bl;
        block8: {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)irModuleFragment, (String)"irModuleFragment");
            Iterable $this$all$iv = irModuleFragment.getFiles();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl3;
                    block7: {
                        IrFile irFile = (IrFile)element$iv;
                        boolean bl4 = false;
                        Iterable $this$all$iv2 = irFile.getDeclarations();
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                IrDeclaration it = (IrDeclaration)element$iv2;
                                boolean bl5 = false;
                                if (it instanceof IrClass) continue;
                                bl3 = false;
                                break block7;
                            }
                            bl3 = true;
                        }
                    }
                    if (bl3) continue;
                    bl2 = false;
                    break block8;
                }
                bl2 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull IrFile $this$getFileClassInfo) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getFileClassInfo, (String)"<this>");
        IrFileEntry fileEntry = $this$getFileClassInfo.getFileEntry();
        if (fileEntry instanceof PsiIrFileEntry) {
            PsiFile psiFile = ((PsiIrFileEntry)fileEntry).getPsiFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            jvmFileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)psiFile);
        } else if (fileEntry instanceof NaiveSourceBasedFileEntryImpl) {
            String string2 = new File(fileEntry.getName()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File(fileEntry.name).name");
            jvmFileClassInfo = FileClassLoweringKt.getFileClassInfoFromIrFile($this$getFileClassInfo, string2);
        } else {
            throw new IllegalStateException(("unknown kind of file entry: " + fileEntry).toString());
        }
        return jvmFileClassInfo;
    }

    @NotNull
    public static final JvmFileClassInfo getFileClassInfoFromIrFile(@NotNull IrFile file2, @NotNull String fileName) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ParsedJvmFileClassAnnotations parsedAnnotations = FileClassLoweringKt.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file2.getFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string2 = parsedAnnotations.getJvmName();
            if (string2 == null) {
                string2 = PackagePartClassUtils.getFilePartShortName(fileName);
            }
            String simpleName = string2;
            FqName fqName2 = ((FqName)packageFqName).child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageFqName.child(Name.identifier(simpleName))");
            FqName facadeClassFqName = fqName2;
            if (parsedAnnotations.isMultifileClass()) {
                FqName fqName3 = ((FqName)packageFqName).child(Name.identifier(FileClassLoweringKt.manglePartName(simpleName, fileName)));
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"packageFqName.child(Name\u2026e(simpleName, fileName)))");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(fqName3, facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, fileName), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     */
    private static final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(IrFile file) {
        jvmNameAnnotation = FileClassLoweringKt.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_NAME_SHORT());
        v0 = jvmNameAnnotation;
        if (v0 == null) ** GOTO lbl-1000
        p0 = v0;
        $i$a$-let-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = FileClassLoweringKt.getLiteralStringFromAnnotation((IrConstructorCall)p0);
        v0 = v1;
        if (v1 != null) {
            p0 = var4_5 = v0;
            $i$a$-takeIf-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 = Name.isValidIdentifier((String)p0) ? var4_5 : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = jvmName = null;
        }
        if ((v3 = (jvmPackageNameAnnotation = FileClassLoweringKt.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_PACKAGE_NAME_SHORT()))) == null) ** GOTO lbl-1000
        p0 = v3;
        $i$a$-let-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = FileClassLoweringKt.getLiteralStringFromAnnotation((IrConstructorCall)p0);
        v3 = v4;
        if (v4 != null) {
            p0 = v3;
            $i$a$-let-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = FileClassLoweringKt.findAnnotationEntryOnFileNoResolve(file, JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    private static final IrConstructorCall findAnnotationEntryOnFileNoResolve(IrFile file2, String shortName) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = file2.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrConstructorCall it = (IrConstructorCall)element$iv;
                boolean bl = false;
                Object object = IrTypesKt.getClassFqName(it.getType());
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((FqName)object).shortName()) != null ? ((Name)object).asString() : null), (Object)shortName)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final String getLiteralStringFromAnnotation(IrConstructorCall annotationCall) {
        String string2;
        if (annotationCall.getValueArgumentsCount() < 1) {
            return null;
        }
        IrExpression irExpression = annotationCall.getValueArgument(0);
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            if (it instanceof IrConst && Intrinsics.areEqual(((IrConst)it).getKind(), (Object)IrConstKind.String.INSTANCE)) {
                Object t = ((IrConst)it).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.String");
                string2 = (String)t;
            } else {
                string2 = null;
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final String manglePartName(String facadeName, String fileName) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }
}

