/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultProjectsPreparer
implements ProjectsPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectConfigurer projectConfigurer;
    private final BuildModelParameters buildModelParameters;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildStateRegistry buildStateRegistry;

    public DefaultProjectsPreparer(ProjectConfigurer projectConfigurer, BuildModelParameters buildModelParameters, ModelConfigurationListener modelConfigurationListener, BuildOperationExecutor buildOperationExecutor, BuildStateRegistry buildStateRegistry) {
        this.projectConfigurer = projectConfigurer;
        this.buildModelParameters = buildModelParameters;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildStateRegistry = buildStateRegistry;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        if (!this.buildModelParameters.isConfigureOnDemand() || !gradle.isRootBuild()) {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
            new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
        }
        if (gradle.isRootBuild()) {
            this.buildStateRegistry.afterConfigureRootBuild();
        }
        this.modelConfigurationListener.onConfigure(gradle);
    }
}

