/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002J\u0014\u0010\n\u001a\u00020\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector;", "", "()V", "getMainFunctionOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "isMain", "", "allowEmptyParameters", "isSuitableForMainParametersSize", "backend.js"})
public final class JsMainFunctionDetector {
    @NotNull
    public static final JsMainFunctionDetector INSTANCE = new JsMainFunctionDetector();

    private JsMainFunctionDetector() {
    }

    private final boolean isSuitableForMainParametersSize(IrSimpleFunction $this$isSuitableForMainParametersSize, boolean allowEmptyParameters) {
        boolean bl;
        int n = $this$isSuitableForMainParametersSize.getValueParameters().size();
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                bl = allowEmptyParameters;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMain(IrSimpleFunction $this$isMain, boolean allowEmptyParameters) {
        boolean bl;
        block16: {
            void $this$any$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Collection collection = $this$isMain.getTypeParameters();
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                return false;
            }
            if (!this.isSuitableForMainParametersSize($this$isMain, allowEmptyParameters)) {
                return false;
            }
            if (!IrTypePredicatesKt.isUnit($this$isMain.getReturnType())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)$this$isMain.getName().asString(), (Object)"main")) {
                return false;
            }
            if ($this$isMain.getExtensionReceiverParameter() != null) {
                return false;
            }
            if ($this$isMain.getValueParameters().size() == 1) {
                IrTypeProjection irTypeProjection;
                IrValueParameter parameter = (IrValueParameter)CollectionsKt.single($this$isMain.getValueParameters());
                if (!IrTypePredicatesKt.isArray(parameter.getType())) {
                    return false;
                }
                IrSimpleType type2 = (IrSimpleType)parameter.getType();
                if (type2.getArguments().size() != 1) {
                    return false;
                }
                Object object = CollectionsKt.single(type2.getArguments());
                IrTypeProjection irTypeProjection2 = irTypeProjection = object instanceof IrTypeProjection ? (IrTypeProjection)object : null;
                if (irTypeProjection == null) {
                    return false;
                }
                IrTypeProjection argument22 = irTypeProjection;
                if (argument22.getVariance() == Variance.IN_VARIANCE) {
                    return false;
                }
                return IrTypePredicatesKt.isString(argument22.getType());
            }
            boolean parameter = false;
            boolean type2 = false;
            type2 = false;
            boolean argument22 = false;
            if (!allowEmptyParameters) {
                boolean bl3 = false;
                String argument22 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(argument22.toString());
            }
            parameter = $this$isMain.getValueParameters().isEmpty();
            type2 = false;
            argument22 = false;
            argument22 = false;
            boolean bl4 = false;
            if (!parameter) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            IrFile file2 = (IrFile)$this$isMain.getParent();
            Iterable $this$filterIsInstance$iv = file2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl6 = false;
                    if (!INSTANCE.isMain(it, false)) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Pair resultPair = null;
        Iterable $this$forEach$iv = module2.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            String fqn;
            Object object;
            block5: {
                void $this$singleOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                IrFile f = (IrFile)element$iv;
                boolean bl = false;
                object = f.getFqName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"f.fqName.asString()");
                fqn = object;
                Iterable $this$filterIsInstance$iv = f.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv2 : $this$singleOrNull$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv2;
                    boolean bl2 = false;
                    if (!INSTANCE.isMain(it, true)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv2;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            object = v0;
            if (object == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            Pair result2 = resultPair;
            if (result2 == null) {
                resultPair = new Pair((Object)fqn, it);
                continue;
            }
            if (fqn.compareTo((String)result2.getFirst()) >= 0) continue;
            resultPair = new Pair((Object)fqn, it);
        }
        Pair pair = resultPair;
        return pair == null ? null : (IrSimpleFunction)pair.getSecond();
    }
}

