/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.internal.Pair;
import org.gradle.internal.build.BuildState;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;
    private final BuildState currentBuild;

    public CompositeBuildClassPathInitializer(IncludedBuildTaskGraph includedBuildTaskGraph, BuildState currentBuild) {
        this.includedBuildTaskGraph = includedBuildTaskGraph;
        this.currentBuild = currentBuild;
    }

    public void execute(Configuration classpath) {
        ArrayList<Pair> tasksToBuild = new ArrayList<Pair>();
        for (Task task : classpath.getBuildDependencies().getDependencies(null)) {
            if (task.getState().getExecuted()) continue;
            BuildState targetBuild = ((ProjectInternal)task.getProject()).getOwner().getOwner();
            assert (targetBuild != this.currentBuild);
            tasksToBuild.add(Pair.of((Object)targetBuild.getBuildIdentifier(), (Object)((TaskInternal)task)));
        }
        if (!tasksToBuild.isEmpty()) {
            this.includedBuildTaskGraph.withNewTaskGraph(() -> {
                this.includedBuildTaskGraph.prepareTaskGraph(() -> {
                    for (Pair task : tasksToBuild) {
                        this.includedBuildTaskGraph.locateTask((BuildIdentifier)task.left, (TaskInternal)task.right).queueForExecution();
                    }
                    this.includedBuildTaskGraph.populateTaskGraphs();
                });
                this.includedBuildTaskGraph.runScheduledTasks();
                return null;
            });
        }
    }
}

