/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.reflect.validation.AbstractValidationProblemBuilder;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.PropertyProblemBuilderInternal;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemLocation;
import org.gradle.plugin.use.PluginId;

public class DefaultPropertyValidationProblemBuilder
extends AbstractValidationProblemBuilder<PropertyProblemBuilder>
implements PropertyProblemBuilderInternal {
    private Class<?> rootType;
    private String parentProperty;
    private String property;

    public DefaultPropertyValidationProblemBuilder(DocumentationRegistry documentationRegistry, @Nullable PluginId pluginId) {
        super(documentationRegistry, pluginId);
    }

    @Override
    public PropertyProblemBuilder forProperty(String parentProperty, String property) {
        this.parentProperty = parentProperty;
        this.property = property;
        return this;
    }

    @Override
    public PropertyProblemBuilder forOwner(@Nullable String parentProperty) {
        if (parentProperty == null) {
            return this;
        }
        if (this.property == null) {
            throw new IllegalStateException("Calling this method doesn't make sense if the property isn't set");
        }
        this.parentProperty = this.parentProperty == null ? parentProperty : parentProperty + "." + this.parentProperty;
        return this;
    }

    @Override
    public PropertyProblemBuilder forType(@Nullable Class<?> rootType) {
        this.rootType = rootType;
        return this;
    }

    @Override
    public TypeValidationProblem build() {
        if (this.problemId == null) {
            throw new IllegalStateException("You must set the problem id");
        }
        if (this.shortProblemDescription == null) {
            throw new IllegalStateException("You must provide at least a short description of the problem");
        }
        return new TypeValidationProblem(this.problemId, this.severity, TypeValidationProblemLocation.forProperty(this.typeIrrelevantInErrorMessage ? null : this.rootType, this.typeIrrelevantInErrorMessage ? null : this.pluginId, this.parentProperty, this.property), this.shortProblemDescription, this.longDescription, this.reason, this.cacheabilityProblemOnly, this.userManualReference, this.possibleSolutions);
    }
}

