/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Supplier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.DefaultIncludedBuildControllers;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.taskgraph.CalculateTreeTaskGraphBuildOperationType;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultIncludedBuildTaskGraph
implements IncludedBuildTaskGraph,
Closeable {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildStateRegistry buildRegistry;
    private final WorkerLeaseService workerLeaseService;
    private final ProjectStateRegistry projectStateRegistry;
    private final ManagedExecutor executorService;
    private Thread owner;
    private State state = State.NotCreated;
    private IncludedBuildControllers includedBuilds;

    public DefaultIncludedBuildTaskGraph(ExecutorFactory executorFactory, BuildOperationExecutor buildOperationExecutor, BuildStateRegistry buildRegistry, ProjectStateRegistry projectStateRegistry, WorkerLeaseService workerLeaseService) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildRegistry = buildRegistry;
        this.projectStateRegistry = projectStateRegistry;
        this.executorService = executorFactory.create("included builds");
        this.workerLeaseService = workerLeaseService;
        this.includedBuilds = this.createControllers();
    }

    private DefaultIncludedBuildControllers createControllers() {
        return new DefaultIncludedBuildControllers(this.executorService, this.buildRegistry, this.projectStateRegistry, this.workerLeaseService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withNewTaskGraph(Supplier<T> action) {
        IncludedBuildControllers currentControllers;
        State currentState;
        Thread currentOwner;
        DefaultIncludedBuildTaskGraph defaultIncludedBuildTaskGraph = this;
        synchronized (defaultIncludedBuildTaskGraph) {
            if (this.state != State.Running && this.owner != null && this.owner != Thread.currentThread()) {
                throw new IllegalStateException("This task graph is already in use.");
            }
            currentOwner = this.owner;
            currentState = this.state;
            currentControllers = this.includedBuilds;
            this.owner = Thread.currentThread();
            this.state = State.NotPrepared;
            this.includedBuilds = this.createControllers();
        }
        try {
            defaultIncludedBuildTaskGraph = action.get();
            return (T)defaultIncludedBuildTaskGraph;
        }
        finally {
            this.includedBuilds.close();
            DefaultIncludedBuildTaskGraph defaultIncludedBuildTaskGraph2 = this;
            synchronized (defaultIncludedBuildTaskGraph2) {
                this.owner = currentOwner;
                this.state = currentState;
                this.includedBuilds = currentControllers;
            }
        }
    }

    public void prepareTaskGraph(final Runnable action) {
        this.withState(() -> {
            this.expectInState(State.NotPrepared);
            this.state = State.QueuingTasks;
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    action.run();
                    context.setResult((Object)new CalculateTreeTaskGraphBuildOperationType.Result(){});
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Calculate build tree task graph").details((Object)new CalculateTreeTaskGraphBuildOperationType.Details(){});
                }
            });
            this.expectInState(State.Populated);
            this.state = State.ReadyToRun;
            return null;
        });
    }

    public IncludedBuildTaskResource locateTask(BuildIdentifier targetBuild, TaskInternal task) {
        return this.withState(() -> {
            this.assertCanLocateTask();
            IncludedBuildController buildController = this.includedBuilds.getBuildController(targetBuild);
            return new TaskBackedResource(buildController, buildController.locateTask(task));
        });
    }

    public IncludedBuildTaskResource locateTask(BuildIdentifier targetBuild, String taskPath) {
        return this.withState(() -> {
            this.assertCanLocateTask();
            IncludedBuildController buildController = this.includedBuilds.getBuildController(targetBuild);
            return new TaskBackedResource(buildController, buildController.locateTask(taskPath));
        });
    }

    private void queueForExecution(IncludedBuildController buildController, ExportedTaskNode taskNode) {
        this.withState(() -> {
            this.assertCanQueueTask();
            buildController.queueForExecution(taskNode);
            return null;
        });
    }

    public void populateTaskGraphs() {
        this.withState(() -> {
            this.assertCanQueueTask();
            this.includedBuilds.populateTaskGraphs();
            this.state = State.Populated;
            return null;
        });
    }

    public void startTaskExecution() {
        this.withState(() -> {
            this.expectInState(State.ReadyToRun);
            this.state = State.Running;
            this.includedBuilds.startTaskExecution();
            return null;
        });
    }

    public ExecutionResult<Void> awaitTaskCompletion() {
        return this.withState(() -> {
            this.expectInState(State.Running);
            try {
                ExecutionResult<Void> executionResult = this.includedBuilds.awaitTaskCompletion();
                return executionResult;
            }
            finally {
                this.state = State.Finished;
            }
        });
    }

    public void runScheduledTasks() {
        this.startTaskExecution();
        ExecutionResult<Void> result = this.awaitTaskCompletion();
        result.rethrow();
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.includedBuilds, this.executorService});
    }

    private void assertCanLocateTask() {
        if (this.state == State.NotPrepared) {
            return;
        }
        this.assertCanQueueTask();
    }

    private void assertCanQueueTask() {
        if (this.state != State.QueuingTasks && this.state != State.Populated) {
            throw this.unexpectedState();
        }
    }

    private void expectInState(State expectedState) {
        if (this.state != expectedState) {
            throw this.unexpectedState();
        }
    }

    private IllegalStateException unexpectedState() {
        return new IllegalStateException("Work graph is in an unexpected state: " + (Object)((Object)this.state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withState(Supplier<T> action) {
        Thread currentOwner;
        DefaultIncludedBuildTaskGraph defaultIncludedBuildTaskGraph = this;
        synchronized (defaultIncludedBuildTaskGraph) {
            currentOwner = this.owner;
            if (this.owner == null) {
                this.owner = Thread.currentThread();
            } else if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException("This task graph is already in use.");
            }
        }
        try {
            defaultIncludedBuildTaskGraph = action.get();
            return (T)defaultIncludedBuildTaskGraph;
        }
        finally {
            DefaultIncludedBuildTaskGraph defaultIncludedBuildTaskGraph2 = this;
            synchronized (defaultIncludedBuildTaskGraph2) {
                if (this.owner != Thread.currentThread()) {
                    throw new IllegalStateException("This task graph is in use by another thread.");
                }
                this.owner = currentOwner;
            }
        }
    }

    private class TaskBackedResource
    implements IncludedBuildTaskResource {
        private final IncludedBuildController buildController;
        private final ExportedTaskNode taskNode;

        public TaskBackedResource(IncludedBuildController buildController, ExportedTaskNode taskNode) {
            this.buildController = buildController;
            this.taskNode = taskNode;
        }

        public void queueForExecution() {
            DefaultIncludedBuildTaskGraph.this.queueForExecution(this.buildController, this.taskNode);
        }

        public TaskInternal getTask() {
            return this.taskNode.getTask();
        }

        public IncludedBuildTaskResource.State getTaskState() {
            return this.taskNode.getTaskState();
        }
    }

    private static enum State {
        NotCreated,
        NotPrepared,
        QueuingTasks,
        Populated,
        ReadyToRun,
        Running,
        Finished;

    }
}

