/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.internal.build.BuildState;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;
    private final BuildIdentifier currentBuild;

    public CompositeBuildClassPathInitializer(IncludedBuildTaskGraph includedBuildTaskGraph, BuildState currentBuild) {
        this.includedBuildTaskGraph = includedBuildTaskGraph;
        this.currentBuild = currentBuild.getBuildIdentifier();
    }

    public void execute(Configuration classpath) {
        ArtifactCollection artifacts = classpath.getIncoming().getArtifacts();
        ArrayList<CompositeProjectComponentArtifactMetadata> localArtifacts = new ArrayList<CompositeProjectComponentArtifactMetadata>();
        for (ResolvedArtifactResult artifactResult : artifacts.getArtifacts()) {
            ComponentArtifactIdentifier artifactIdentifier = artifactResult.getId();
            if (!(artifactIdentifier instanceof CompositeProjectComponentArtifactMetadata)) continue;
            localArtifacts.add((CompositeProjectComponentArtifactMetadata)artifactIdentifier);
        }
        if (!localArtifacts.isEmpty()) {
            this.includedBuildTaskGraph.withNewTaskGraph(() -> {
                this.includedBuildTaskGraph.prepareTaskGraph(() -> {
                    for (CompositeProjectComponentArtifactMetadata artifact : localArtifacts) {
                        this.scheduleTasks(this.currentBuild, artifact);
                    }
                    this.includedBuildTaskGraph.populateTaskGraphs();
                });
                this.includedBuildTaskGraph.runScheduledTasks();
                return null;
            });
        }
    }

    public void scheduleTasks(BuildIdentifier requestingBuild, CompositeProjectComponentArtifactMetadata artifact) {
        BuildIdentifier targetBuild = artifact.getComponentId().getBuild();
        assert (!requestingBuild.equals(targetBuild));
        Set tasks = artifact.getBuildDependencies().getDependencies(null);
        for (Task task : tasks) {
            this.includedBuildTaskGraph.locateTask(targetBuild, (TaskInternal)task).queueForExecution();
        }
    }
}

