/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.file.collections.FailingFileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.scala.ScalaPluginExtension;

public class ScalaRuntime {
    private static final Pattern SCALA_JAR_PATTERN = Pattern.compile("scala-(\\w.*?)-(\\d.*).jar");
    private final Project project;
    private final JvmEcosystemUtilities jvmEcosystemUtilities;

    public ScalaRuntime(Project project) {
        this.project = project;
        this.jvmEcosystemUtilities = (JvmEcosystemUtilities)((ProjectInternal)project).getServices().get(JvmEcosystemUtilities.class);
    }

    public FileCollection inferScalaClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(){

            public String getDisplayName() {
                return "Scala runtime classpath";
            }

            public FileCollection createDelegate() {
                try {
                    return this.inferScalaClasspath();
                }
                catch (RuntimeException e) {
                    return new FailingFileCollection(this.getDisplayName(), e);
                }
            }

            private Configuration inferScalaClasspath() {
                File scalaLibraryJar = ScalaRuntime.this.findScalaJar(classpath, "library");
                if (scalaLibraryJar == null) {
                    throw new GradleException(String.format("Cannot infer Scala class path because no Scala library Jar was found. Does %s declare dependency to scala-library? Searched classpath: %s.", ScalaRuntime.this.project, classpath));
                }
                String scalaVersion = ScalaRuntime.this.getScalaVersion(scalaLibraryJar);
                if (scalaVersion == null) {
                    throw new AssertionError((Object)String.format("Unexpectedly failed to parse version of Scala Jar file: %s in %s", scalaLibraryJar, ScalaRuntime.this.project));
                }
                String zincVersion = (String)((ScalaPluginExtension)ScalaRuntime.this.project.getExtensions().getByType(ScalaPluginExtension.class)).getZincVersion().get();
                String scalaMajorMinorVersion = Joiner.on((char)'.').join(Splitter.on((char)'.').splitToList((CharSequence)scalaVersion).subList(0, 2));
                DefaultExternalModuleDependency compilerBridgeJar = new DefaultExternalModuleDependency("org.scala-sbt", "compiler-bridge_" + scalaMajorMinorVersion, zincVersion);
                compilerBridgeJar.setTransitive(false);
                compilerBridgeJar.artifact(artifact -> {
                    artifact.setClassifier("sources");
                    artifact.setType("jar");
                    artifact.setExtension("jar");
                    artifact.setName(compilerBridgeJar.getName());
                });
                DefaultExternalModuleDependency compilerInterfaceJar = new DefaultExternalModuleDependency("org.scala-sbt", "compiler-interface", zincVersion);
                Configuration scalaRuntimeClasspath = ScalaRuntime.this.project.getConfigurations().detachedConfiguration(new Dependency[]{new DefaultExternalModuleDependency("org.scala-lang", "scala-compiler", scalaVersion), compilerBridgeJar, compilerInterfaceJar});
                ScalaRuntime.this.jvmEcosystemUtilities.configureAsRuntimeClasspath((HasConfigurableAttributes)scalaRuntimeClasspath);
                return scalaRuntimeClasspath;
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add((Object)classpath);
                }
            }
        };
    }

    @Nullable
    public File findScalaJar(Iterable<File> classpath, String appendix) {
        for (File file : classpath) {
            Matcher matcher = SCALA_JAR_PATTERN.matcher(file.getName());
            if (!matcher.matches() || !matcher.group(1).equals(appendix)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public String getScalaVersion(File scalaJar) {
        Matcher matcher = SCALA_JAR_PATTERN.matcher(scalaJar.getName());
        return matcher.matches() ? matcher.group(2) : null;
    }
}

