/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultBuildLifecycleController
implements BuildLifecycleController {
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final BuildCompletionListener buildCompletionListener;
    private final InternalBuildFinishedListener buildFinishedListener;
    private final BuildWorkPreparer workPreparer;
    private final BuildWorkExecutor workExecutor;
    private final BuildScopeServices buildServices;
    private final GradleInternal gradle;
    private final BuildModelController modelController;
    private State state = State.Created;
    @Nullable
    private ExecutionResult<?> stageFailures;

    public DefaultBuildLifecycleController(GradleInternal gradle, BuildModelController buildModelController, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, BuildCompletionListener buildCompletionListener, InternalBuildFinishedListener buildFinishedListener, BuildWorkPreparer workPreparer, BuildWorkExecutor workExecutor, BuildScopeServices buildServices) {
        this.gradle = gradle;
        this.modelController = buildModelController;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.workPreparer = workPreparer;
        this.workExecutor = workExecutor;
        this.buildCompletionListener = buildCompletionListener;
        this.buildFinishedListener = buildFinishedListener;
        this.buildServices = buildServices;
    }

    @Override
    public GradleInternal getGradle() {
        if (this.state == State.Finished) {
            throw new IllegalStateException("Cannot use Gradle object after build has finished.");
        }
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.withModelOrThrow(this.modelController::getLoadedSettings);
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.withModelOrThrow(this.modelController::getConfiguredModel);
    }

    @Override
    public void prepareToScheduleTasks() {
        this.withModelOrThrow(() -> {
            this.state = State.TaskGraph;
            this.modelController.prepareToScheduleTasks();
            return null;
        });
    }

    @Override
    public void scheduleRequestedTasks() {
        this.withModelOrThrow(() -> {
            this.state = State.TaskGraph;
            this.modelController.prepareToScheduleTasks();
            this.workPreparer.populateWorkGraph(this.gradle, taskGraph -> this.modelController.scheduleRequestedTasks());
            return null;
        });
    }

    @Override
    public void populateWorkGraph(Consumer<? super TaskExecutionGraphInternal> action) {
        this.withModelOrThrow(() -> {
            this.state = State.TaskGraph;
            this.modelController.prepareToScheduleTasks();
            this.workPreparer.populateWorkGraph(this.gradle, action);
            return null;
        });
    }

    @Override
    public ExecutionResult<Void> executeTasks() {
        return this.withModel(() -> {
            if (this.state != State.TaskGraph) {
                throw new IllegalStateException("Cannot execute tasks as none have been scheduled for this build yet.");
            }
            return this.workExecutor.execute(this.gradle);
        });
    }

    private <T> T withModelOrThrow(Supplier<T> action) {
        return this.withModel(() -> {
            try {
                Object result = action.get();
                return ExecutionResult.succeeded(result);
            }
            catch (Throwable t) {
                return ExecutionResult.failed(this.exceptionAnalyser.transform(t));
            }
        }).getValueOrRethrow();
    }

    private <T> ExecutionResult<T> withModel(Supplier<ExecutionResult<T>> action) {
        if (this.stageFailures != null) {
            throw new IllegalStateException("Cannot do further work as this build has failed.", this.stageFailures.getFailure());
        }
        if (this.state == State.Finished) {
            throw new IllegalStateException("Cannot do further work as this build has finished.");
        }
        ExecutionResult<T> result = action.get();
        if (this.state == State.Created) {
            this.state = State.Configure;
        }
        if (!result.getFailures().isEmpty()) {
            this.stageFailures = result;
        }
        return result;
    }

    @Override
    public ExecutionResult<Void> finishBuild(@Nullable Throwable failure) {
        ExecutionResult<Void> finishResult;
        if (this.state == State.Finished) {
            return ExecutionResult.succeeded();
        }
        Throwable reportableFailure = failure;
        if (reportableFailure == null && this.stageFailures != null) {
            reportableFailure = this.exceptionAnalyser.transform(this.stageFailures.getFailures());
        }
        BuildResult buildResult = new BuildResult(this.state.getDisplayName(), (Gradle)this.gradle, reportableFailure);
        try {
            this.buildListener.buildFinished(buildResult);
            this.buildFinishedListener.buildFinished((GradleInternal)buildResult.getGradle(), buildResult.getFailure() != null);
            finishResult = ExecutionResult.succeeded();
        }
        catch (Throwable t) {
            finishResult = ExecutionResult.failed(t);
        }
        this.state = State.Finished;
        this.stageFailures = null;
        return finishResult;
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    public void stop() {
        if (this.state != State.Created && this.state != State.Finished) {
            throw new IllegalStateException("This build has not been finished.");
        }
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private static enum State {
        Created,
        Configure,
        TaskGraph,
        Finished;


        String getDisplayName() {
            if (TaskGraph == this) {
                return "Build";
            }
            return "Configure";
        }
    }
}

